# Generated by Django 2.1.8 on 2019-05-31 04:46

from django.db import migrations, models
import django.db.models.deletion


def default_probe(apps, schema_editor):
    Probe = apps.get_model("promgen", "Probe")
    Probe.objects.get_or_create(
        pk=1, defaults={"module": "http_2xx", "description": "Default http check"}
    )


class Migration(migrations.Migration):

    dependencies = [("promgen", "0008_shard_service")]

    operations = [
        migrations.CreateModel(
            name="Probe",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "module",
                    models.CharField(
                        max_length=128,
                        help_text="Probe Module from blackbox_exporter config",
                        unique=True,
                    ),
                ),
                ("description", models.TextField(blank=True)),
            ],
        ),
        migrations.RunPython(default_probe, migrations.RunPython.noop),
        migrations.AddField(
            model_name="url",
            name="probe",
            field=models.ForeignKey(
                default=1,
                on_delete=django.db.models.deletion.CASCADE,
                to="promgen.Probe",
            ),
            preserve_default=False,
        ),
    ]
