import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * (experimental) Statement provider for service [aws-portal](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsbilling.html).
 *
 * @experimental
 */
export declare class AwsPortal extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Statement provider for service [aws-portal](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsbilling.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid?: string);
    /**
     * (experimental) Allow or deny IAM users permission to modify Account Settings.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-permissions-ref.html#user-permissions
     *
     * @experimental
     */
    toModifyAccount(): this;
    /**
     * (experimental) Allow or deny IAM users permission to modify billing settings.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-permissions-ref.html#user-permissions
     *
     * @experimental
     */
    toModifyBilling(): this;
    /**
     * (experimental) Allow or deny IAM users permission to modify payment methods.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-permissions-ref.html#user-permissions
     *
     * @experimental
     */
    toModifyPaymentMethods(): this;
    /**
     * (experimental) Allow or deny IAM users permission to view account settings.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-permissions-ref.html#user-permissions
     *
     * @experimental
     */
    toViewAccount(): this;
    /**
     * (experimental) Allow or deny IAM users permission to view billing pages in the console.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-permissions-ref.html#user-permissions
     *
     * @experimental
     */
    toViewBilling(): this;
    /**
     * (experimental) Allow or deny IAM users permission to view payment methods.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-permissions-ref.html#user-permissions
     *
     * @experimental
     */
    toViewPaymentMethods(): this;
    /**
     * (experimental) Allow or deny IAM users permission to view AWS usage reports.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-permissions-ref.html#user-permissions
     *
     * @experimental
     */
    toViewUsage(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
}
