import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * (experimental) Statement provider for service [voiceid](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonconnectvoiceid.html).
 *
 * @experimental
 */
export declare class Voiceid extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Statement provider for service [voiceid](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonconnectvoiceid.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid?: string);
    /**
     * (experimental) Grants permission to create a domain.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/voiceid/latest/APIReference/API_CreateDomain.html
     *
     * @experimental
     */
    toCreateDomain(): this;
    /**
     * (experimental) Grants permission to delete a domain.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/voiceid/latest/APIReference/API_DeleteDomain.html
     *
     * @experimental
     */
    toDeleteDomain(): this;
    /**
     * (experimental) Grants permission to delete a fraudster.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/voiceid/latest/APIReference/API_DeleteFraudster.html
     *
     * @experimental
     */
    toDeleteFraudster(): this;
    /**
     * (experimental) Grants permission to delete a speaker.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/voiceid/latest/APIReference/API_DeleteSpeaker.html
     *
     * @experimental
     */
    toDeleteSpeaker(): this;
    /**
     * (experimental) Grants permission to describe compliance consent.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/enable-voiceid.html#enable-voiceid-step1
     *
     * @experimental
     */
    toDescribeComplianceConsent(): this;
    /**
     * (experimental) Grants permission to describe a domain.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/voiceid/latest/APIReference/API_DescribeDomain.html
     *
     * @experimental
     */
    toDescribeDomain(): this;
    /**
     * (experimental) Grants permission to describe a fraudster.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/voiceid/latest/APIReference/API_DescribeFraudster.html
     *
     * @experimental
     */
    toDescribeFraudster(): this;
    /**
     * (experimental) Grants permission to describe a fraudster registration job.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/voiceid/latest/APIReference/API_DescribeFraudsterRegistrationJob.html
     *
     * @experimental
     */
    toDescribeFraudsterRegistrationJob(): this;
    /**
     * (experimental) Grants permission to describe a speaker.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/voiceid/latest/APIReference/API_DescribeSpeaker.html
     *
     * @experimental
     */
    toDescribeSpeaker(): this;
    /**
     * (experimental) Grants permission to describe a speaker enrollment job.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/voiceid/latest/APIReference/API_DescribeSpeakerEnrollmentJob.html
     *
     * @experimental
     */
    toDescribeSpeakerEnrollmentJob(): this;
    /**
     * (experimental) Grants permission to evaluate a session.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/voiceid/latest/APIReference/API_EvaluateSession.html
     *
     * @experimental
     */
    toEvaluateSession(): this;
    /**
     * (experimental) Grants permission to list domains for an account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/voiceid/latest/APIReference/API_ListDomains.html
     *
     * @experimental
     */
    toListDomains(): this;
    /**
     * (experimental) Grants permission to list fraudster registration jobs for a domain.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/voiceid/latest/APIReference/API_ListFraudsterRegistrationJobs.html
     *
     * @experimental
     */
    toListFraudsterRegistrationJobs(): this;
    /**
     * (experimental) Grants permission to list speaker enrollment jobs for a domain.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/voiceid/latest/APIReference/API_ListSpeakerEnrollmentJobs.html
     *
     * @experimental
     */
    toListSpeakerEnrollmentJobs(): this;
    /**
     * (experimental) Grants permission to list speakers for a domain.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/voiceid/latest/APIReference/API_ListSpeakers.html
     *
     * @experimental
     */
    toListSpeakers(): this;
    /**
     * (experimental) Grants permission to list tags for a Voice ID resource.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/voiceid/latest/APIReference/API_ListTagsForResource.html
     *
     * @experimental
     */
    toListTagsForResource(): this;
    /**
     * (experimental) Grants permission to opt out a speaker.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/voiceid/latest/APIReference/API_OptOutSpeaker.html
     *
     * @experimental
     */
    toOptOutSpeaker(): this;
    /**
     * (experimental) Grants permission to register compliance consent.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/enable-voiceid.html#enable-voiceid-step1
     *
     * @experimental
     */
    toRegisterComplianceConsent(): this;
    /**
     * (experimental) Grants permission to start a fraudster registration job.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/voiceid/latest/APIReference/API_StartFraudsterRegistrationJob.html
     *
     * @experimental
     */
    toStartFraudsterRegistrationJob(): this;
    /**
     * (experimental) Grants permission to start a speaker enrollment job.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/voiceid/latest/APIReference/API_StartSpeakerEnrollmentJob.html
     *
     * @experimental
     */
    toStartSpeakerEnrollmentJob(): this;
    /**
     * (experimental) Grants permission to tag a Voice ID resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/voiceid/latest/APIReference/API_TagResource.html
     *
     * @experimental
     */
    toTagResource(): this;
    /**
     * (experimental) Grants permission to remove a tag from a Voice ID resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/voiceid/latest/APIReference/API_UntagResource.html
     *
     * @experimental
     */
    toUntagResource(): this;
    /**
     * (experimental) Grants permission to update a domain.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/voiceid/latest/APIReference/API_UpdateDomain.html
     *
     * @experimental
     */
    toUpdateDomain(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type domain to the statement.
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/enable-voiceid.html#voiceid-domain
     *
     * @param domainId - Identifier for the domainId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onDomain(domainId: string, account?: string, region?: string, partition?: string): this;
}
