import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * (experimental) Statement provider for service [iotwireless](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiotcoreforlorawan.html).
 *
 * @experimental
 */
export declare class Iotwireless extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Statement provider for service [iotwireless](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiotcoreforlorawan.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid?: string);
    /**
     * (experimental) Grants permission to link partner accounts with Aws account.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_AssociateAwsAccountWithPartnerAccount.html
     *
     * @experimental
     */
    toAssociateAwsAccountWithPartnerAccount(): this;
    /**
     * (experimental) Grants permission to associate the MulticastGroup with FuotaTask.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_AssociateMulticastGroupWithFuotaTask.html
     *
     * @experimental
     */
    toAssociateMulticastGroupWithFuotaTask(): this;
    /**
     * (experimental) Grants permission to associate the wireless device with FuotaTask.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_AssociateWirelessDeviceWithFuotaTask.html
     *
     * @experimental
     */
    toAssociateWirelessDeviceWithFuotaTask(): this;
    /**
     * (experimental) Grants permission to associate the WirelessDevice with MulticastGroup.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_AssociateWirelessDeviceWithMulticastGroup.html
     *
     * @experimental
     */
    toAssociateWirelessDeviceWithMulticastGroup(): this;
    /**
     * (experimental) Grants permission to associate the wireless device with AWS IoT thing for a given wirelessDeviceId.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iot:DescribeThing
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_AssociateWirelessDeviceWithThing.html
     *
     * @experimental
     */
    toAssociateWirelessDeviceWithThing(): this;
    /**
     * (experimental) Grants permission to associate a WirelessGateway with the IoT Core Identity certificate.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_AssociateWirelessGatewayWithCertificate.html
     *
     * @experimental
     */
    toAssociateWirelessGatewayWithCertificate(): this;
    /**
     * (experimental) Grants permission to associate the wireless gateway with AWS IoT thing for a given wirelessGatewayId.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iot:DescribeThing
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_AssociateWirelessGatewayWithThing.html
     *
     * @experimental
     */
    toAssociateWirelessGatewayWithThing(): this;
    /**
     * (experimental) Grants permission to cancel the MulticastGroup session.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_CancelMulticastGroupSession.html
     *
     * @experimental
     */
    toCancelMulticastGroupSession(): this;
    /**
     * (experimental) Grants permission to create a Destination resource.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_CreateDestination.html
     *
     * @experimental
     */
    toCreateDestination(): this;
    /**
     * (experimental) Grants permission to create a DeviceProfile resource.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_CreateDeviceProfile.html
     *
     * @experimental
     */
    toCreateDeviceProfile(): this;
    /**
     * (experimental) Grants permission to create a FuotaTask resource.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_CreateFuotaTask.html
     *
     * @experimental
     */
    toCreateFuotaTask(): this;
    /**
     * (experimental) Grants permission to create a MulticastGroup resource.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_CreateMulticastGroup.html
     *
     * @experimental
     */
    toCreateMulticastGroup(): this;
    /**
     * (experimental) Grants permission to create a ServiceProfile resource.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_CreateServiceProfile.html
     *
     * @experimental
     */
    toCreateServiceProfile(): this;
    /**
     * (experimental) Grants permission to create a WirelessDevice resource with given Destination.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_CreateWirelessDevice.html
     *
     * @experimental
     */
    toCreateWirelessDevice(): this;
    /**
     * (experimental) Grants permission to create a WirelessGateway resource.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_CreateWirelessGateway.html
     *
     * @experimental
     */
    toCreateWirelessGateway(): this;
    /**
     * (experimental) Grants permission to create a task for a given WirelessGateway.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_CreateWirelessGatewayTask.html
     *
     * @experimental
     */
    toCreateWirelessGatewayTask(): this;
    /**
     * (experimental) Grants permission to create a WirelessGateway task definition.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_CreateWirelessGatewayTaskDefinition.html
     *
     * @experimental
     */
    toCreateWirelessGatewayTaskDefinition(): this;
    /**
     * (experimental) Grants permission to delete a Destination.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_DeleteDestination.html
     *
     * @experimental
     */
    toDeleteDestination(): this;
    /**
     * (experimental) Grants permission to delete a DeviceProfile.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_DeleteDeviceProfile.html
     *
     * @experimental
     */
    toDeleteDeviceProfile(): this;
    /**
     * (experimental) Grants permission to delete the FuotaTask.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_DeleteFuotaTask.html
     *
     * @experimental
     */
    toDeleteFuotaTask(): this;
    /**
     * (experimental) Grants permission to delete the MulticastGroup.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_DeleteMulticastGroup.html
     *
     * @experimental
     */
    toDeleteMulticastGroup(): this;
    /**
     * (experimental) Grants permission to delete a ServiceProfile.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_DeleteServiceProfile.html
     *
     * @experimental
     */
    toDeleteServiceProfile(): this;
    /**
     * (experimental) Grants permission to delete a WirelessDevice.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_DeleteWirelessDevice.html
     *
     * @experimental
     */
    toDeleteWirelessDevice(): this;
    /**
     * (experimental) Grants permission to delete a WirelessGateway.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_DeleteWirelessGateway.html
     *
     * @experimental
     */
    toDeleteWirelessGateway(): this;
    /**
     * (experimental) Grants permission to delete task for a given WirelessGateway.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_DeleteWirelessGatewayTask.html
     *
     * @experimental
     */
    toDeleteWirelessGatewayTask(): this;
    /**
     * (experimental) Grants permission to delete a WirelessGateway task definition.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_DeleteWirelessGatewayTaskDefinition.html
     *
     * @experimental
     */
    toDeleteWirelessGatewayTaskDefinition(): this;
    /**
     * (experimental) Grants permission to disassociate an AWS account from a partner account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_DisassociateAwsAccountFromPartnerAccount.html
     *
     * @experimental
     */
    toDisassociateAwsAccountFromPartnerAccount(): this;
    /**
     * (experimental) Grants permission to disassociate the MulticastGroup from FuotaTask.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_DisassociateMulticastGroupFromFuotaTask.html
     *
     * @experimental
     */
    toDisassociateMulticastGroupFromFuotaTask(): this;
    /**
     * (experimental) Grants permission to disassociate the wireless device from FuotaTask.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_DisassociateWirelessDeviceFromFuotaTask.html
     *
     * @experimental
     */
    toDisassociateWirelessDeviceFromFuotaTask(): this;
    /**
     * (experimental) Grants permission to disassociate the wireless device from MulticastGroup.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_DisassociateWirelessDeviceFromMulticastGroup.html
     *
     * @experimental
     */
    toDisassociateWirelessDeviceFromMulticastGroup(): this;
    /**
     * (experimental) Grants permission to disassociate a wireless device from a AWS IoT thing.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iot:DescribeThing
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_DisassociateWirelessDeviceFromThing.html
     *
     * @experimental
     */
    toDisassociateWirelessDeviceFromThing(): this;
    /**
     * (experimental) Grants permission to disassociate a WirelessGateway from a IoT Core Identity certificate.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_DisassociateWirelessGatewayFromCertificate.html
     *
     * @experimental
     */
    toDisassociateWirelessGatewayFromCertificate(): this;
    /**
     * (experimental) Grants permission to disassociate a WirelessGateway from a IoT Core thing.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iot:DescribeThing
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_DisassociateWirelessGatewayFromThing.html
     *
     * @experimental
     */
    toDisassociateWirelessGatewayFromThing(): this;
    /**
     * (experimental) Grants permission to get the Destination.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetDestination.html
     *
     * @experimental
     */
    toGetDestination(): this;
    /**
     * (experimental) Grants permission to get the DeviceProfile.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetDeviceProfile.html
     *
     * @experimental
     */
    toGetDeviceProfile(): this;
    /**
     * (experimental) Grants permission to get the FuotaTask.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetFuotaTask.html
     *
     * @experimental
     */
    toGetFuotaTask(): this;
    /**
     * (experimental) Grants permission to get log levels by resource types.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetLogLevelsByResourceTypes.html
     *
     * @experimental
     */
    toGetLogLevelsByResourceTypes(): this;
    /**
     * (experimental) Grants permission to get the MulticastGroup.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetMulticastGroup.html
     *
     * @experimental
     */
    toGetMulticastGroup(): this;
    /**
     * (experimental) Grants permission to get the MulticastGroup session.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetMulticastGroupSession.html
     *
     * @experimental
     */
    toGetMulticastGroupSession(): this;
    /**
     * (experimental) Grants permission to get the associated PartnerAccount.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetPartnerAccount.html
     *
     * @experimental
     */
    toGetPartnerAccount(): this;
    /**
     * (experimental) Grants permission to get an event configuration for an identifier.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetResourceEventConfiguration.html
     *
     * @experimental
     */
    toGetResourceEventConfiguration(): this;
    /**
     * (experimental) Grants permission to get resource log level.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetResourceLogLevel.html
     *
     * @experimental
     */
    toGetResourceLogLevel(): this;
    /**
     * (experimental) Grants permission to retrieve the customer account specific endpoint for CUPS protocol connection or LoRaWAN Network Server (LNS) protocol connection, and optionally server trust certificate in PEM format.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetServiceEndpoint.html
     *
     * @experimental
     */
    toGetServiceEndpoint(): this;
    /**
     * (experimental) Grants permission to get the ServiceProfile.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetServiceProfile.html
     *
     * @experimental
     */
    toGetServiceProfile(): this;
    /**
     * (experimental) Grants permission to get the WirelessDevice.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetWirelessDevice.html
     *
     * @experimental
     */
    toGetWirelessDevice(): this;
    /**
     * (experimental) Grants permission to get statistics info for a given WirelessDevice.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetWirelessDeviceStatistics.html
     *
     * @experimental
     */
    toGetWirelessDeviceStatistics(): this;
    /**
     * (experimental) Grants permission to get the WirelessGateway.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetWirelessGateway.html
     *
     * @experimental
     */
    toGetWirelessGateway(): this;
    /**
     * (experimental) Grants permission to get the IoT Core Identity certificate id associated with the WirelessGateway.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetWirelessGatewayCertificate.html
     *
     * @experimental
     */
    toGetWirelessGatewayCertificate(): this;
    /**
     * (experimental) Grants permission to get Current firmware version and other information for the WirelessGateway.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetWirelessGatewayFirmwareInformation.html
     *
     * @experimental
     */
    toGetWirelessGatewayFirmwareInformation(): this;
    /**
     * (experimental) Grants permission to get statistics info for a given WirelessGateway.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetWirelessGatewayStatistics.html
     *
     * @experimental
     */
    toGetWirelessGatewayStatistics(): this;
    /**
     * (experimental) Grants permission to get the task for a given WirelessGateway.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetWirelessGatewayTask.html
     *
     * @experimental
     */
    toGetWirelessGatewayTask(): this;
    /**
     * (experimental) Grants permission to get the given WirelessGateway task definition.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetWirelessGatewayTaskDefinition.html
     *
     * @experimental
     */
    toGetWirelessGatewayTaskDefinition(): this;
    /**
     * (experimental) Grants permission to list information of available Destinations based on the AWS account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_ListDestinations.html
     *
     * @experimental
     */
    toListDestinations(): this;
    /**
     * (experimental) Grants permission to list information of available DeviceProfiles based on the AWS account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_ListDeviceProfiles.html
     *
     * @experimental
     */
    toListDeviceProfiles(): this;
    /**
     * (experimental) Grants permission to list information of available FuotaTasks based on the AWS account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_ListFuotaTasks.html
     *
     * @experimental
     */
    toListFuotaTasks(): this;
    /**
     * (experimental) Grants permission to list information of available MulticastGroups based on the AWS account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_ListMulticastGroups.html
     *
     * @experimental
     */
    toListMulticastGroups(): this;
    /**
     * (experimental) Grants permission to list information of available MulticastGroups by FuotaTask based on the AWS account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_ListMulticastGroupsByFuotaTask.html
     *
     * @experimental
     */
    toListMulticastGroupsByFuotaTask(): this;
    /**
     * (experimental) Grants permission to list the available partner accounts.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_ListPartnerAccounts.html
     *
     * @experimental
     */
    toListPartnerAccounts(): this;
    /**
     * (experimental) Grants permission to list information of available ServiceProfiles based on the AWS account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_ListServiceProfiles.html
     *
     * @experimental
     */
    toListServiceProfiles(): this;
    /**
     * (experimental) Grants permission to list all tags for a given resource.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_ListTagsForResource.html
     *
     * @experimental
     */
    toListTagsForResource(): this;
    /**
     * (experimental) Grants permission to list information of available WirelessDevices based on the AWS account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_ListWirelessDevices.html
     *
     * @experimental
     */
    toListWirelessDevices(): this;
    /**
     * (experimental) Grants permission to list information of available WirelessGateway task definitions based on the AWS account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_ListWirelessGatewayTaskDefinitions.html
     *
     * @experimental
     */
    toListWirelessGatewayTaskDefinitions(): this;
    /**
     * (experimental) Grants permission to list information of available WirelessGateways based on the AWS account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_ListWirelessGateways.html
     *
     * @experimental
     */
    toListWirelessGateways(): this;
    /**
     * (experimental) Grants permission to put resource log level.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_PutResourceLogLevel.html
     *
     * @experimental
     */
    toPutResourceLogLevel(): this;
    /**
     * (experimental) Grants permission to reset all resource log levels.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_ResetAllResourceLogLevels.html
     *
     * @experimental
     */
    toResetAllResourceLogLevels(): this;
    /**
     * (experimental) Grants permission to reset resource log level.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_ResetResourceLogLevel.html
     *
     * @experimental
     */
    toResetResourceLogLevel(): this;
    /**
     * (experimental) Grants permission to send data to the MulticastGroup.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_SendDataToMulticastGroup.html
     *
     * @experimental
     */
    toSendDataToMulticastGroup(): this;
    /**
     * (experimental) Grants permission to send the decrypted application data frame to the target device.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_SendDataToWirelessDevice.html
     *
     * @experimental
     */
    toSendDataToWirelessDevice(): this;
    /**
     * (experimental) Grants permission to associate the WirelessDevices with MulticastGroup.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_StartBulkAssociateWirelessDeviceWithMulticastGroup.html
     *
     * @experimental
     */
    toStartBulkAssociateWirelessDeviceWithMulticastGroup(): this;
    /**
     * (experimental) Grants permission to bulk disassociate the WirelessDevices from MulticastGroup.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_StartBulkDisassociateWirelessDeviceFromMulticastGroup.html
     *
     * @experimental
     */
    toStartBulkDisassociateWirelessDeviceFromMulticastGroup(): this;
    /**
     * (experimental) Grants permission to start the FuotaTask.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_StartFuotaTask.html
     *
     * @experimental
     */
    toStartFuotaTask(): this;
    /**
     * (experimental) Grants permission to start the MulticastGroup session.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_StartMulticastGroupSession.html
     *
     * @experimental
     */
    toStartMulticastGroupSession(): this;
    /**
     * (experimental) Grants permission to tag a given resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_TagResource.html
     *
     * @experimental
     */
    toTagResource(): this;
    /**
     * (experimental) Grants permission to simulate a provisioned device to send an uplink data with payload of 'Hello'.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_TestWirelessDevice.html
     *
     * @experimental
     */
    toTestWirelessDevice(): this;
    /**
     * (experimental) Grants permission to remove the given tags from the resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_UntagResource.html
     *
     * @experimental
     */
    toUntagResource(): this;
    /**
     * (experimental) Grants permission to update a Destination resource.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_UpdateDestination.html
     *
     * @experimental
     */
    toUpdateDestination(): this;
    /**
     * (experimental) Grants permission to update the FuotaTask.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_UpdateFuotaTask.html
     *
     * @experimental
     */
    toUpdateFuotaTask(): this;
    /**
     * (experimental) Grants permission to update log levels by resource types.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_UpdateLogLevelsByResourceTypes.html
     *
     * @experimental
     */
    toUpdateLogLevelsByResourceTypes(): this;
    /**
     * (experimental) Grants permission to update the MulticastGroup.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_UpdateMulticastGroup.html
     *
     * @experimental
     */
    toUpdateMulticastGroup(): this;
    /**
     * (experimental) Grants permission to update a partner account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_UpdatePartnerAccount.html
     *
     * @experimental
     */
    toUpdatePartnerAccount(): this;
    /**
     * (experimental) Grants permission to update an event configuration for an identifier.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_UpdateResourceEventConfiguration.html
     *
     * @experimental
     */
    toUpdateResourceEventConfiguration(): this;
    /**
     * (experimental) Grants permission to update a WirelessDevice resource.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_UpdateWirelessDevice.html
     *
     * @experimental
     */
    toUpdateWirelessDevice(): this;
    /**
     * (experimental) Grants permission to update a WirelessGateway resource.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_UpdateWirelessGateway.html
     *
     * @experimental
     */
    toUpdateWirelessGateway(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type WirelessDevice to the statement.
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_CreateWirelessDevice.html
     *
     * @param wirelessDeviceId - Identifier for the wirelessDeviceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onWirelessDevice(wirelessDeviceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type WirelessGateway to the statement.
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_CreateWirelessGateway.html
     *
     * @param wirelessGatewayId - Identifier for the wirelessGatewayId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onWirelessGateway(wirelessGatewayId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type DeviceProfile to the statement.
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_CreateDeviceProfile.html
     *
     * @param deviceProfileId - Identifier for the deviceProfileId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onDeviceProfile(deviceProfileId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type ServiceProfile to the statement.
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_CreateServiceProfile.html
     *
     * @param serviceProfileId - Identifier for the serviceProfileId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onServiceProfile(serviceProfileId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type Destination to the statement.
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_CreateDestination.html
     *
     * @param destinationName - Identifier for the destinationName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onDestination(destinationName: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type SidewalkAccount to the statement.
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_AssociateAwsAccountWithPartnerAccount.html
     *
     * @param sidewalkAccountId - Identifier for the sidewalkAccountId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onSidewalkAccount(sidewalkAccountId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type WirelessGatewayTaskDefinition to the statement.
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_CreateWirelessGatewayTaskDefinition.html
     *
     * @param wirelessGatewayTaskDefinitionId - Identifier for the wirelessGatewayTaskDefinitionId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onWirelessGatewayTaskDefinition(wirelessGatewayTaskDefinitionId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type FuotaTask to the statement.
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_CreateFuotaTask.html
     *
     * @param fuotaTaskId - Identifier for the fuotaTaskId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onFuotaTask(fuotaTaskId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type MulticastGroup to the statement.
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_CreateMulticastGroup.html
     *
     * @param multicastGroupId - Identifier for the multicastGroupId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onMulticastGroup(multicastGroupId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type thing to the statement.
     *
     * https://docs.aws.amazon.com/iot/latest/developerguide/thing-registry.html
     *
     * @param thingName - Identifier for the thingName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onThing(thingName: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type cert to the statement.
     *
     * https://docs.aws.amazon.com/iot/latest/developerguide/x509-client-certs.html
     *
     * @param certificate - Identifier for the certificate.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onCert(certificate: string, account?: string, region?: string, partition?: string): this;
}
