"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Sms = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * (experimental) Statement provider for service [sms](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsservermigrationservice.html).
 *
 * @experimental
 */
class Sms extends shared_1.PolicyStatement {
    /**
     * (experimental) Statement provider for service [sms](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsservermigrationservice.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid) {
        super(sid);
        /**
         * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
         *
         * @experimental
         */
        this.servicePrefix = 'sms';
        /**
         * @experimental
         */
        this.accessLevelList = {
            Write: [
                'CreateApp',
                'CreateReplicationJob',
                'DeleteApp',
                'DeleteAppLaunchConfiguration',
                'DeleteAppReplicationConfiguration',
                'DeleteAppValidationConfiguration',
                'DeleteReplicationJob',
                'DeleteServerCatalog',
                'DisassociateConnector',
                'GenerateChangeSet',
                'GenerateTemplate',
                'ImportAppCatalog',
                'ImportServerCatalog',
                'LaunchApp',
                'NotifyAppValidationOutput',
                'PutAppLaunchConfiguration',
                'PutAppReplicationConfiguration',
                'PutAppValidationConfiguration',
                'SendMessage',
                'StartAppReplication',
                'StartOnDemandAppReplication',
                'StartOnDemandReplicationRun',
                'StopAppReplication',
                'TerminateApp',
                'UpdateApp',
                'UpdateReplicationJob'
            ],
            Read: [
                'GetApp',
                'GetAppLaunchConfiguration',
                'GetAppReplicationConfiguration',
                'GetAppValidationConfiguration',
                'GetAppValidationOutput',
                'GetConnectors',
                'GetMessages',
                'GetReplicationJobs',
                'GetReplicationRuns',
                'GetServers'
            ],
            List: [
                'ListApps'
            ]
        };
    }
    /**
     * (experimental) Grants permission to create an application configuration to migrate on-premise application onto AWS.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_CreateApp.html
     *
     * @experimental
     */
    toCreateApp() {
        return this.to('CreateApp');
    }
    /**
     * (experimental) Grants permission to create a job to migrate on-premise server onto AWS.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_CreateReplicationJob.html
     *
     * @experimental
     */
    toCreateReplicationJob() {
        return this.to('CreateReplicationJob');
    }
    /**
     * (experimental) Grants permission to delete an existing application configuration.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_DeleteApp.html
     *
     * @experimental
     */
    toDeleteApp() {
        return this.to('DeleteApp');
    }
    /**
     * (experimental) Grants permission to delete launch configuration for an existing application.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_DeleteAppLaunchConfiguration.html
     *
     * @experimental
     */
    toDeleteAppLaunchConfiguration() {
        return this.to('DeleteAppLaunchConfiguration');
    }
    /**
     * (experimental) Grants permission to delete replication configuration for an existing application.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_DeleteAppReplicationConfiguration.html
     *
     * @experimental
     */
    toDeleteAppReplicationConfiguration() {
        return this.to('DeleteAppReplicationConfiguration');
    }
    /**
     * (experimental) Grants permission to delete validation configuration for an existing application.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_DeleteAppValidationConfiguration.html
     *
     * @experimental
     */
    toDeleteAppValidationConfiguration() {
        return this.to('DeleteAppValidationConfiguration');
    }
    /**
     * (experimental) Grants permission to delete an existing job to migrate on-premise server onto AWS.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_DeleteReplicationJob.html
     *
     * @experimental
     */
    toDeleteReplicationJob() {
        return this.to('DeleteReplicationJob');
    }
    /**
     * (experimental) Grants permission to delete the complete list of on-premise servers gathered into AWS.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_DeleteServerCatalog.html
     *
     * @experimental
     */
    toDeleteServerCatalog() {
        return this.to('DeleteServerCatalog');
    }
    /**
     * (experimental) Grants permission to disassociate a connector that has been associated.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_DisassociateConnector.html
     *
     * @experimental
     */
    toDisassociateConnector() {
        return this.to('DisassociateConnector');
    }
    /**
     * (experimental) Grants permission to generate a changeSet for the CloudFormation stack of an application.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_GenerateChangeSet.html
     *
     * @experimental
     */
    toGenerateChangeSet() {
        return this.to('GenerateChangeSet');
    }
    /**
     * (experimental) Grants permission to generate a CloudFormation template for an existing application.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_GenerateTemplate.html
     *
     * @experimental
     */
    toGenerateTemplate() {
        return this.to('GenerateTemplate');
    }
    /**
     * (experimental) Grants permission to get the configuration and statuses for an existing application.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_GetApp.html
     *
     * @experimental
     */
    toGetApp() {
        return this.to('GetApp');
    }
    /**
     * (experimental) Grants permission to get launch configuration for an existing application.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_GetAppLaunchConfiguration.html
     *
     * @experimental
     */
    toGetAppLaunchConfiguration() {
        return this.to('GetAppLaunchConfiguration');
    }
    /**
     * (experimental) Grants permission to get replication configuration for an existing application.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_GetAppReplicationConfiguration.html
     *
     * @experimental
     */
    toGetAppReplicationConfiguration() {
        return this.to('GetAppReplicationConfiguration');
    }
    /**
     * (experimental) Grants permission to get validation configuration for an existing application.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_GetAppValidationConfiguration.html
     *
     * @experimental
     */
    toGetAppValidationConfiguration() {
        return this.to('GetAppValidationConfiguration');
    }
    /**
     * (experimental) Grants permission to get notification sent from application validation script.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_GetAppValidationOutput.html
     *
     * @experimental
     */
    toGetAppValidationOutput() {
        return this.to('GetAppValidationOutput');
    }
    /**
     * (experimental) Grants permission to get all connectors that have been associated.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_GetConnectors.html
     *
     * @experimental
     */
    toGetConnectors() {
        return this.to('GetConnectors');
    }
    /**
     * (experimental) Grants permission to gets messages from AWS Server Migration Service to Server Migration Connector.
     *
     * Access Level: Read
     *
     * @experimental
     */
    toGetMessages() {
        return this.to('GetMessages');
    }
    /**
     * (experimental) Grants permission to get all existing jobs to migrate on-premise servers onto AWS.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_GetReplicationJobs.html
     *
     * @experimental
     */
    toGetReplicationJobs() {
        return this.to('GetReplicationJobs');
    }
    /**
     * (experimental) Grants permission to get all runs for an existing job.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_GetReplicationRuns.html
     *
     * @experimental
     */
    toGetReplicationRuns() {
        return this.to('GetReplicationRuns');
    }
    /**
     * (experimental) Grants permission to get all servers that have been imported.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_GetServers.html
     *
     * @experimental
     */
    toGetServers() {
        return this.to('GetServers');
    }
    /**
     * (experimental) Grants permission to import application catalog from AWS Application Discovery Service.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_ImportAppCatalog.html
     *
     * @experimental
     */
    toImportAppCatalog() {
        return this.to('ImportAppCatalog');
    }
    /**
     * (experimental) Grants permission to gather a complete list of on-premise servers.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_ImportServerCatalog.html
     *
     * @experimental
     */
    toImportServerCatalog() {
        return this.to('ImportServerCatalog');
    }
    /**
     * (experimental) Grants permission to create and launch a CloudFormation stack for an existing application.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_LaunchApp.html
     *
     * @experimental
     */
    toLaunchApp() {
        return this.to('LaunchApp');
    }
    /**
     * (experimental) Grants permission to get a list of summaries for existing applications.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_ListAppss.html
     *
     * @experimental
     */
    toListApps() {
        return this.to('ListApps');
    }
    /**
     * (experimental) Grants permission to send notification for application validation script.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_NotifyAppValidationOutput.html
     *
     * @experimental
     */
    toNotifyAppValidationOutput() {
        return this.to('NotifyAppValidationOutput');
    }
    /**
     * (experimental) Grants permission to create or update launch configuration for an existing application.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_PutAppLaunchConfiguration.html
     *
     * @experimental
     */
    toPutAppLaunchConfiguration() {
        return this.to('PutAppLaunchConfiguration');
    }
    /**
     * (experimental) Grants permission to create or update replication configuration for an existing application.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_PutAppReplicationConfiguration.html
     *
     * @experimental
     */
    toPutAppReplicationConfiguration() {
        return this.to('PutAppReplicationConfiguration');
    }
    /**
     * (experimental) Grants permission to put validation configuration for an existing application.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_PutAppValidationConfiguration.html
     *
     * @experimental
     */
    toPutAppValidationConfiguration() {
        return this.to('PutAppValidationConfiguration');
    }
    /**
     * (experimental) Grants permission to send message from Server Migration Connector to AWS Server Migration Service.
     *
     * Access Level: Write
     *
     * @experimental
     */
    toSendMessage() {
        return this.to('SendMessage');
    }
    /**
     * (experimental) Grants permission to create and start replication jobs for an existing application.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_StartAppReplication.html
     *
     * @experimental
     */
    toStartAppReplication() {
        return this.to('StartAppReplication');
    }
    /**
     * (experimental) Grants permission to start a replication run for an existing application.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_StartOnDemandAppReplication.html
     *
     * @experimental
     */
    toStartOnDemandAppReplication() {
        return this.to('StartOnDemandAppReplication');
    }
    /**
     * (experimental) Grants permission to start a replication run for an existing replication job.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_StartOnDemandReplicationRun.html
     *
     * @experimental
     */
    toStartOnDemandReplicationRun() {
        return this.to('StartOnDemandReplicationRun');
    }
    /**
     * (experimental) Grants permission to stop and delete replication jobs for an existing application.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_StopAppReplication.html
     *
     * @experimental
     */
    toStopAppReplication() {
        return this.to('StopAppReplication');
    }
    /**
     * (experimental) Grants permission to terminate the CloudFormation stack for an existing application.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_TerminateApp.html
     *
     * @experimental
     */
    toTerminateApp() {
        return this.to('TerminateApp');
    }
    /**
     * (experimental) Grants permission to update an existing application configuration.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_UpdateApp.html
     *
     * @experimental
     */
    toUpdateApp() {
        return this.to('UpdateApp');
    }
    /**
     * (experimental) Grants permission to update an existing job to migrate on-premise server onto AWS.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_UpdateReplicationJob.html
     *
     * @experimental
     */
    toUpdateReplicationJob() {
        return this.to('UpdateReplicationJob');
    }
}
exports.Sms = Sms;
_a = JSII_RTTI_SYMBOL_1;
Sms[_a] = { fqn: "iam-floyd.Sms", version: "0.279.0" };
//# sourceMappingURL=data:application/json;base64,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