"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Textract = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * (experimental) Statement provider for service [textract](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazontextract.html).
 *
 * @experimental
 */
class Textract extends shared_1.PolicyStatement {
    /**
     * (experimental) Statement provider for service [textract](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazontextract.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid) {
        super(sid);
        /**
         * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
         *
         * @experimental
         */
        this.servicePrefix = 'textract';
        /**
         * @experimental
         */
        this.accessLevelList = {
            Read: [
                'AnalyzeDocument',
                'AnalyzeExpense',
                'DetectDocumentText',
                'GetDocumentAnalysis',
                'GetDocumentTextDetection',
                'GetExpenseAnalysis'
            ],
            Write: [
                'StartDocumentAnalysis',
                'StartDocumentTextDetection',
                'StartExpenseAnalysis'
            ]
        };
    }
    /**
     * (experimental) Grants permission to detect instances of real-world document entities within an image provided as input.
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - s3:GetObject
     *
     * https://docs.aws.amazon.com/textract/latest/dg/API_AnalyzeDocument.html
     *
     * @experimental
     */
    toAnalyzeDocument() {
        return this.to('AnalyzeDocument');
    }
    /**
     * (experimental) Grants permission to detect instances of real-world document entities within an image provided as input.
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - s3:GetObject
     *
     * https://docs.aws.amazon.com/textract/latest/dg/API_AnalyzeExpense.html
     *
     * @experimental
     */
    toAnalyzeExpense() {
        return this.to('AnalyzeExpense');
    }
    /**
     * (experimental) Grants permission to detect text in document images.
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - s3:GetObject
     *
     * https://docs.aws.amazon.com/textract/latest/dg/API_DetectDocumentText.html
     *
     * @experimental
     */
    toDetectDocumentText() {
        return this.to('DetectDocumentText');
    }
    /**
     * (experimental) Grants permission to return information about a document analysis job.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/textract/latest/dg/API_GetDocumentAnalysis.html
     *
     * @experimental
     */
    toGetDocumentAnalysis() {
        return this.to('GetDocumentAnalysis');
    }
    /**
     * (experimental) Grants permission to return information about a document text detection job.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/textract/latest/dg/API_GetDocumentTextDetection.html
     *
     * @experimental
     */
    toGetDocumentTextDetection() {
        return this.to('GetDocumentTextDetection');
    }
    /**
     * (experimental) Grants permission to return information about an expense analysis job.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/textract/latest/dg/API_GetExpenseAnalysis.html
     *
     * @experimental
     */
    toGetExpenseAnalysis() {
        return this.to('GetExpenseAnalysis');
    }
    /**
     * (experimental) Grants permission to start an asynchronous job to detect instances of real-world document entities within an image or pdf provided as input.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - s3:GetObject
     *
     * https://docs.aws.amazon.com/textract/latest/dg/API_StartDocumentAnalysis.html
     *
     * @experimental
     */
    toStartDocumentAnalysis() {
        return this.to('StartDocumentAnalysis');
    }
    /**
     * (experimental) Grants permission to start an asynchronous job to detect text in document images or pdfs.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - s3:GetObject
     *
     * https://docs.aws.amazon.com/textract/latest/dg/API_StartDocumentTextDetection.html
     *
     * @experimental
     */
    toStartDocumentTextDetection() {
        return this.to('StartDocumentTextDetection');
    }
    /**
     * (experimental) Grants permission to start an asynchronous job to detect instances of invoices or receipts within an image or pdf provided as input.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - s3:GetObject
     *
     * https://docs.aws.amazon.com/textract/latest/dg/API_StartExpenseAnalysis.html
     *
     * @experimental
     */
    toStartExpenseAnalysis() {
        return this.to('StartExpenseAnalysis');
    }
}
exports.Textract = Textract;
_a = JSII_RTTI_SYMBOL_1;
Textract[_a] = { fqn: "iam-floyd.Textract", version: "0.279.0" };
//# sourceMappingURL=data:application/json;base64,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