import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * (experimental) Statement provider for service [workmail](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonworkmail.html).
 *
 * @experimental
 */
export declare class Workmail extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Statement provider for service [workmail](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonworkmail.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid?: string);
    /**
     * (experimental) Grants permission to add a list of members (users or groups) to a group.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/groups_overview.html
     *
     * @experimental
     */
    toAddMembersToGroup(): this;
    /**
     * (experimental) Grants permission to add a member (user or group) to the resource's set of delegates.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_AssociateDelegateToResource.html
     *
     * @experimental
     */
    toAssociateDelegateToResource(): this;
    /**
     * (experimental) Grants permission to add a member (user or group) to the group's set.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_AssociateMemberToGroup.html
     *
     * @experimental
     */
    toAssociateMemberToGroup(): this;
    /**
     * (experimental) Grants permission to cancel a currently running mailbox export job.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_CancelMailboxExportJob.html
     *
     * @experimental
     */
    toCancelMailboxExportJob(): this;
    /**
     * (experimental) Grants permission to add an alias to the set of a given member (user or group) of WorkMail.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_CreateAlias.html
     *
     * @experimental
     */
    toCreateAlias(): this;
    /**
     * (experimental) Grants permission to create a group that can be used in WorkMail by calling the RegisterToWorkMail operation.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_CreateGroup.html
     *
     * @experimental
     */
    toCreateGroup(): this;
    /**
     * (experimental) Grants permission to create an inbound email flow rule which will apply to all email sent to an organization.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/create-email-rules.html
     *
     * @experimental
     */
    toCreateInboundMailFlowRule(): this;
    /**
     * (experimental) Grants permission to create a mail domain.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/add_domain.html
     *
     * @experimental
     */
    toCreateMailDomain(): this;
    /**
     * (experimental) Grants permission to create a user in the directory.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/manage-users.html
     *
     * @experimental
     */
    toCreateMailUser(): this;
    /**
     * (experimental) Grants permission to create a new mobile device access rule.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_CreateMobileDeviceAccessRule.html
     *
     * @experimental
     */
    toCreateMobileDeviceAccessRule(): this;
    /**
     * (experimental) Grants permission to create a new Amazon WorkMail organization.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_CreateOrganization.html
     *
     * @experimental
     */
    toCreateOrganization(): this;
    /**
     * (experimental) Grants permission to create an outbound email flow rule which will apply to all email sent from an organization.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/create-email-rules.html
     *
     * @experimental
     */
    toCreateOutboundMailFlowRule(): this;
    /**
     * (experimental) Grants permission to create a new WorkMail resource.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_CreateResource.html
     *
     * @experimental
     */
    toCreateResource(): this;
    /**
     * (experimental) Grants permission to register an SMTP gateway to a WorkMail organization.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/smtp-gateway.html
     *
     * @experimental
     */
    toCreateSmtpGateway(): this;
    /**
     * (experimental) Grants permission to create a user, which can be enabled afterwards by calling the RegisterToWorkMail operation.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_CreateUser.html
     *
     * @experimental
     */
    toCreateUser(): this;
    /**
     * (experimental) Grants permission to delete an access control rule.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_DeleteAccessControlRule.html
     *
     * @experimental
     */
    toDeleteAccessControlRule(): this;
    /**
     * (experimental) Grants permission to remove one or more specified aliases from a set of aliases for a given user.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_DeleteAlias.html
     *
     * @experimental
     */
    toDeleteAlias(): this;
    /**
     * (experimental) Grants permission to delete a group from WorkMail.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_DeleteGroup.html
     *
     * @experimental
     */
    toDeleteGroup(): this;
    /**
     * (experimental) Grants permission to remove an inbound email flow rule to no longer apply to emails sent to an organization.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/remove-email-flow-rule.html
     *
     * @experimental
     */
    toDeleteInboundMailFlowRule(): this;
    /**
     * (experimental) Grants permission to remove an unused mail domain from an organization.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/remove_domain.html
     *
     * @experimental
     */
    toDeleteMailDomain(): this;
    /**
     * (experimental) Grants permission to delete permissions granted to a member (user or group).
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_DeleteMailboxPermissions.html
     *
     * @experimental
     */
    toDeleteMailboxPermissions(): this;
    /**
     * (experimental) Grants permission to remove a mobile device from a user.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/manage-devices.html#remove_mobile_device
     *
     * @experimental
     */
    toDeleteMobileDevice(): this;
    /**
     * (experimental) Grants permission to delete a mobile device access override.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_DeleteMobileDeviceAccessOverride.html
     *
     * @experimental
     */
    toDeleteMobileDeviceAccessOverride(): this;
    /**
     * (experimental) Grants permission to delete a mobile device access rule.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_DeleteMobileDeviceAccessRule.html
     *
     * @experimental
     */
    toDeleteMobileDeviceAccessRule(): this;
    /**
     * (experimental) Grants permission to delete an Amazon WorkMail organization and all underlying AWS resources managed by Amazon WorkMail as part of the organization.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_DeleteOrganization.html
     *
     * @experimental
     */
    toDeleteOrganization(): this;
    /**
     * (experimental) Grants permission to remove an outbound email flow rule so that it no longer applies to emails sent from an organization.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/remove-email-flow-rule.html
     *
     * @experimental
     */
    toDeleteOutboundMailFlowRule(): this;
    /**
     * (experimental) Grants permission to delete the specified resource.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_DeleteResource.html
     *
     * @experimental
     */
    toDeleteResource(): this;
    /**
     * (experimental) Grants permission to delete the retention policy based on the supplied organization and policy identifiers.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_DeleteRetentionPolicy.html
     *
     * @experimental
     */
    toDeleteRetentionPolicy(): this;
    /**
     * (experimental) Grants permission to remove an SMTP gateway from an organization.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/smtp-gateway.html
     *
     * @experimental
     */
    toDeleteSmtpGateway(): this;
    /**
     * (experimental) Grants permission to delete a user from WorkMail and all subsequent systems.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_DeleteUser.html
     *
     * @experimental
     */
    toDeleteUser(): this;
    /**
     * (experimental) Grants permission to mark a user, group, or resource as no longer used in WorkMail.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_DeregisterFromWorkMail.html
     *
     * @experimental
     */
    toDeregisterFromWorkMail(): this;
    /**
     * (experimental) Grants permission to deregister a mail domain from an organization.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_DeregisterMailDomain.html
     *
     * @experimental
     */
    toDeregisterMailDomain(): this;
    /**
     * (experimental) Grants permission to show a list of directories available for use in creating an organization.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/add_new_organization.html
     *
     * @experimental
     */
    toDescribeDirectories(): this;
    /**
     * (experimental) Grants permission to read the details for a group.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_DescribeGroup.html
     *
     * @experimental
     */
    toDescribeGroup(): this;
    /**
     * (experimental) Grants permission to read the settings in a DMARC policy for a specified organization.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_DescribeInboundDmarcSettings.html
     *
     * @experimental
     */
    toDescribeInboundDmarcSettings(): this;
    /**
     * (experimental) Grants permission to read the details of an inbound mail flow rule configured for an organization.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/email-flows.html#email-flows-rule-actions
     *
     * @experimental
     */
    toDescribeInboundMailFlowRule(): this;
    /**
     * (experimental) Grants permission to show a list of KMS Keys available for use in creating an organization.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/add_new_organization.html
     *
     * @experimental
     */
    toDescribeKmsKeys(): this;
    /**
     * (experimental) Grants permission to show the details of all mail domains associated with the organization.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/domains_overview.html
     *
     * @experimental
     */
    toDescribeMailDomains(): this;
    /**
     * (experimental) Grants permission to show the details of all groups associated with the organization.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/groups_overview.html
     *
     * @experimental
     */
    toDescribeMailGroups(): this;
    /**
     * (experimental) Grants permission to show the details of all users associated with the organization.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/users_overview.html
     *
     * @experimental
     */
    toDescribeMailUsers(): this;
    /**
     * (experimental) Grants permission to retrieve details of a mailbox export job.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_DescribeMailboxExportJob.html
     *
     * @experimental
     */
    toDescribeMailboxExportJob(): this;
    /**
     * (experimental) Grants permission to read details of an organization.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_DescribeOrganization.html
     *
     * @experimental
     */
    toDescribeOrganization(): this;
    /**
     * (experimental) Grants permission to show a summary of all organizations associated with the account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/organizations_overview.html
     *
     * @experimental
     */
    toDescribeOrganizations(): this;
    /**
     * (experimental) Grants permission to read the details of an outbound mail flow rule configured for an organization.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/email-flows.html#email-flows-rule-outbound
     *
     * @experimental
     */
    toDescribeOutboundMailFlowRule(): this;
    /**
     * (experimental) Grants permission to read the details for a resource.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_DescribeResource.html
     *
     * @experimental
     */
    toDescribeResource(): this;
    /**
     * (experimental) Grants permission to read the details of an SMTP gateway registered to an organization.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/smtp-gateway.html
     *
     * @experimental
     */
    toDescribeSmtpGateway(): this;
    /**
     * (experimental) Grants permission to read details for a user.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_DescribeUser.html
     *
     * @experimental
     */
    toDescribeUser(): this;
    /**
     * (experimental) Grants permission to disable a mail group when it is not being used, in order to allow it to be deleted.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/remove_group.html
     *
     * @experimental
     */
    toDisableMailGroups(): this;
    /**
     * (experimental) Grants permission to disable a user mailbox when it is no longer being used, in order to allow it to be deleted.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/manage-mailboxes.html#delete_user_mailbox
     *
     * @experimental
     */
    toDisableMailUsers(): this;
    /**
     * (experimental) Grants permission to remove a member from the resource's set of delegates.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_DisassociateDelegateFromResource.html
     *
     * @experimental
     */
    toDisassociateDelegateFromResource(): this;
    /**
     * (experimental) Grants permission to remove a member from a group.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_DisassociateMemberFromGroup.html
     *
     * @experimental
     */
    toDisassociateMemberFromGroup(): this;
    /**
     * (experimental) Grants permission to enable a mail domain in the organization.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/add_domain.html
     *
     * @experimental
     */
    toEnableMailDomain(): this;
    /**
     * (experimental) Grants permission to enable a mail group after it has been created to allow it to receive mail.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/enable_existing_group.html
     *
     * @experimental
     */
    toEnableMailGroups(): this;
    /**
     * (experimental) Grants permission to enable a user's mailbox after it has been created to allow it to receive mail.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/manage-users.html#enable_existing_user
     *
     * @experimental
     */
    toEnableMailUsers(): this;
    /**
     * (experimental) Grants permission to get the effects of access control rules as they apply to a specified IPv4 address, access protocol action, or user ID.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_GetAccessControlEffect.html
     *
     * @experimental
     */
    toGetAccessControlEffect(): this;
    /**
     * (experimental) Grants permission to retrieve the retention policy associated at an organizational level.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_GetDefaultRetentionPolicy.html
     *
     * @experimental
     */
    toGetDefaultRetentionPolicy(): this;
    /**
     * (experimental) Grants permission to read the configured journaling and fallback email addresses for email journaling.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/journaling_overview.html
     *
     * @experimental
     */
    toGetJournalingRules(): this;
    /**
     * (experimental) Grants permission to retrieve details of a given mail domain in an organization.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_GetMailDomain.html
     *
     * @experimental
     */
    toGetMailDomain(): this;
    /**
     * (experimental) Grants permission to get the details of the mail domain.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/domains_overview.html
     *
     * @experimental
     */
    toGetMailDomainDetails(): this;
    /**
     * (experimental) Grants permission to get the details of the mail group.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/groups_overview.html
     *
     * @experimental
     */
    toGetMailGroupDetails(): this;
    /**
     * (experimental) Grants permission to get the details of the user's mailbox and account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/users_overview.html
     *
     * @experimental
     */
    toGetMailUserDetails(): this;
    /**
     * (experimental) Grants permission to read the details of the user's mailbox.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_GetMailboxDetails.html
     *
     * @experimental
     */
    toGetMailboxDetails(): this;
    /**
     * (experimental) Grants permission to simulate the effect of the mobile device access rules for the given attributes of a sample access event.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_GetMobileDeviceAccessEffect.html
     *
     * @experimental
     */
    toGetMobileDeviceAccessEffect(): this;
    /**
     * (experimental) Grants permission to retrieve a mobile device access override.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_GetMobileDeviceAccessOverride.html
     *
     * @experimental
     */
    toGetMobileDeviceAccessOverride(): this;
    /**
     * (experimental) Grants permission to get the details of the mobile device.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/manage-devices.html
     *
     * @experimental
     */
    toGetMobileDeviceDetails(): this;
    /**
     * (experimental) Grants permission to get a list of the mobile devices associated with the user.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/manage-devices.html
     *
     * @experimental
     */
    toGetMobileDevicesForUser(): this;
    /**
     * (experimental) Grants permission to get the details of the mobile device policy associated with the organization.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/edit_organization_mobile_policy.html
     *
     * @experimental
     */
    toGetMobilePolicyDetails(): this;
    /**
     * (experimental) Grants permission to list the access control rules.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_ListAccessControlRules.html
     *
     * @experimental
     */
    toListAccessControlRules(): this;
    /**
     * (experimental) Grants permission to list the aliases associated with a given entity.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_ListAliases.html
     *
     * @experimental
     */
    toListAliases(): this;
    /**
     * (experimental) Grants permission to read an overview of the members of a group.
     *
     * Users and groups can be members of a group
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_ListGroupMembers.html
     *
     * @experimental
     */
    toListGroupMembers(): this;
    /**
     * (experimental) Grants permission to list summaries of the organization's groups.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_ListGroups.html
     *
     * @experimental
     */
    toListGroups(): this;
    /**
     * (experimental) Grants permission to list inbound mail flow rules configured for an organization.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/email-flows.html#email-flows-rule-actions
     *
     * @experimental
     */
    toListInboundMailFlowRules(): this;
    /**
     * (experimental) Grants permission to list the mail domains for a given organization.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_ListMailDomains.html
     *
     * @experimental
     */
    toListMailDomains(): this;
    /**
     * (experimental) Grants permission to list mailbox export jobs.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_ListMailboxExportJobs.html
     *
     * @experimental
     */
    toListMailboxExportJobs(): this;
    /**
     * (experimental) Grants permission to list the mailbox permissions associated with a user, group, or resource mailbox.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_ListMailboxPermissions.html
     *
     * @experimental
     */
    toListMailboxPermissions(): this;
    /**
     * (experimental) Grants permission to get a list of all the members in a mail group.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/groups_overview.html
     *
     * @experimental
     */
    toListMembersInMailGroup(): this;
    /**
     * (experimental) Grants permission to list the mobile device access overrides.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_ListMobileDeviceAccessOverrides.html
     *
     * @experimental
     */
    toListMobileDeviceAccessOverrides(): this;
    /**
     * (experimental) Grants permission to list the mobile device access rules.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_ListMobileDeviceAccessRules.html
     *
     * @experimental
     */
    toListMobileDeviceAccessRules(): this;
    /**
     * (experimental) Grants permission to list the non-deleted organizations.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_ListOrganizations.html
     *
     * @experimental
     */
    toListOrganizations(): this;
    /**
     * (experimental) Grants permission to list outbound mail flow rules configured for an organization.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/email-flows.html#email-flows-rule-outbound
     *
     * @experimental
     */
    toListOutboundMailFlowRules(): this;
    /**
     * (experimental) Grants permission to list the delegates associated with a resource.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_ListResourceDelegates.html
     *
     * @experimental
     */
    toListResourceDelegates(): this;
    /**
     * (experimental) Grants permission to list the organization's resources.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_ListResources.html
     *
     * @experimental
     */
    toListResources(): this;
    /**
     * (experimental) Grants permission to list SMTP gateways registered to the organization.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/smtp-gateway.html
     *
     * @experimental
     */
    toListSmtpGateways(): this;
    /**
     * (experimental) Grants permission to list the tags applied to an Amazon WorkMail organization resource.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_ListTagsForResource.html
     *
     * @experimental
     */
    toListTagsForResource(): this;
    /**
     * (experimental) Grants permission to list the organization's users.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_ListUsers.html
     *
     * @experimental
     */
    toListUsers(): this;
    /**
     * (experimental) Grants permission to add a new access control rule.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_PutAccessControlRule.html
     *
     * @experimental
     */
    toPutAccessControlRule(): this;
    /**
     * (experimental) Grants permission to enable or disable a DMARC policy for a given organization.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_PutInboundDmarcSettings.html
     *
     * @experimental
     */
    toPutInboundDmarcSettings(): this;
    /**
     * (experimental) Grants permission to set permissions for a user, group, or resource, replacing any existing permissions.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_PutMailboxPermissions.html
     *
     * @experimental
     */
    toPutMailboxPermissions(): this;
    /**
     * (experimental) Grants permission to add or update a mobile device access override.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_PutMobileDeviceAccessOverride.html
     *
     * @experimental
     */
    toPutMobileDeviceAccessOverride(): this;
    /**
     * (experimental) Grants permission to add or update the retention policy.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_PutRetentionPolicy.html
     *
     * @experimental
     */
    toPutRetentionPolicy(): this;
    /**
     * (experimental) Grants permission to register a new mail domain in an organization.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_RegisterMailDomain.html
     *
     * @experimental
     */
    toRegisterMailDomain(): this;
    /**
     * (experimental) Grants permission to register an existing and disabled user, group, or resource for use by associating a mailbox and calendaring capabilities.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_RegisterToWorkMail.html
     *
     * @experimental
     */
    toRegisterToWorkMail(): this;
    /**
     * (experimental) Grants permission to remove members from a mail group.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/groups_overview.html
     *
     * @experimental
     */
    toRemoveMembersFromGroup(): this;
    /**
     * (experimental) Grants permission to allow the administrator to reset the password for a user.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_ResetPassword.html
     *
     * @experimental
     */
    toResetPassword(): this;
    /**
     * (experimental) Grants permission to reset the password for a user's account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/manage-users.html#reset_user_password
     *
     * @experimental
     */
    toResetUserPassword(): this;
    /**
     * (experimental) Grants permission to perform a prefix search to find a specific user in a mail group.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/groups_overview.html
     *
     * @experimental
     */
    toSearchMembers(): this;
    /**
     * (experimental) Grants permission to mark a user as being an administrator.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/users_overview.html
     *
     * @experimental
     */
    toSetAdmin(): this;
    /**
     * (experimental) Grants permission to set the default mail domain for the organization.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/default_domain.html
     *
     * @experimental
     */
    toSetDefaultMailDomain(): this;
    /**
     * (experimental) Grants permission to set journaling and fallback email addresses for email journaling.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/journaling_overview.html
     *
     * @experimental
     */
    toSetJournalingRules(): this;
    /**
     * (experimental) Grants permission to set the details of the mail group which has just been created.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/add_new_group.html
     *
     * @experimental
     */
    toSetMailGroupDetails(): this;
    /**
     * (experimental) Grants permission to set the details for the user account which has just been created.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/manage-users.html
     *
     * @experimental
     */
    toSetMailUserDetails(): this;
    /**
     * (experimental) Grants permission to set the details of a mobile policy associated with the organization.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/edit_organization_mobile_policy.html
     *
     * @experimental
     */
    toSetMobilePolicyDetails(): this;
    /**
     * (experimental) Grants permission to start a new mailbox export job.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_StartMailboxExportJob.html
     *
     * @experimental
     */
    toStartMailboxExportJob(): this;
    /**
     * (experimental) Grants permission to tag the specified Amazon WorkMail organization resource.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_TagResource.html
     *
     * @experimental
     */
    toTagResource(): this;
    /**
     * (experimental) Grants permission to test what inbound rules will apply to an email with a given sender and recipient.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/test-email-flow-rule.html
     *
     * @experimental
     */
    toTestInboundMailFlowRules(): this;
    /**
     * (experimental) Grants permission to test what outbound rules will apply to an email with a given sender and recipient.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/test-email-flow-rule.html
     *
     * @experimental
     */
    toTestOutboundMailFlowRules(): this;
    /**
     * (experimental) Grants permission to untag the specified Amazon WorkMail organization resource.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_UntagResource.html
     *
     * @experimental
     */
    toUntagResource(): this;
    /**
     * (experimental) Grants permission to update which domain is the default domain for an organization.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_UpdateDefaultMailDomain.html
     *
     * @experimental
     */
    toUpdateDefaultMailDomain(): this;
    /**
     * (experimental) Grants permission to update the details of an inbound email flow rule which will apply to all email sent to an organization.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/modify-email-flow-rule.html
     *
     * @experimental
     */
    toUpdateInboundMailFlowRule(): this;
    /**
     * (experimental) Grants permission to update the maximum size (in MB) of the user's mailbox.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_UpdateMailboxQuota.html
     *
     * @experimental
     */
    toUpdateMailboxQuota(): this;
    /**
     * (experimental) Grants permission to update a mobile device access rule.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_UpdateMobileDeviceAccessRule.html
     *
     * @experimental
     */
    toUpdateMobileDeviceAccessRule(): this;
    /**
     * (experimental) Grants permission to update the details of an outbound email flow rule which will apply to all email sent from an organization.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/modify-email-flow-rule.html
     *
     * @experimental
     */
    toUpdateOutboundMailFlowRule(): this;
    /**
     * (experimental) Grants permission to update the primary email for a user, group, or resource.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_UpdatePrimaryEmailAddress.html
     *
     * @experimental
     */
    toUpdatePrimaryEmailAddress(): this;
    /**
     * (experimental) Grants permission to update details for the resource.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_UpdateResource.html
     *
     * @experimental
     */
    toUpdateResource(): this;
    /**
     * (experimental) Grants permission to update the details of an existing SMTP gateway registered to an organization.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/smtp-gateway.html
     *
     * @experimental
     */
    toUpdateSmtpGateway(): this;
    /**
     * (experimental) Grants permission to remotely wipe the mobile device associated with a user's account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/manage-devices.html#remote_wipe_device
     *
     * @experimental
     */
    toWipeMobileDevice(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type organization to the statement.
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/organizations_overview.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onOrganization(resourceId: string, account?: string, region?: string, partition?: string): this;
}
