# coding: utf-8

"""
    Arthur Scope

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
from inspect import getfullargspec
import json
import pprint
import re  # noqa: F401
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Optional
from arthur_client.api_bindings.models.alert_check_job_spec import AlertCheckJobSpec
from arthur_client.api_bindings.models.connector_check_job_spec import ConnectorCheckJobSpec
from arthur_client.api_bindings.models.list_datasets_job_spec import ListDatasetsJobSpec
from arthur_client.api_bindings.models.metrics_calculation_job_spec import MetricsCalculationJobSpec
from arthur_client.api_bindings.models.schedule_jobs_job_spec import ScheduleJobsJobSpec
from arthur_client.api_bindings.models.schema_inspection_job_spec import SchemaInspectionJobSpec
from typing import Union, Any, List, Set, TYPE_CHECKING, Optional, Dict
from typing_extensions import Literal, Self
from pydantic import Field

POSTJOBSPEC_ANY_OF_SCHEMAS = ["AlertCheckJobSpec", "ConnectorCheckJobSpec", "ListDatasetsJobSpec", "MetricsCalculationJobSpec", "ScheduleJobsJobSpec", "SchemaInspectionJobSpec"]

class PostJobSpec(BaseModel):
    """
    Job specification for the job kind.
    """

    # data type: MetricsCalculationJobSpec
    anyof_schema_1_validator: Optional[MetricsCalculationJobSpec] = None
    # data type: SchemaInspectionJobSpec
    anyof_schema_2_validator: Optional[SchemaInspectionJobSpec] = None
    # data type: ConnectorCheckJobSpec
    anyof_schema_3_validator: Optional[ConnectorCheckJobSpec] = None
    # data type: ListDatasetsJobSpec
    anyof_schema_4_validator: Optional[ListDatasetsJobSpec] = None
    # data type: ScheduleJobsJobSpec
    anyof_schema_5_validator: Optional[ScheduleJobsJobSpec] = None
    # data type: AlertCheckJobSpec
    anyof_schema_6_validator: Optional[AlertCheckJobSpec] = None
    if TYPE_CHECKING:
        actual_instance: Optional[Union[AlertCheckJobSpec, ConnectorCheckJobSpec, ListDatasetsJobSpec, MetricsCalculationJobSpec, ScheduleJobsJobSpec, SchemaInspectionJobSpec]] = None
    else:
        actual_instance: Any = None
    any_of_schemas: Set[str] = { "AlertCheckJobSpec", "ConnectorCheckJobSpec", "ListDatasetsJobSpec", "MetricsCalculationJobSpec", "ScheduleJobsJobSpec", "SchemaInspectionJobSpec" }

    model_config = {
        "validate_assignment": True,
        "protected_namespaces": (),
    }

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_anyof(cls, v):
        instance = PostJobSpec.model_construct()
        error_messages = []
        # validate data type: MetricsCalculationJobSpec
        if not isinstance(v, MetricsCalculationJobSpec):
            error_messages.append(f"Error! Input type `{type(v)}` is not `MetricsCalculationJobSpec`")
        else:
            return v

        # validate data type: SchemaInspectionJobSpec
        if not isinstance(v, SchemaInspectionJobSpec):
            error_messages.append(f"Error! Input type `{type(v)}` is not `SchemaInspectionJobSpec`")
        else:
            return v

        # validate data type: ConnectorCheckJobSpec
        if not isinstance(v, ConnectorCheckJobSpec):
            error_messages.append(f"Error! Input type `{type(v)}` is not `ConnectorCheckJobSpec`")
        else:
            return v

        # validate data type: ListDatasetsJobSpec
        if not isinstance(v, ListDatasetsJobSpec):
            error_messages.append(f"Error! Input type `{type(v)}` is not `ListDatasetsJobSpec`")
        else:
            return v

        # validate data type: ScheduleJobsJobSpec
        if not isinstance(v, ScheduleJobsJobSpec):
            error_messages.append(f"Error! Input type `{type(v)}` is not `ScheduleJobsJobSpec`")
        else:
            return v

        # validate data type: AlertCheckJobSpec
        if not isinstance(v, AlertCheckJobSpec):
            error_messages.append(f"Error! Input type `{type(v)}` is not `AlertCheckJobSpec`")
        else:
            return v

        if error_messages:
            # no match
            raise ValueError("No match found when setting the actual_instance in PostJobSpec with anyOf schemas: AlertCheckJobSpec, ConnectorCheckJobSpec, ListDatasetsJobSpec, MetricsCalculationJobSpec, ScheduleJobsJobSpec, SchemaInspectionJobSpec. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Dict[str, Any]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        # anyof_schema_1_validator: Optional[MetricsCalculationJobSpec] = None
        try:
            instance.actual_instance = MetricsCalculationJobSpec.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_2_validator: Optional[SchemaInspectionJobSpec] = None
        try:
            instance.actual_instance = SchemaInspectionJobSpec.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_3_validator: Optional[ConnectorCheckJobSpec] = None
        try:
            instance.actual_instance = ConnectorCheckJobSpec.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_4_validator: Optional[ListDatasetsJobSpec] = None
        try:
            instance.actual_instance = ListDatasetsJobSpec.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_5_validator: Optional[ScheduleJobsJobSpec] = None
        try:
            instance.actual_instance = ScheduleJobsJobSpec.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_6_validator: Optional[AlertCheckJobSpec] = None
        try:
            instance.actual_instance = AlertCheckJobSpec.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))

        if error_messages:
            # no match
            raise ValueError("No match found when deserializing the JSON string into PostJobSpec with anyOf schemas: AlertCheckJobSpec, ConnectorCheckJobSpec, ListDatasetsJobSpec, MetricsCalculationJobSpec, ScheduleJobsJobSpec, SchemaInspectionJobSpec. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], AlertCheckJobSpec, ConnectorCheckJobSpec, ListDatasetsJobSpec, MetricsCalculationJobSpec, ScheduleJobsJobSpec, SchemaInspectionJobSpec]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


