# coding: utf-8

"""
    Arthur Scope

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from arthur_client.api_bindings.models.config import Config
from arthur_client.api_bindings.models.rule_scope import RuleScope
from arthur_client.api_bindings.models.rule_type import RuleType
from typing import Optional, Set
from typing_extensions import Self

class RuleResponse(BaseModel):
    """
    RuleResponse
    """ # noqa: E501
    id: StrictStr = Field(description="ID of the Rule")
    name: StrictStr = Field(description="Name of the Rule")
    type: RuleType = Field(description="Type of Rule")
    apply_to_prompt: StrictBool = Field(description="Rule applies to prompt")
    apply_to_response: StrictBool = Field(description="Rule applies to response")
    enabled: Optional[StrictBool] = None
    scope: RuleScope = Field(description="Scope of the rule. The rule can be set at default level or task level.")
    created_at: StrictInt = Field(description="Time the rule was created in unix milliseconds")
    updated_at: StrictInt = Field(description="Time the rule was updated in unix milliseconds")
    config: Optional[Config] = None
    __properties: ClassVar[List[str]] = ["id", "name", "type", "apply_to_prompt", "apply_to_response", "enabled", "scope", "created_at", "updated_at", "config"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RuleResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of config
        if self.config:
            _dict['config'] = self.config.to_dict()
        # set to None if enabled (nullable) is None
        # and model_fields_set contains the field
        if self.enabled is None and "enabled" in self.model_fields_set:
            _dict['enabled'] = None

        # set to None if config (nullable) is None
        # and model_fields_set contains the field
        if self.config is None and "config" in self.model_fields_set:
            _dict['config'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RuleResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "type": obj.get("type"),
            "apply_to_prompt": obj.get("apply_to_prompt"),
            "apply_to_response": obj.get("apply_to_response"),
            "enabled": obj.get("enabled"),
            "scope": obj.get("scope"),
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at"),
            "config": Config.from_dict(obj["config"]) if obj.get("config") is not None else None
        })
        return _obj


