import base64
import logging

from PyQt5.QtGui import QPixmap, QIcon

images = {
    'выход': 'iVBORw0KGgoAAAANSUhEUgAAADMAAAAyCAYAAADx/eOPAAAACXBIWXMAAA7DAAAOwwHHb6hkAAAAGXRFWHRTb2Z0d2FyZQB3d3cuaW5rc2NhcGUub3Jnm+48GgAAAgZJREFUaIHt2TuLU0EYxvFfNAoRFC8IioWYxluhiLCNhYUIFpYWfgO12Q9goYUgiIX2IqJgYSMoCn4BbVa0Fa3sJGCnspuNsTjnkCibzTFzzjiG88CQQIb3mT/vXN/AMKH2WoDaY98HIYEq0MbQAAXMD2wJDRag43gXGmRDBQNJRg1MqmpgUlUDk6oamFQ1VzBkF7zv/3gMm3EAe0MDxYI5ioN1m8SCeZ57LeEKdtZhEgtmAT9zvwH6eIrz2FSVScw1cx8rRo+xfv75FXdwItQgJsxho+z82QrIj7iO/bMYxN7N3pgMNMx/W5VNxVe4iE7Z4LFhrmJZuZrAqgzuGx7hDFrrBY8Nc9psxY5iGn7GNXTXCh4bZp/wKk6xcbzHInaRpWyomoLGAh6X6NeSnfZVaHw6PmhP6fw36piQ+hpVJKOFdpWZaWNriX678SHQqy87aD/hnuz86hF/zZwUtgH0cAtH1goeG2bRaAFPa8WZs4IXuGDK1Sc2zDPZAMtk4S0uY0fZ4DFh9pgMUmSrh7s4NotBTJgbfp9ig7wt4wnOCSygx4LpGk2fAmgJl7C9KpNYMA9zry+4iUN1mMSCOYWzKvgfZj2lUNCoRHNVakoFpouXuB0SpMqLZoi2ybbloF0tlcxUogYmVTUwqaqBSVUNTKqaK5jiOtORPWf/a43fzWp9Z8TQL9Ap+pdRTFC/AAAAAElFTkSuQmCC',
    'добавить': 'iVBORw0KGgoAAAANSUhEUgAAADYAAAAyCAYAAAAX1CjLAAAACXBIWXMAAA7DAAAOwwHHb6hkAAAAGXRFWHRTb2Z0d2FyZQB3d3cuaW5rc2NhcGUub3Jnm+48GgAAAUFJREFUaIHtmkFqAjEUQN9YFamewq68gvuC9ABdehKv0POUpt12I+jWZa/gQoXWacdFGJjqYmL5nckP/8HAEJKfPPiEn8wAFBE9DiG6lfdvqaB/5EYyWCm2B0aSga9kCrxLBuxIBosJE9OGiWkjWbFufZd2cLAB+tW2LUwe4StkfLRiwB3QqzaMIAsdnGwqJisWSyqugDFwkAoYi9gn8CEZMNlUNDFtmJg2Gt0VX+A5g9vA7hdr68Gr83cjtWT4jo1cDTjYAcP/ngcSTkUT00ajm0cGsyL8/vCNs/V14P4HjoFzNbd5XIPzB8pf57EcBg++rqwl2VQ0MW2YmDZMTBsmpo1YbqkmwBOwBhYABcw5K7+WgeVUSYE/J7XJFOGP68mmoolpw8S0YWLaMDFtJCtW1opDIG9zIdJUi2DR/wXb5gSZ1UsP6hsZGgAAAABJRU5ErkJggg==',
    'добавить в корень': 'iVBORw0KGgoAAAANSUhEUgAAADUAAAAyCAYAAAD845PIAAAACXBIWXMAAA7DAAAOwwHHb6hkAAAAGXRFWHRTb2Z0d2FyZQB3d3cuaW5rc2NhcGUub3Jnm+48GgAAAqBJREFUaIHt2s+LTWEcx/HXnTGD8SvKjwULREk2WIj8LFZIWBHFQllgoazHThaKP8BGWbEaO0UpWZMFCQ0lQqQGzZ251+Lc2z1x3Tk/njNz53bfder0nHO+3+fT8z3f83yf50C1jY6XAjAjdj4ewmAOekMZqov6hYFQRjOwAu9CGesJZaid6EhRMya+ZXIZpGcrx+JtJSp7uZ3URtuJ2kl/mVvxtioVKUR1ZPh1RU0XuqKmCx0pql1S+geswmgIY+0iahxva+ez8hrrhl9WBunZxo4k95bpb9Z+n11J/ZVExVmhpccQAzMZKcr+33Rk+HVFTRcmJVH0Rin7UZJ7S5SqbG9yKdHzNRvFJ4o0PGRWOepPnMq+FAszHRl+XVHTha6oApiHvtBGp0JUH/bjDr7gUmgHk1l6bMKJ2rFI9CkZlWLpKylFi1qO4ziNtShrhFsFlzXqqGAUIWq2KLxOYZ9oROofzvj78xs3CvAfTFQP9uAkjoqq14r/zwJGcVOTcuQzlQW8jreVMmwzVfEz7UM11mEQ7zXekaQbbHsy+kxEWlFLcB5PpRdSP8YwJ0z3m5NE1EwcwN1ah8ZEIZF1G3Q4tIg4E83S5+OqaGtlbuyZvIzgSU4bP/z7rp3DJ1qP1Bp81giZqd7onuhYycTZ7xWWYTfO4qAo05XkG7FhHGlxfbZs638f6ydpEsViXMBz2ZNEFd8ydDgVWVP6elzB15qNsnTCVufteCvyfKeIFh8PYUgjM1a0FjQumjoVRl5RcRbiDJ5pHZ5jeBzIZ1NCioqzEdfx3f/Dc0MBflGcqDr9OIx7ohEqi8KzggdFOS1aVJyluIgXGqN1oAhHkykqzmZcw5YijE+VqMKoz/2Y+l/j3oiq49zEp0nB/rfLSLAq/A9fFSY37wWO/AAAAABJRU5ErkJggg==',
    'сохранить': 'iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAAyWlDQ1BDdXN0b20AABiVY2Bg3M4ABEwODAy5eSVFQe5OChGRUQoMSCAxubiAATdgZGD4dg1EMjBc1g0sYeXHoxYb4CwCWgikPwCxSDqYzcgCYidB2BIgdnlJQQmQrQNiJxcUgdhAFzPwFIUEOQPZPkC2QDoSOwmJnZJanAxkxwDZ0Qi/5c9nYLD4wsDAPBEhljSNgWF7OwODxG2EmMpCBgb+VgaGbVcQYp8Dwf5lFDtTklpRAhLx03dkKEgsSkR4qyQWYi8sjKgKAI4uMZ+gIf0EAAAACXBIWXMAAA7EAAAOxAGVKw4bAAAAJXRFWHRkYXRlOmNyZWF0ZQAyMDE1LTExLTI2VDE1OjIzOjEwKzAwOjAw+wm6CwAAACV0RVh0ZGF0ZTptb2RpZnkAMjAxNS0xMS0yNlQxNToxNjo1NiswMDowMBIFlDIAAADOSURBVFiF7ZUxDsIwDEW/qc+AGDpk6NB7wIS4CCMTHAEOxU0yZqJHwFKYkKqSqklp6iV/i6O0T3KeQ6fzBZrZqP69AADgYYGc9Qt9++Hr5pYMAAC+bmhYI2d9qP7d669FZMvMT3IWUxBZWlCZthORPYAjOXtfHSAFIusljIHIbsEUxCoaVqbtmPkA4KoCAADvnXmF6kENx7LgjEgHGJsB/0Z9FBeAAhBlwVz9YszJpmEstHoLCkABUAcIahhSaM4siDnzA5Dr2R2LegsKwAcTkktbw7RtjQAAAABJRU5ErkJggg==',
    'экспорт': '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',
    'печать': 'iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAAyWlDQ1BDdXN0b20AABiVY2Bg3M4ABEwODAy5eSVFQe5OChGRUQoMSCAxubiAATdgZGD4dg1EMjBc1g0sYeXHoxYb4CwCWgikPwCxSDqYzcgCYidB2BIgdnlJQQmQrQNiJxcUgdhAFzPwFIUEOQPZPkC2QDoSOwmJnZJanAxkxwDZ0Qi/5c9nYLD4wsDAPBEhljSNgWF7OwODxG2EmMpCBgb+VgaGbVcQYp8Dwf5lFDtTklpRAhLx03dkKEgsSkR4qyQWYi8sjKgKAI4uMZ+gIf0EAAAACXBIWXMAAA7EAAAOxAGVKw4bAAAAJXRFWHRkYXRlOmNyZWF0ZQAyMDE1LTExLTI2VDE1OjIzOjEwKzAwOjAw+wm6CwAAACV0RVh0ZGF0ZTptb2RpZnkAMjAxNS0xMS0yNlQxNToxNjo1NiswMDowMBIFlDIAAACmSURBVFiF7Za7DYAwDERtxBiUjMMilOybMnuEFuWDbeLIgHxtfu98ThTc9gMsNZme7gAAMN8NYgxJ45C0rPgIgFrMEWXi3RFcJY2DWzk2QG8ULXkE5hEUALlTjbfgukdupFqBUW5rZr7ThFLlbltVHQbAjdE8AnMAMoLea0hFYV4BB6j2gNZXjLNXAdBqGowhce+2ZK55BOYAoqdYszfEAL/9EzrACTI+PYQC8Ky6AAAAAElFTkSuQmCC',
    'обновить': '',
    'открыть в ФМ': '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',
    'настройка': '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',
    'справка': '',
    'о программе': '',
    'пустота': 'iVBORw0KGgoAAAANSUhEUgAAADkAAAA6CAYAAAAKjPErAAAACXBIWXMAAA7DAAAOwwHHb6hkAAAAGXRFWHRTb2Z0d2FyZQB3d3cuaW5rc2NhcGUub3Jnm+48GgAAACRJREFUaIHtwTEBAAAAwqD1T20MH6AAAAAAAAAAAAAAAACAnwEz4gABjaaC7gAAAABJRU5ErkJggg==',
    'запись': "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",
    'папка': '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',
    'иконка': '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',
}


def getImage(name=None):
    """ возврат картинки-глифа по ее имени"""
    if name not in images: name = None
    if name != None:
        #     получим картинку по ее текстовому коду
        base64_data = images[name]
        pm = QPixmap()
        pm.loadFromData(base64.b64decode(base64_data))
        i = QIcon()
        i.addPixmap(pm)
        return i
    else:
        return QIcon()

def log(funct):
    def foo(*args, **kwargs):
        logging.debug(f"Запуск: {funct.__doc__}")
        result = funct(*args, **kwargs)
        return result
    return foo


