#!/usr/bin/env python
# -*- coding: utf-8 -*-

"""
Сообщения
"""

# ######################################################################################################################
# Импорт необходимых инструментов
# ######################################################################################################################
# Подавление Warning
import warnings
for warn in [UserWarning, FutureWarning]: warnings.filterwarnings('ignore', category = warn)

from dataclasses import dataclass  # Класс данных

from typing import List  # Типы данных

# Персональные
from neweraai.modules.core.language import Language  # Определение языка

# ######################################################################################################################
# Сообщения
# ######################################################################################################################
@dataclass
class Messages(Language):
    """Сообщения"""

    # ------------------------------------------------------------------------------------------------------------------
    # Конструктор
    # ------------------------------------------------------------------------------------------------------------------

    def __post_init__(self):
        super().__post_init__()  # Выполнение конструктора из суперкласса

        self._metadata: List[str] = [
            self._('NewEraAI - новая эра искусственного интеллекта'),
            self._('Автор'), self._('Email'),
            self._('Сопровождающие'), self._('Версия'), self._('Лицензия')
        ]

        self._format_time: str = '%Y-%m-%d %H:%M:%S'  # Формат времени

        self._method_not_supported: str = self._('"{}.{}" не поддерживается в данной среде использования пакета ...')
        self._invalid_arguments: str = self._('Неверные типы или значения аргументов в "{}" ...')

        self._oh = self._('Ой! Что-то пошло не так ... ')
        self._trouble = self._('Прям беда! ')

        self._som_ww: str = self._oh + self._('смотрите настройки ядра и цепочку выполнения действий ...')
        self._unknown_err: str = self._trouble + self._('Не обработанную ошибку необходимо проанализировать и выявить '
                                                        'причину ...')

        self._logs_save_true: str = self._('Лог файл успешно сохранен ...')

        self._from_precent: str = self._('из')

        self._lock_user: str = self._('Выполнение заблокировано пользователем ...')