#!/usr/bin/env python
# -*- coding: utf-8 -*-

"""
Статистика
"""

# ######################################################################################################################
# Импорт необходимых инструментов
# ######################################################################################################################
# Подавление Warning
import warnings
for warn in [UserWarning, FutureWarning]: warnings.filterwarnings('ignore', category = warn)

from dataclasses import dataclass  # Класс данных

import pandas as pd  # Обработка и анализ данных

# Персональные
from neweraai.modules.lab.download import Download  # Загрузка

# ######################################################################################################################
# Настройки необходимых инструментов
# ######################################################################################################################
pd.set_option('display.max_columns', None)  # Максимальное количество отображаемых столбцов
pd.set_option('display.max_rows', None)     # Максимальное количество отображаемых строк

# ######################################################################################################################
# Сообщения
# ######################################################################################################################
@dataclass
class Messages(Download):
    """Сообщения"""

    # ------------------------------------------------------------------------------------------------------------------
    # Конструктор
    # ------------------------------------------------------------------------------------------------------------------

    def __post_init__(self):
        super().__post_init__()  # Выполнение конструктора из суперкласса

# ######################################################################################################################
# Статистика
# ######################################################################################################################
@dataclass
class Statistics(Messages):
    """Статистика"""

    # ------------------------------------------------------------------------------------------------------------------
    # Конструктор
    # ------------------------------------------------------------------------------------------------------------------

    def __post_init__(self):
        super().__post_init__()  # Выполнение конструктора из суперкласса