import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * Statement provider for service [tiros](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awstiros.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Tiros extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [tiros](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awstiros.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to create a VPC reachability query
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/vpc/latest/reachability/security_iam_required-API-permissions.html
     */
    toCreateQuery(): this;
    /**
     * Grants permission to get VPC reachability query answers
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/vpc/latest/reachability/security_iam_required-API-permissions.html
     */
    toGetQueryAnswer(): this;
    /**
     * Grants permission to get VPC reachability query explanations
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/vpc/latest/reachability/security_iam_required-API-permissions.html
     */
    toGetQueryExplanation(): this;
    protected accessLevelList: AccessLevelList;
}
