import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * Statement provider for service [waf](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awswaf.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Waf extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [waf](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awswaf.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to create a ByteMatchSet
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/waf/latest/APIReference/API_waf_CreateByteMatchSet.html
     */
    toCreateByteMatchSet(): this;
    /**
     * Grants permission to create a GeoMatchSet
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/waf/latest/APIReference/API_waf_CreateGeoMatchSet.html
     */
    toCreateGeoMatchSet(): this;
    /**
     * Grants permission to create an IPSet
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/waf/latest/APIReference/API_waf_CreateIPSet.html
     */
    toCreateIPSet(): this;
    /**
     * Grants permission to create a RateBasedRule for limiting the volume of requests from a single IP address
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/waf/latest/APIReference/API_waf_CreateRateBasedRule.html
     */
    toCreateRateBasedRule(): this;
    /**
     * Grants permission to create a RegexMatchSet
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/waf/latest/APIReference/API_waf_CreateRegexMatchSet.html
     */
    toCreateRegexMatchSet(): this;
    /**
     * Grants permission to create a RegexPatternSet
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/waf/latest/APIReference/API_waf_CreateRegexPatternSet.html
     */
    toCreateRegexPatternSet(): this;
    /**
     * Grants permission to create a Rule for filtering web requests
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/waf/latest/APIReference/API_waf_CreateRule.html
     */
    toCreateRule(): this;
    /**
     * Grants permission to create a RuleGroup, which is a collection of predefined rules that you can use in a WebACL
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/waf/latest/APIReference/API_waf_CreateRuleGroup.html
     */
    toCreateRuleGroup(): this;
    /**
     * Grants permission to create a SizeConstraintSet
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/waf/latest/APIReference/API_waf_CreateSizeConstraintSet.html
     */
    toCreateSizeConstraintSet(): this;
    /**
     * Grants permission to create an SqlInjectionMatchSet
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/waf/latest/APIReference/API_waf_CreateSqlInjectionMatchSet.html
     */
    toCreateSqlInjectionMatchSet(): this;
    /**
     * Grants permission to create a WebACL, which contains rules for filtering web requests
     *
     * Access Level: Permissions management
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/waf/latest/APIReference/API_waf_CreateWebACL.html
     */
    toCreateWebACL(): this;
    /**
     * Grants permission to create a CloudFormation web ACL template in an S3 bucket for the purposes of migrating the web ACL from AWS WAF Classic to AWS WAF v2
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - s3:PutObject
     *
     * https://docs.aws.amazon.com/waf/latest/APIReference/API_waf_CreateWebACLMigrationStack.html
     */
    toCreateWebACLMigrationStack(): this;
    /**
     * Grants permission to create an XssMatchSet, which you use to detect requests that contain cross-site scripting attacks
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/waf/latest/APIReference/API_waf_CreateXssMatchSet.html
     */
    toCreateXssMatchSet(): this;
    /**
     * Grants permission to delete a ByteMatchSet
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/waf/latest/APIReference/API_waf_DeleteByteMatchSet.html
     */
    toDeleteByteMatchSet(): this;
    /**
     * Grants permission to delete a GeoMatchSet
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/waf/latest/APIReference/API_waf_DeleteGeoMatchSet.html
     */
    toDeleteGeoMatchSet(): this;
    /**
     * Grants permission to delete an IPSet
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/waf/latest/APIReference/API_waf_DeleteIPSet.html
     */
    toDeleteIPSet(): this;
    /**
     * Grants permission to delete the LoggingConfiguration from a web ACL
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/waf/latest/APIReference/API_waf_DeleteLoggingConfiguration.html
     */
    toDeleteLoggingConfiguration(): this;
    /**
     * Grants permission to delete an IAM policy from a rule group
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/waf/latest/APIReference/API_waf_DeletePermissionPolicy.html
     */
    toDeletePermissionPolicy(): this;
    /**
     * Grants permission to delete a RateBasedRule
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/waf/latest/APIReference/API_waf_DeleteRateBasedRule.html
     */
    toDeleteRateBasedRule(): this;
    /**
     * Grants permission to delete a RegexMatchSet
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/waf/latest/APIReference/API_waf_DeleteRegexMatchSet.html
     */
    toDeleteRegexMatchSet(): this;
    /**
     * Grants permission to delete a RegexPatternSet
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/waf/latest/APIReference/API_waf_DeleteRegexPatternSet.html
     */
    toDeleteRegexPatternSet(): this;
    /**
     * Grants permission to delete a Rule
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/waf/latest/APIReference/API_waf_DeleteRule.html
     */
    toDeleteRule(): this;
    /**
     * Grants permission to delete a RuleGroup
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/waf/latest/APIReference/API_waf_DeleteRuleGroup.html
     */
    toDeleteRuleGroup(): this;
    /**
     * Grants permission to delete a SizeConstraintSet
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/waf/latest/APIReference/API_waf_DeleteSizeConstraintSet.html
     */
    toDeleteSizeConstraintSet(): this;
    /**
     * Grants permission to delete an SqlInjectionMatchSet
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/waf/latest/APIReference/API_waf_DeleteSqlInjectionMatchSet.html
     */
    toDeleteSqlInjectionMatchSet(): this;
    /**
     * Grants permission to delete a WebACL
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/waf/latest/APIReference/API_waf_DeleteWebACL.html
     */
    toDeleteWebACL(): this;
    /**
     * Grants permission to delete an XssMatchSet
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/waf/latest/APIReference/API_waf_DeleteXssMatchSet.html
     */
    toDeleteXssMatchSet(): this;
    /**
     * Grants permission to retrieve a ByteMatchSet
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/waf/latest/APIReference/API_waf_GetByteMatchSet.html
     */
    toGetByteMatchSet(): this;
    /**
     * Grants permission to retrieve a change token to use in create, update, and delete requests
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/waf/latest/APIReference/API_waf_GetChangeToken.html
     */
    toGetChangeToken(): this;
    /**
     * Grants permission to retrieve the status of a change token
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/waf/latest/APIReference/API_waf_GetChangeTokenStatus.html
     */
    toGetChangeTokenStatus(): this;
    /**
     * Grants permission to retrieve a GeoMatchSet
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/waf/latest/APIReference/API_waf_GetGeoMatchSet.html
     */
    toGetGeoMatchSet(): this;
    /**
     * Grants permission to retrieve an IPSet
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/waf/latest/APIReference/API_waf_GetIPSet.html
     */
    toGetIPSet(): this;
    /**
     * Grants permission to retrieve a LoggingConfiguration for a web ACL
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/waf/latest/APIReference/API_waf_GetLoggingConfiguration.html
     */
    toGetLoggingConfiguration(): this;
    /**
     * Grants permission to retrieve an IAM policy for a rule group
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/waf/latest/APIReference/API_waf_GetPermissionPolicy.html
     */
    toGetPermissionPolicy(): this;
    /**
     * Grants permission to retrieve a RateBasedRule
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/waf/latest/APIReference/API_waf_GetRateBasedRule.html
     */
    toGetRateBasedRule(): this;
    /**
     * Grants permission to retrieve the array of IP addresses that are currently being blocked by a RateBasedRule
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/waf/latest/APIReference/API_waf_GetRateBasedRuleManagedKeys.html
     */
    toGetRateBasedRuleManagedKeys(): this;
    /**
     * Grants permission to retrieve a RegexMatchSet
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/waf/latest/APIReference/API_waf_GetRegexMatchSet.html
     */
    toGetRegexMatchSet(): this;
    /**
     * Grants permission to retrieve a RegexPatternSet
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/waf/latest/APIReference/API_waf_GetRegexPatternSet.html
     */
    toGetRegexPatternSet(): this;
    /**
     * Grants permission to retrieve a Rule
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/waf/latest/APIReference/API_waf_GetRule.html
     */
    toGetRule(): this;
    /**
     * Grants permission to retrieve a RuleGroup
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/waf/latest/APIReference/API_waf_GetRuleGroup.html
     */
    toGetRuleGroup(): this;
    /**
     * Grants permission to retrieve detailed information about a sample set of web requests
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/waf/latest/APIReference/API_waf_GetSampledRequests.html
     */
    toGetSampledRequests(): this;
    /**
     * Grants permission to retrieve a SizeConstraintSet
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/waf/latest/APIReference/API_waf_GetSizeConstraintSet.html
     */
    toGetSizeConstraintSet(): this;
    /**
     * Grants permission to retrieve an SqlInjectionMatchSet
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/waf/latest/APIReference/API_waf_GetSqlInjectionMatchSet.html
     */
    toGetSqlInjectionMatchSet(): this;
    /**
     * Grants permission to retrieve a WebACL
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/waf/latest/APIReference/API_waf_GetWebACL.html
     */
    toGetWebACL(): this;
    /**
     * Grants permission to retrieve an XssMatchSet
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/waf/latest/APIReference/API_waf_GetXssMatchSet.html
     */
    toGetXssMatchSet(): this;
    /**
     * Grants permission to retrieve an array of ActivatedRule objects
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/waf/latest/APIReference/API_waf_ListActivatedRulesInRuleGroup.html
     */
    toListActivatedRulesInRuleGroup(): this;
    /**
     * Grants permission to retrieve an array of ByteMatchSetSummary objects
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/waf/latest/APIReference/API_waf_ListByteMatchSets.html
     */
    toListByteMatchSets(): this;
    /**
     * Grants permission to retrieve an array of GeoMatchSetSummary objects
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/waf/latest/APIReference/API_waf_ListGeoMatchSets.html
     */
    toListGeoMatchSets(): this;
    /**
     * Grants permission to retrieve an array of IPSetSummary objects
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/waf/latest/APIReference/API_waf_ListIPSets.html
     */
    toListIPSets(): this;
    /**
     * Grants permission to retrieve an array of LoggingConfiguration objects
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/waf/latest/APIReference/API_waf_ListLoggingConfigurations.html
     */
    toListLoggingConfigurations(): this;
    /**
     * Grants permission to retrieve an array of RuleSummary objects
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/waf/latest/APIReference/API_waf_ListRateBasedRules.html
     */
    toListRateBasedRules(): this;
    /**
     * Grants permission to retrieve an array of RegexMatchSetSummary objects
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/waf/latest/APIReference/API_waf_ListRegexMatchSets.html
     */
    toListRegexMatchSets(): this;
    /**
     * Grants permission to retrieve an array of RegexPatternSetSummary objects
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/waf/latest/APIReference/API_waf_ListRegexPatternSets.html
     */
    toListRegexPatternSets(): this;
    /**
     * Grants permission to retrieve an array of RuleGroup objects
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/waf/latest/APIReference/API_waf_ListRuleGroups.html
     */
    toListRuleGroups(): this;
    /**
     * Grants permission to retrieve an array of RuleSummary objects
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/waf/latest/APIReference/API_waf_ListRules.html
     */
    toListRules(): this;
    /**
     * Grants permission to retrieve an array of SizeConstraintSetSummary objects
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/waf/latest/APIReference/API_waf_ListSizeConstraintSets.html
     */
    toListSizeConstraintSets(): this;
    /**
     * Grants permission to retrieve an array of SqlInjectionMatchSet objects
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/waf/latest/APIReference/API_waf_ListSqlInjectionMatchSets.html
     */
    toListSqlInjectionMatchSets(): this;
    /**
     * Grants permission to retrieve an array of RuleGroup objects that you are subscribed to
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/waf/latest/APIReference/API_waf_ListSubscribedRuleGroups.html
     */
    toListSubscribedRuleGroups(): this;
    /**
     * Grants permission to retrieve the tags for a resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/waf/latest/APIReference/API_waf_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to retrieve an array of WebACLSummary objects
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/waf/latest/APIReference/API_waf_ListWebACLs.html
     */
    toListWebACLs(): this;
    /**
     * Grants permission to retrieve an array of XssMatchSet objects
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/waf/latest/APIReference/API_waf_ListXssMatchSets.html
     */
    toListXssMatchSets(): this;
    /**
     * Grants permission to associate a LoggingConfiguration with a specified web ACL
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:CreateServiceLinkedRole
     *
     * https://docs.aws.amazon.com/waf/latest/APIReference/API_waf_PutLoggingConfiguration.html
     */
    toPutLoggingConfiguration(): this;
    /**
     * Grants permission to attach an IAM policy to a rule group, to share the rule group between accounts
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/waf/latest/APIReference/API_waf_PutPermissionPolicy.html
     */
    toPutPermissionPolicy(): this;
    /**
     * Grants permission to add a Tag to a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/waf/latest/APIReference/API_waf_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to remove a Tag from a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/waf/latest/APIReference/API_waf_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to insert or delete ByteMatchTuple objects in a ByteMatchSet
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/waf/latest/APIReference/API_waf_UpdateByteMatchSet.html
     */
    toUpdateByteMatchSet(): this;
    /**
     * Grants permission to insert or delete GeoMatchConstraint objects in a GeoMatchSet
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/waf/latest/APIReference/API_waf_UpdateGeoMatchSet.html
     */
    toUpdateGeoMatchSet(): this;
    /**
     * Grants permission to insert or delete IPSetDescriptor objects in an IPSet
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/waf/latest/APIReference/API_waf_UpdateIPSet.html
     */
    toUpdateIPSet(): this;
    /**
     * Grants permission to modify a rate based rule
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/waf/latest/APIReference/API_waf_UpdateRateBasedRule.html
     */
    toUpdateRateBasedRule(): this;
    /**
     * Grants permission to insert or delete RegexMatchTuple objects in a RegexMatchSet
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/waf/latest/APIReference/API_waf_UpdateRegexMatchSet.html
     */
    toUpdateRegexMatchSet(): this;
    /**
     * Grants permission to insert or delete RegexPatternStrings in a RegexPatternSet
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/waf/latest/APIReference/API_waf_UpdateRegexPatternSet.html
     */
    toUpdateRegexPatternSet(): this;
    /**
     * Grants permission to modify a Rule
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/waf/latest/APIReference/API_waf_UpdateRule.html
     */
    toUpdateRule(): this;
    /**
     * Grants permission to insert or delete ActivatedRule objects in a RuleGroup
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/waf/latest/APIReference/API_waf_UpdateRuleGroup.html
     */
    toUpdateRuleGroup(): this;
    /**
     * Grants permission to insert or delete SizeConstraint objects in a SizeConstraintSet
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/waf/latest/APIReference/API_waf_UpdateSizeConstraintSet.html
     */
    toUpdateSizeConstraintSet(): this;
    /**
     * Grants permission to insert or delete SqlInjectionMatchTuple objects in an SqlInjectionMatchSet
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/waf/latest/APIReference/API_waf_UpdateSqlInjectionMatchSet.html
     */
    toUpdateSqlInjectionMatchSet(): this;
    /**
     * Grants permission to insert or delete ActivatedRule objects in a WebACL
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/waf/latest/APIReference/API_waf_UpdateWebACL.html
     */
    toUpdateWebACL(): this;
    /**
     * Grants permission to insert or delete XssMatchTuple objects in an XssMatchSet
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/waf/latest/APIReference/API_waf_UpdateXssMatchSet.html
     */
    toUpdateXssMatchSet(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type bytematchset to the statement
     *
     * https://docs.aws.amazon.com/waf/latest/APIReference/API_waf_ByteMatchSet.html
     *
     * @param id - Identifier for the id.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onBytematchset(id: string, account?: string, partition?: string): this;
    /**
     * Adds a resource of type ipset to the statement
     *
     * https://docs.aws.amazon.com/waf/latest/APIReference/API_waf_IPSet.html
     *
     * @param id - Identifier for the id.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onIpset(id: string, account?: string, partition?: string): this;
    /**
     * Adds a resource of type ratebasedrule to the statement
     *
     * https://docs.aws.amazon.com/waf/latest/APIReference/API_waf_RateBasedRule.html
     *
     * @param id - Identifier for the id.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onRatebasedrule(id: string, account?: string, partition?: string): this;
    /**
     * Adds a resource of type rule to the statement
     *
     * https://docs.aws.amazon.com/waf/latest/APIReference/API_waf_Rule.html
     *
     * @param id - Identifier for the id.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onRule(id: string, account?: string, partition?: string): this;
    /**
     * Adds a resource of type sizeconstraintset to the statement
     *
     * https://docs.aws.amazon.com/waf/latest/APIReference/API_waf_SizeConstraintSet.html
     *
     * @param id - Identifier for the id.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onSizeconstraintset(id: string, account?: string, partition?: string): this;
    /**
     * Adds a resource of type sqlinjectionmatchset to the statement
     *
     * https://docs.aws.amazon.com/waf/latest/APIReference/API_waf_SqlInjectionMatchSet.html
     *
     * @param id - Identifier for the id.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onSqlinjectionmatchset(id: string, account?: string, partition?: string): this;
    /**
     * Adds a resource of type webacl to the statement
     *
     * https://docs.aws.amazon.com/waf/latest/APIReference/API_waf_WebACL.html
     *
     * @param id - Identifier for the id.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onWebacl(id: string, account?: string, partition?: string): this;
    /**
     * Adds a resource of type xssmatchset to the statement
     *
     * https://docs.aws.amazon.com/waf/latest/APIReference/API_waf_XssMatchSet.html
     *
     * @param id - Identifier for the id.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onXssmatchset(id: string, account?: string, partition?: string): this;
    /**
     * Adds a resource of type regexmatchset to the statement
     *
     * https://docs.aws.amazon.com/waf/latest/APIReference/API_waf_RegexMatchSet.html
     *
     * @param id - Identifier for the id.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onRegexmatchset(id: string, account?: string, partition?: string): this;
    /**
     * Adds a resource of type regexpatternset to the statement
     *
     * https://docs.aws.amazon.com/waf/latest/APIReference/API_waf_RegexPatternSet.html
     *
     * @param id - Identifier for the id.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onRegexpatternset(id: string, account?: string, partition?: string): this;
    /**
     * Adds a resource of type geomatchset to the statement
     *
     * https://docs.aws.amazon.com/waf/latest/APIReference/API_waf_GeoMatchSet.html
     *
     * @param id - Identifier for the id.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onGeomatchset(id: string, account?: string, partition?: string): this;
    /**
     * Adds a resource of type rulegroup to the statement
     *
     * https://docs.aws.amazon.com/waf/latest/APIReference/API_waf_RuleGroup.html
     *
     * @param id - Identifier for the id.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onRulegroup(id: string, account?: string, partition?: string): this;
}
