#! /usr/bin/env python
# -*- coding: utf-8 -*-

import sys, time, gc, threading
from .. import es, imatrix
from works import Works, WorksThread
from subject import Subject, SubjectThread

def getSubjectHistory():
	subjectHistory = {}
	for hit in es.searchStatisticsData('subject_history'):
		history = hit['_source']
		subjectHistory[history['aid']] = history
	return subjectHistory

def getWorksHistory():
	worksHistory = {}
	for hit in es.searchStatisticsData('works_history'):
		history = hit['_source']
		worksHistory[history['vid']] = history
	return worksHistory

def getWorksList(aids=[], blackVids=[]):
	worksList = []
	
	for hit in es.scrollSearch('works_video_read', 'video', {"size":1000}):
		works = toWorks(hit['_source'], aids, blackVids)
		if works != None:
			worksList.append(works)
	return worksList

def updateHistoryActions():
	worksList = getWorksList()
	subjectAids = []
	subjectList = []

	now = int(time.time())

	worksThreads = []

	while len(worksList) != 0:
		if len(threading.enumerate()) > 20:
			time.sleep(5)
		else:
			works = worksList.pop()
			print(len(worksList), works.vid, works.aid)
			t = WorksThread(works, now)
			worksThreads.append(t)
			t.start()

	while len(threading.enumerate()) != 1:
		time.sleep(5)

	for t in worksThreads:
		works = t.works
		worksList.append(works)
		aid = works.aid

		if aid not in subjectAids:
			subjectAids.append(aid)
			subject = Subject(aid)
			subjectList.append(subject)
		else:
			subject = subjectList[subjectAids.index(aid)]
		subject.count += 1
		subject.play += works.play
		subject.replay += works.replay

	subjectThreads = []

	while len(subjectList) != 0:
		if len(threading.enumerate()) > 20:
			time.sleep(5)
		else:
			subject = subjectList.pop()
			print(len(subjectList), subject.aid)
			t = SubjectThread(subject, now)
			subjectThreads.append(t)
			t.start()

	while len(threading.enumerate()) != 1:
		time.sleep(5)

	for t in subjectThreads:
		subjectList.append(t.subject)


	from .. import hot
	hot.calSubjectScore(subjectList)
	subjectHistory = {}
	for subject in subjectList:
		subjectHistory[subject.aid] = subject.toSaveEsData()
	es.updateStatisticsData('subject_history', subjectHistory)

	hot.calWorksScore(worksList)
	worksHistory = {}
	for works in worksList:
		worksHistory[works.vid] = works.toSaveEsData()
	es.updateStatisticsData('works_history', worksHistory)

			

def toWorks(worksInfo, aids=[], blackVids=[]):
	if not worksInfo.has_key('vid') or not worksInfo.has_key('aid') or (worksInfo.has_key('state') and worksInfo['state'] == 1) or (worksInfo.has_key('authorstate') and worksInfo['authorstate'] == 1):
		return
	if not worksInfo.has_key('publishtime') or worksInfo['publishtime'] == None:
		return
	aid = worksInfo['aid']
	vid = worksInfo['vid']
	if (len(aids) != 0 and not aid in aids) or vid in blackVids:
		return
	publishTime = int(time.time() - es.esTimeToTime(worksInfo['publishtime'], True)) / 3600
	#最多取最近2个月的
	#print(publishTime)
	if publishTime > 1440:
		return
	return Works(vid, aid, worksInfo['title'], worksInfo['publishtime'], worksInfo['duration'] if worksInfo.has_key('duration') else 0)

def cycleDisposePersonas():
	while True:
		try:
			disposePersonas()
		except Exception as error:
			print('Error: ' + str(error))
		gc.collect()
		time.sleep(600)

def disposePersonas():
	worksDict = readWorks()
	while True:
		endTime = disposePersonasOnce(worksDict)
		print('endTime: ' + str(endTime) + '(' + es.timeToEsLocalTime(endTime) + ')')
		if endTime > time.time() - 3600:
			break
		time.sleep(15)
		gc.collect()

def disposePersonasOnce(worksDict):
	startTime = readEndTime()
	hits = es.searchPersonas(startTime)

	userActions = {}
	worksActions = {}

	aIndex = 0
	for index, hit in enumerate(hits):

		#if index % 100 == 0:
			#sys.stdout.write(str(index) + '\r')
			#sys.stdout.flush()

		source = hit['_source']
		uid = source['uid']
		createTime = es.esTimeToTime(source['create_time']) if source.has_key('create_time') else 0
		actions = source['body'].split('\n')

		for action in actions:
			items = action.split('\t')
			if len(items) > 2 and items[2].isdigit():
				_id = str(startTime) + '$' + str(aIndex)
				_time = es.timeToEsLocalTime(float(items[0]))
				addUserAction(userActions, _id, createTime, items[2], _time, uid, items)
				addWorksAction(worksDict, worksActions, _id, createTime, items[2], _time, uid, items)
			aIndex += 1

		startTime = max(startTime, createTime)

	es.updateStatisticsData('user_actions', userActions)
	es.updateStatisticsData('works_actions', worksActions)
	writeEndTime(startTime)

	return startTime

def readEndTime():
	with open('endTime.ini', 'r') as f:
		return float(f.read())

def writeEndTime(endTime):
	with open('endTime.ini', 'w') as f:
		f.write(str(endTime))

def readWorks():
	worksDict = {}
	worksActions = {}
	for hit in es.scrollSearch('works_video_read', 'video', {"size":1000}):
		worksInfo = hit['_source']
		if worksInfo.has_key('vid') and worksInfo.has_key('aid') and worksInfo.has_key('publishtime') and worksInfo['publishtime'] != None:
			vid = worksInfo['vid']
			worksDict[vid] = worksInfo
			worksActions[vid] = {'time': es.timeToEsLocalTime(es.esTimeToTime(worksInfo['publishtime'], True)), 'vid': vid, 'aid': worksInfo['aid'], 'duration': worksInfo['duration'], 'action': 4, 'uid': worksInfo['publisheruid'] if worksInfo.has_key('publisheruid') else 0, 'value': 1}
	es.updateStatisticsData('works_actions', worksActions)
	return worksDict

'''
2: 打开推荐页
3: 推荐页点击
4: 推荐曝光
5: 打开老的订阅页
6: 打开播放页
7: 主动打开推荐页
'''

def addUserAction(userActions, _id, createTime, actionId, _time, uid, items):
	if actionId == '7' and items[1] == 'pages/common/index/index':
		action = 2 if len(items) >= 5 and items[4] == '1' else 5
		value = 1
	elif actionId == '7' and items[1] == 'pages/common/videoplay/videoplay':
		action = 6
		value = 1
	elif actionId == '9' and items[4] == '3':
		action = 4
		value = 1
	elif actionId == '15':
		action = 7
		value = 1
	else:
		return
	userActions[_id] = {'createTime': createTime, 'time': _time, 'uid': uid, 'action': action, 'value': value}
	if actionId == '7' and items[1] == 'pages/common/videoplay/videoplay' and items[3] == '1' and items[5] == '4':
		userActions[_id + '$1'] = {'createTime': createTime, 'time': _time, 'uid': uid, 'action': 3, 'value': 1}

'''
1: 播放时长
2: 留存播放
3: 推荐曝光
4: 发布
5: 推荐点击
6: 播放页曝光
7: 播放页点击
8: 订阅页曝光
9: 订阅页点击
10: 主体页曝光
11: 主体页点击
12: 分享好友
13: 保存分享图片
14: 订阅
15: 取消订阅
16: 喜欢
17: 取消喜欢
'''
showMap = {'3': 3, '20': 6, '0': 8, '1': 10}
showPlayMap = {'4': 5, '1': 7, '2': 9, '3': 11}

def addWorksAction(worksDict, worksActions, _id, createTime, actionId, _time, uid, items):
	if actionId == '6':
		vid = items[3]
		action = 1
		value = int(items[4])
	elif actionId == '9' and showMap.has_key(items[4]):
		vid = items[3]
		action = showMap[items[4]]
		value = 1
	elif actionId == '7' and items[1] == 'pages/common/videoplay/videoplay' and items[3] == '1' and showPlayMap.has_key(items[5]):
		vid = items[4]
		action = showPlayMap[items[5]]
		value = 1
	else:
		return
	if not worksDict.has_key(vid):
		return
	worksInfo = worksDict[vid]
	worksActions[_id] = {'createTime': createTime, 'time': _time, 'vid': vid, 'aid': worksInfo['aid'], 'duration': worksInfo['duration'], 'action': action, 'uid': uid, 'value': value}
	if actionId == '6' and (value >= 60 or value >= 0.9 * worksInfo['duration']):
		worksActions[_id + '$1'] = {'createTime': createTime, 'time': _time, 'vid': vid, 'aid': worksInfo['aid'], 'duration': worksInfo['duration'], 'action': 2, 'uid': uid, 'value': 1}





