import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GrantConfig extends cdktf.TerraformMetaArguments {
    /**
    * The database to grant privileges on for this role
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/grant#database Grant#database}
    */
    readonly database: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/grant#id Grant#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The PostgreSQL object type to grant the privileges on (one of: database, function, procedure, routine, schema, sequence, table, foreign_data_wrapper, foreign_server)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/grant#object_type Grant#object_type}
    */
    readonly objectType: string;
    /**
    * The specific objects to grant privileges on for this role (empty means all objects of the requested type)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/grant#objects Grant#objects}
    */
    readonly objects?: string[];
    /**
    * The list of privileges to grant
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/grant#privileges Grant#privileges}
    */
    readonly privileges: string[];
    /**
    * The name of the role to grant privileges on
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/grant#role Grant#role}
    */
    readonly role: string;
    /**
    * The database schema to grant privileges on for this role
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/grant#schema Grant#schema}
    */
    readonly schema?: string;
    /**
    * Permit the grant recipient to grant it to others
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/grant#with_grant_option Grant#with_grant_option}
    */
    readonly withGrantOption?: boolean | cdktf.IResolvable;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/postgresql/r/grant postgresql_grant}
*/
export declare class Grant extends cdktf.TerraformResource {
    static readonly tfResourceType = "postgresql_grant";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/postgresql/r/grant postgresql_grant} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GrantConfig
    */
    constructor(scope: Construct, id: string, config: GrantConfig);
    private _database?;
    get database(): string;
    set database(value: string);
    get databaseInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _objectType?;
    get objectType(): string;
    set objectType(value: string);
    get objectTypeInput(): string | undefined;
    private _objects?;
    get objects(): string[];
    set objects(value: string[]);
    resetObjects(): void;
    get objectsInput(): string[] | undefined;
    private _privileges?;
    get privileges(): string[];
    set privileges(value: string[]);
    get privilegesInput(): string[] | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    resetSchema(): void;
    get schemaInput(): string | undefined;
    private _withGrantOption?;
    get withGrantOption(): boolean | cdktf.IResolvable;
    set withGrantOption(value: boolean | cdktf.IResolvable);
    resetWithGrantOption(): void;
    get withGrantOptionInput(): boolean | cdktf.IResolvable | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
