# coding: utf-8

# -----------------------------------------------------------------------------------
# <copyright company="Aspose">
#   Copyright (c) 2018 Aspose.Slides for Cloud
# </copyright>
# <summary>
#   Permission is hereby granted, free of charge, to any person obtaining a copy
#  of this software and associated documentation files (the "Software"), to deal
#  in the Software without restriction, including without limitation the rights
#  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
#  copies of the Software, and to permit persons to whom the Software is
#  furnished to do so, subject to the following conditions:
#
#  The above copyright notice and this permission notice shall be included in all
#  copies or substantial portions of the Software.
#
#  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
#  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
#  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
#  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
#  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
#  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
#  SOFTWARE.
# </summary>
# -----------------------------------------------------------------------------------

import pprint
import re  # noqa: F401

import six

from asposeslidescloud.models.shape_base import ShapeBase

class OleObjectFrame(ShapeBase):


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'self_uri': 'ResourceUri',
        'alternate_links': 'list[ResourceUri]',
        'name': 'str',
        'width': 'float',
        'height': 'float',
        'alternative_text': 'str',
        'alternative_text_title': 'str',
        'hidden': 'bool',
        'x': 'float',
        'y': 'float',
        'z_order_position': 'int',
        'shapes': 'ResourceUri',
        'fill_format': 'FillFormat',
        'effect_format': 'EffectFormat',
        'three_d_format': 'ThreeDFormat',
        'line_format': 'LineFormat',
        'type': 'str',
        'is_object_icon': 'bool',
        'substitute_picture_title': 'str'
    }

    attribute_map = {
        'self_uri': 'selfUri',
        'alternate_links': 'alternateLinks',
        'name': 'name',
        'width': 'width',
        'height': 'height',
        'alternative_text': 'alternativeText',
        'alternative_text_title': 'alternativeTextTitle',
        'hidden': 'hidden',
        'x': 'x',
        'y': 'y',
        'z_order_position': 'zOrderPosition',
        'shapes': 'shapes',
        'fill_format': 'fillFormat',
        'effect_format': 'effectFormat',
        'three_d_format': 'threeDFormat',
        'line_format': 'lineFormat',
        'type': 'type',
        'is_object_icon': 'isObjectIcon',
        'substitute_picture_title': 'substitutePictureTitle'
    }

    type_determiners = {
        'type': 'OleObjectFrame',
    }

    def __init__(self, self_uri=None, alternate_links=None, name=None, width=None, height=None, alternative_text=None, alternative_text_title=None, hidden=None, x=None, y=None, z_order_position=None, shapes=None, fill_format=None, effect_format=None, three_d_format=None, line_format=None, type='OleObjectFrame', is_object_icon=None, substitute_picture_title=None):  # noqa: E501
        """OleObjectFrame - a model defined in Swagger"""  # noqa: E501
        super(OleObjectFrame, self).__init__(self_uri, alternate_links, name, width, height, alternative_text, alternative_text_title, hidden, x, y, z_order_position, shapes, fill_format, effect_format, three_d_format, line_format, type)

        self._is_object_icon = None
        self._substitute_picture_title = None
        self.type = 'OleObjectFrame'

        self.is_object_icon = is_object_icon
        if substitute_picture_title is not None:
            self.substitute_picture_title = substitute_picture_title

    @property
    def is_object_icon(self):
        """Gets the is_object_icon of this OleObjectFrame.  # noqa: E501

        True if an object is visible as icon.  # noqa: E501

        :return: The is_object_icon of this OleObjectFrame.  # noqa: E501
        :rtype: bool
        """
        return self._is_object_icon

    @is_object_icon.setter
    def is_object_icon(self, is_object_icon):
        """Sets the is_object_icon of this OleObjectFrame.

        True if an object is visible as icon.  # noqa: E501

        :param is_object_icon: The is_object_icon of this OleObjectFrame.  # noqa: E501
        :type: bool
        """
        self._is_object_icon = is_object_icon

    @property
    def substitute_picture_title(self):
        """Gets the substitute_picture_title of this OleObjectFrame.  # noqa: E501

        The title for OleObject icon.               # noqa: E501

        :return: The substitute_picture_title of this OleObjectFrame.  # noqa: E501
        :rtype: str
        """
        return self._substitute_picture_title

    @substitute_picture_title.setter
    def substitute_picture_title(self, substitute_picture_title):
        """Sets the substitute_picture_title of this OleObjectFrame.

        The title for OleObject icon.               # noqa: E501

        :param substitute_picture_title: The substitute_picture_title of this OleObjectFrame.  # noqa: E501
        :type: str
        """
        self._substitute_picture_title = substitute_picture_title

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, OleObjectFrame):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
