r"""
Account value paths
===================================

Account value paths generated by the Monte Carlo simulation.
The first 100 and 1000 paths out of 10000 are plotted.

The investment return on account value is modeled to follow the following geometric Brownian motion

.. math::

    \frac{\Delta{S}}{S}=r\Delta{t}+\sigma\epsilon\sqrt{\Delta{t}}

where :math:`\Delta{S}` is the change in the account value :math:`S`, in a small interval of time,
:math:`\Delta{t}`, :math:`r` is the constant risk free rate, :math:`\sigma`
is the volatility of the account value and :math:`\epsilon` is a random number
drawn from the standard normal distribution.

.. seealso::

    * :doc:`/libraries/notebooks/savings/savings_example1` notebook in the :mod:`~savings` library


"""
import modelx as mx
import pandas as pd

model = mx.read_model("CashValue_ME_EX1")
proj = model.Projection
av = proj.av_pp_at

avs = list(av(t, 'BEF_FEE') for t in range(proj.max_proj_len()))
df = pd.DataFrame(avs)[1]

for scen_size in [100, 1000]:
    df[range(1, scen_size + 1)].plot.line(
        legend=False, grid=True, title="%s scenarios" % scen_size)



