# -*- coding: utf-8 -*-
# Generated by Django 1.11.2 on 2018-10-26 11:10


from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('basemodels', '0001_initial'),
        ('products', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='Membership',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('is_read', models.BooleanField(default=False, verbose_name='Is Read')),
            ],
            options={
                'verbose_name': 'Membership',
                'verbose_name_plural': 'Memberships',
            },
        ),
        migrations.CreateModel(
            name='Notification',
            fields=[
                ('basemodel_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='basemodels.BaseModel')),
                ('title', models.CharField(max_length=50, verbose_name='Title')),
                ('description', models.CharField(max_length=255, verbose_name='Message')),
                ('type', models.CharField(choices=[('i', '\\u0627\\u0637\\u0644\\u0627\\u0639\\u0627\\u062a'), ('s', '\\u0645\\u0648\\u0641\\u0642\\u06cc\\u062a'), ('w', '\\u0647\\u0634\\u062f\\u0627\\u0631'), ('e', '\\u062e\\u0637\\u0627')], max_length=1, verbose_name='Type')),
                ('is_for_all_users', models.BooleanField(default=True, verbose_name='Is For All Users')),
                ('datetime', models.DateTimeField(auto_now_add=True, verbose_name='Datetime')),
                ('from_user_obj', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='notificaiton_from_user', to=settings.AUTH_USER_MODEL, verbose_name='\\u0627\\u0632 \\u06a9\\u0627\\u0631\\u0628\\u0631')),
                ('model_obj', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='notification_model_obj', to='basemodels.BaseModel', verbose_name='Model')),
                ('products_buy', models.ManyToManyField(blank=True, related_name='notification_products_buy', to='products.Product', verbose_name='Purchase specific products')),
                ('products_buy_did_not', models.ManyToManyField(blank=True, related_name='notification_products_buy_did_not', to='products.Product', verbose_name='Did not purchase specific products ')),
                ('users', models.ManyToManyField(through='notifications.Membership', to=settings.AUTH_USER_MODEL, verbose_name='Membership')),
            ],
            options={
                'verbose_name': 'Notification',
                'verbose_name_plural': 'Notifications',
            },
            bases=('basemodels.basemodel',),
        ),
        migrations.AddField(
            model_name='membership',
            name='notification',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='notifications.Notification', verbose_name='Notification'),
        ),
        migrations.AddField(
            model_name='membership',
            name='user',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL, verbose_name='User'),
        ),
        migrations.CreateModel(
            name='NotificationForSingleUser',
            fields=[
            ],
            options={
                'verbose_name': 'Notification For Single User',
                'proxy': True,
                'verbose_name_plural': 'Notifications For Single User',
                'indexes': [],
            },
            bases=('notifications.notification',),
        ),
    ]
