# -*- coding: utf-8 -*-
# Generated by Django 1.11.2 on 2019-02-01 19:30


from django.db import migrations


def add_keys(apps, schema_editor):
    '''
    We can't import the Post model directly as it may be a newer
    version than this migration expects. We use the historical version.
    '''
    Setting = apps.get_model('settings', 'Setting')
    key = ''
    try:
        key = 'VISIT_COUNT_PER_VIEW'
        Setting.objects.get(key=key)
    except Exception:
        Setting.objects.create(
            title='نحوه شمارش محصولات، اخبار و...',
            key=key,
            value='False',
            value_type='b',
            is_show=False,
            is_variable_in_home=False,
        )


class Migration(migrations.Migration):

    dependencies = [
        ('settings', '0014_auto_20190128_1350'),
    ]

    operations = [
        migrations.RunPython(add_keys, reverse_code=migrations.RunPython.noop),
    ]
