# -*- coding: utf-8 -*-
# Generated by Django 1.11.2 on 2018-12-02 15:29


from django.db import migrations


def negative_default_value(apps, schema_editor):
    '''
    We can't import the Post model directly as it may be a newer
    version than this migration expects. We use the historical version.
    '''
    User = apps.get_model('aparnik_users', 'User')
    User.objects.filter(limit_device_login=0).update(limit_device_login=-1)
    User.objects.filter(co_sale_percentage_value=0).update(co_sale_percentage_value=-1)


def zero_default_value(apps, schema_editor):
    User = apps.get_model('aparnik_users', 'User')
    User.objects.filter(limit_device_login=-1).update(limit_device_login=0)
    User.objects.filter(co_sale_percentage_value=-1).update(co_sale_percentage_value=0)


class Migration(migrations.Migration):

    dependencies = [
        ('aparnik_users', '0010_auto_20181202_1528'),
    ]

    operations = [
        migrations.RunPython(negative_default_value, reverse_code=zero_default_value),
    ]
