# -*- coding: utf-8 -*-
# Generated by Django 1.11.2 on 2019-03-19 17:45


from django.db import migrations
from faker import Faker


def username_mention(apps, schema_editor):
    '''
    We can't import the Post model directly as it may be a newer
    version than this migration expects. We use the historical version.
    '''
    faker = Faker()

    User = apps.get_model('aparnik_users', 'User')
    for user in User.objects.all():
        username = faker.user_name()
        while User.objects.filter(username_mention=username).exists():
            username = faker.user_name()

        user.username_mention = username
        user.save()


class Migration(migrations.Migration):

    dependencies = [
        ('aparnik_users', '0017_auto_20190319_1744'),
    ]

    operations = [
        migrations.RunPython(username_mention, reverse_code=migrations.RunPython.noop),
    ]
