# -*- coding: utf-8 -*-
# Generated by Django 1.11.2 on 2018-10-25 15:43


from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('segments', '0001_initial'),
        ('basemodels', '0001_initial'),
        ('categories', '0001_initial'),
        ('books', '0001_initial'),
        ('filefields', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='BookSegment',
            fields=[
                ('basesegment_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='segments.BaseSegment')),
            ],
            options={
                'verbose_name': 'Book Segment',
                'verbose_name_plural': 'Book Segments',
            },
            bases=('segments.basesegment',),
        ),
        migrations.CreateModel(
            name='Publisher',
            fields=[
                ('basemodel_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='basemodels.BaseModel')),
                ('title', models.CharField(max_length=255, verbose_name='Title')),
            ],
            options={
                'verbose_name': 'Publisher',
                'verbose_name_plural': 'Publishers',
            },
            bases=('basemodels.basemodel',),
        ),
        migrations.CreateModel(
            name='WriterTranslator',
            fields=[
                ('basemodel_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='basemodels.BaseModel')),
                ('first_name', models.CharField(max_length=60, verbose_name='First Name')),
                ('last_name', models.CharField(max_length=60, verbose_name='\\u0646\\u0627\\u0645 \\u062e\\u0627\\u0646\\u0648\\u0627\\u062f\\u06af\\u06cc')),
            ],
            options={
                'verbose_name': 'Writer Translator',
                'verbose_name_plural': 'Writers Translators',
            },
            bases=('basemodels.basemodel',),
        ),
        migrations.AddField(
            model_name='book',
            name='category_obj',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='categories.Category', verbose_name='Category'),
        ),
        migrations.AddField(
            model_name='book',
            name='publisher_obj',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='books.Publisher', verbose_name='Publisher'),
        ),
        migrations.AddField(
            model_name='book',
            name='sample_book',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='filefields.FileField', verbose_name='Sample Book'),
        ),
        migrations.AddField(
            model_name='book',
            name='translators_obj',
            field=models.ManyToManyField(null=True, related_name='library_translators', to='books.WriterTranslator', verbose_name='Translators'),
        ),
        migrations.AddField(
            model_name='book',
            name='writers_obj',
            field=models.ManyToManyField(related_name='library_writers', to='books.WriterTranslator', verbose_name='Writers'),
        ),
    ]
