# -*- coding: utf-8 -*-
# Generated by Django 1.11.2 on 2019-01-21 18:56


from django.db import migrations
import uuid


def order_generate_uuid(apps, schema_editor):
    '''
    We can't import the Post model directly as it may be a newer
    version than this migration expects. We use the historical version.
    '''
    Object = apps.get_model('orders', 'Order')
    for obj in Object.objects.all():
        uu = uuid.uuid4()
        while Object.objects.filter(uuid=uu).count() > 0:
            uu = uuid.uuid4()
        obj.uuid = uu
        obj.save()


class Migration(migrations.Migration):

    dependencies = [
        ('orders', '0006_order_uuid'),
    ]

    operations = [
        migrations.RunPython(order_generate_uuid, reverse_code=migrations.RunPython.noop),
    ]
