# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ApplicationScopeArgs', 'ApplicationScope']

@pulumi.input_type
class ApplicationScopeArgs:
    def __init__(__self__, *,
                 categories: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationScopeCategoryArgs']]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 owner_email: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a ApplicationScope resource.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationScopeCategoryArgs']]] categories: Artifacts (of applications) / Workloads (containers) / Infrastructure (elements).
        :param pulumi.Input[str] description: Description of the application scope.
        :param pulumi.Input[str] name: Name of an application scope.
        :param pulumi.Input[str] owner_email: Name of an application scope.
        """
        if categories is not None:
            pulumi.set(__self__, "categories", categories)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if owner_email is not None:
            pulumi.set(__self__, "owner_email", owner_email)

    @property
    @pulumi.getter
    def categories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationScopeCategoryArgs']]]]:
        """
        Artifacts (of applications) / Workloads (containers) / Infrastructure (elements).
        """
        return pulumi.get(self, "categories")

    @categories.setter
    def categories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationScopeCategoryArgs']]]]):
        pulumi.set(self, "categories", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the application scope.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of an application scope.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="ownerEmail")
    def owner_email(self) -> Optional[pulumi.Input[str]]:
        """
        Name of an application scope.
        """
        return pulumi.get(self, "owner_email")

    @owner_email.setter
    def owner_email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "owner_email", value)


@pulumi.input_type
class _ApplicationScopeState:
    def __init__(__self__, *,
                 author: Optional[pulumi.Input[str]] = None,
                 categories: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationScopeCategoryArgs']]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 owner_email: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ApplicationScope resources.
        :param pulumi.Input[str] author: Username of the account that created the service.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationScopeCategoryArgs']]] categories: Artifacts (of applications) / Workloads (containers) / Infrastructure (elements).
        :param pulumi.Input[str] description: Description of the application scope.
        :param pulumi.Input[str] name: Name of an application scope.
        :param pulumi.Input[str] owner_email: Name of an application scope.
        """
        if author is not None:
            pulumi.set(__self__, "author", author)
        if categories is not None:
            pulumi.set(__self__, "categories", categories)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if owner_email is not None:
            pulumi.set(__self__, "owner_email", owner_email)

    @property
    @pulumi.getter
    def author(self) -> Optional[pulumi.Input[str]]:
        """
        Username of the account that created the service.
        """
        return pulumi.get(self, "author")

    @author.setter
    def author(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "author", value)

    @property
    @pulumi.getter
    def categories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationScopeCategoryArgs']]]]:
        """
        Artifacts (of applications) / Workloads (containers) / Infrastructure (elements).
        """
        return pulumi.get(self, "categories")

    @categories.setter
    def categories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationScopeCategoryArgs']]]]):
        pulumi.set(self, "categories", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the application scope.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of an application scope.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="ownerEmail")
    def owner_email(self) -> Optional[pulumi.Input[str]]:
        """
        Name of an application scope.
        """
        return pulumi.get(self, "owner_email")

    @owner_email.setter
    def owner_email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "owner_email", value)


class ApplicationScope(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 categories: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApplicationScopeCategoryArgs']]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 owner_email: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Create a ApplicationScope resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApplicationScopeCategoryArgs']]]] categories: Artifacts (of applications) / Workloads (containers) / Infrastructure (elements).
        :param pulumi.Input[str] description: Description of the application scope.
        :param pulumi.Input[str] name: Name of an application scope.
        :param pulumi.Input[str] owner_email: Name of an application scope.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ApplicationScopeArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a ApplicationScope resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param ApplicationScopeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ApplicationScopeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 categories: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApplicationScopeCategoryArgs']]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 owner_email: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ApplicationScopeArgs.__new__(ApplicationScopeArgs)

            __props__.__dict__["categories"] = categories
            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            __props__.__dict__["owner_email"] = owner_email
            __props__.__dict__["author"] = None
        super(ApplicationScope, __self__).__init__(
            'aquasec:index/applicationScope:ApplicationScope',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            author: Optional[pulumi.Input[str]] = None,
            categories: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApplicationScopeCategoryArgs']]]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            owner_email: Optional[pulumi.Input[str]] = None) -> 'ApplicationScope':
        """
        Get an existing ApplicationScope resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] author: Username of the account that created the service.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApplicationScopeCategoryArgs']]]] categories: Artifacts (of applications) / Workloads (containers) / Infrastructure (elements).
        :param pulumi.Input[str] description: Description of the application scope.
        :param pulumi.Input[str] name: Name of an application scope.
        :param pulumi.Input[str] owner_email: Name of an application scope.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ApplicationScopeState.__new__(_ApplicationScopeState)

        __props__.__dict__["author"] = author
        __props__.__dict__["categories"] = categories
        __props__.__dict__["description"] = description
        __props__.__dict__["name"] = name
        __props__.__dict__["owner_email"] = owner_email
        return ApplicationScope(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def author(self) -> pulumi.Output[str]:
        """
        Username of the account that created the service.
        """
        return pulumi.get(self, "author")

    @property
    @pulumi.getter
    def categories(self) -> pulumi.Output[Sequence['outputs.ApplicationScopeCategory']]:
        """
        Artifacts (of applications) / Workloads (containers) / Infrastructure (elements).
        """
        return pulumi.get(self, "categories")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Description of the application scope.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of an application scope.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="ownerEmail")
    def owner_email(self) -> pulumi.Output[Optional[str]]:
        """
        Name of an application scope.
        """
        return pulumi.get(self, "owner_email")

