# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['NotificationArgs', 'Notification']

@pulumi.input_type
class NotificationArgs:
    def __init__(__self__, *,
                 properties: pulumi.Input[Mapping[str, pulumi.Input[str]]],
                 type: pulumi.Input[str],
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Notification resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: Notification properties, please check the examples for setting it
        :param pulumi.Input[str] type: Notifications types, allowed values: slack\\ jira\\ email\\ teams\\ webhook\\ splunk\\ serviceNow
        :param pulumi.Input[str] name: Notification name
        """
        pulumi.set(__self__, "properties", properties)
        pulumi.set(__self__, "type", type)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def properties(self) -> pulumi.Input[Mapping[str, pulumi.Input[str]]]:
        """
        Notification properties, please check the examples for setting it
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: pulumi.Input[Mapping[str, pulumi.Input[str]]]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Notifications types, allowed values: slack\\ jira\\ email\\ teams\\ webhook\\ splunk\\ serviceNow
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Notification name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _NotificationState:
    def __init__(__self__, *,
                 author: Optional[pulumi.Input[str]] = None,
                 last_updated: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 template: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Notification resources.
        :param pulumi.Input[str] author: The user that created the notification
        :param pulumi.Input[str] last_updated: Notification last update time
        :param pulumi.Input[str] name: Notification name
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: Notification properties, please check the examples for setting it
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] template: Notification Template
        :param pulumi.Input[str] type: Notifications types, allowed values: slack\\ jira\\ email\\ teams\\ webhook\\ splunk\\ serviceNow
        """
        if author is not None:
            pulumi.set(__self__, "author", author)
        if last_updated is not None:
            pulumi.set(__self__, "last_updated", last_updated)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if template is not None:
            pulumi.set(__self__, "template", template)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def author(self) -> Optional[pulumi.Input[str]]:
        """
        The user that created the notification
        """
        return pulumi.get(self, "author")

    @author.setter
    def author(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "author", value)

    @property
    @pulumi.getter(name="lastUpdated")
    def last_updated(self) -> Optional[pulumi.Input[str]]:
        """
        Notification last update time
        """
        return pulumi.get(self, "last_updated")

    @last_updated.setter
    def last_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_updated", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Notification name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Notification properties, please check the examples for setting it
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter
    def template(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Notification Template
        """
        return pulumi.get(self, "template")

    @template.setter
    def template(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "template", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Notifications types, allowed values: slack\\ jira\\ email\\ teams\\ webhook\\ splunk\\ serviceNow
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


class Notification(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a Aquasec Notification resource. This can be used to create and manage Aquasec Notification resources.

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_aquasec as aquasec

        teams = aquasec.Notification("teams",
            properties={
                "url": "<TEAMS-URL>",
            },
            type="teams")
        slack = aquasec.Notification("slack",
            properties={
                "url": "<SLACK-URL>",
            },
            type="slack")
        webhook = aquasec.Notification("webhook",
            properties={
                "url": "<WEBHOOK-URL>",
            },
            type="webhook")
        servicenow = aquasec.Notification("servicenow",
            properties={
                "board_name": "",
                "instance_name": "",
                "password": "<PASSWORD>",
                "url": "<SERVICENOW-URL>",
                "user": "<USERNAME>",
            },
            type="serviceNow")
        jira_with_token = aquasec.Notification("jiraWithToken",
            properties={
                "definition_of_done": "Done",
                "project_key": "<JIRA_PROJECT_KEY>",
                "summary": "SOME_TEXT",
                "token": "<JIRA-TOKEN>",
                "url": "<JIRA-URL>",
            },
            type="jira")
        jira_with_creds = aquasec.Notification("jiraWithCreds",
            properties={
                "password": "<JIRA_PASSWORD>",
                "project_key": "<JIRA_PROJECT_KEY>",
                "summary": "SOME_TEXT",
                "url": "<JIRA-URL>",
                "user": "<JIRA_USERNAME>",
            },
            type="jira")
        email_with_creds = aquasec.Notification("emailWithCreds",
            properties={
                "host": "<EMAIL_HOST>",
                "password": "<EMAIL_PASSWORD>",
                "port": "<EMAIL_PORT>",
                "recipients": "<RECIPIENTS>",
                "sender": "<SENDER_EMAIL_ADDRESS>",
                "user": "<EMAIL_USERNAME>",
            },
            type="email")
        email_with_mx = aquasec.Notification("emailWithMx",
            properties={
                "port": "<EMAIL_PORT>",
                "recipients": "<RECIPIENTS>",
                "sender": "<SENDER_EMAIL_ADDRESS>",
                "use_mx": "true",
            },
            type="email")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] name: Notification name
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: Notification properties, please check the examples for setting it
        :param pulumi.Input[str] type: Notifications types, allowed values: slack\\ jira\\ email\\ teams\\ webhook\\ splunk\\ serviceNow
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NotificationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Aquasec Notification resource. This can be used to create and manage Aquasec Notification resources.

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_aquasec as aquasec

        teams = aquasec.Notification("teams",
            properties={
                "url": "<TEAMS-URL>",
            },
            type="teams")
        slack = aquasec.Notification("slack",
            properties={
                "url": "<SLACK-URL>",
            },
            type="slack")
        webhook = aquasec.Notification("webhook",
            properties={
                "url": "<WEBHOOK-URL>",
            },
            type="webhook")
        servicenow = aquasec.Notification("servicenow",
            properties={
                "board_name": "",
                "instance_name": "",
                "password": "<PASSWORD>",
                "url": "<SERVICENOW-URL>",
                "user": "<USERNAME>",
            },
            type="serviceNow")
        jira_with_token = aquasec.Notification("jiraWithToken",
            properties={
                "definition_of_done": "Done",
                "project_key": "<JIRA_PROJECT_KEY>",
                "summary": "SOME_TEXT",
                "token": "<JIRA-TOKEN>",
                "url": "<JIRA-URL>",
            },
            type="jira")
        jira_with_creds = aquasec.Notification("jiraWithCreds",
            properties={
                "password": "<JIRA_PASSWORD>",
                "project_key": "<JIRA_PROJECT_KEY>",
                "summary": "SOME_TEXT",
                "url": "<JIRA-URL>",
                "user": "<JIRA_USERNAME>",
            },
            type="jira")
        email_with_creds = aquasec.Notification("emailWithCreds",
            properties={
                "host": "<EMAIL_HOST>",
                "password": "<EMAIL_PASSWORD>",
                "port": "<EMAIL_PORT>",
                "recipients": "<RECIPIENTS>",
                "sender": "<SENDER_EMAIL_ADDRESS>",
                "user": "<EMAIL_USERNAME>",
            },
            type="email")
        email_with_mx = aquasec.Notification("emailWithMx",
            properties={
                "port": "<EMAIL_PORT>",
                "recipients": "<RECIPIENTS>",
                "sender": "<SENDER_EMAIL_ADDRESS>",
                "use_mx": "true",
            },
            type="email")
        ```

        :param str resource_name: The name of the resource.
        :param NotificationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NotificationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NotificationArgs.__new__(NotificationArgs)

            __props__.__dict__["name"] = name
            if properties is None and not opts.urn:
                raise TypeError("Missing required property 'properties'")
            __props__.__dict__["properties"] = properties
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["author"] = None
            __props__.__dict__["last_updated"] = None
            __props__.__dict__["template"] = None
        super(Notification, __self__).__init__(
            'aquasec:index/notification:Notification',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            author: Optional[pulumi.Input[str]] = None,
            last_updated: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            template: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            type: Optional[pulumi.Input[str]] = None) -> 'Notification':
        """
        Get an existing Notification resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] author: The user that created the notification
        :param pulumi.Input[str] last_updated: Notification last update time
        :param pulumi.Input[str] name: Notification name
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: Notification properties, please check the examples for setting it
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] template: Notification Template
        :param pulumi.Input[str] type: Notifications types, allowed values: slack\\ jira\\ email\\ teams\\ webhook\\ splunk\\ serviceNow
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NotificationState.__new__(_NotificationState)

        __props__.__dict__["author"] = author
        __props__.__dict__["last_updated"] = last_updated
        __props__.__dict__["name"] = name
        __props__.__dict__["properties"] = properties
        __props__.__dict__["template"] = template
        __props__.__dict__["type"] = type
        return Notification(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def author(self) -> pulumi.Output[str]:
        """
        The user that created the notification
        """
        return pulumi.get(self, "author")

    @property
    @pulumi.getter(name="lastUpdated")
    def last_updated(self) -> pulumi.Output[str]:
        """
        Notification last update time
        """
        return pulumi.get(self, "last_updated")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Notification name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def properties(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Notification properties, please check the examples for setting it
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter
    def template(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Notification Template
        """
        return pulumi.get(self, "template")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        Notifications types, allowed values: slack\\ jira\\ email\\ teams\\ webhook\\ splunk\\ serviceNow
        """
        return pulumi.get(self, "type")

