# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['UserArgs', 'User']

@pulumi.input_type
class UserArgs:
    def __init__(__self__, *,
                 password: pulumi.Input[str],
                 roles: pulumi.Input[Sequence[pulumi.Input[str]]],
                 user_id: pulumi.Input[str],
                 email: Optional[pulumi.Input[str]] = None,
                 first_time: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 password_confirm: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a User resource.
        :param pulumi.Input[str] password: Login password for the user; string, required, at least 8 characters long.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] roles: The roles that will be assigned to the user.
        :param pulumi.Input[str] user_id: The user ID.
        :param pulumi.Input[str] email: The user Email.
        :param pulumi.Input[bool] first_time: If the user must change the password first login. Applicable only one time, Later for user password resets use aqua console.
        :param pulumi.Input[str] name: The user name.
        :param pulumi.Input[str] password_confirm: Password confirmation.
        """
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "roles", roles)
        pulumi.set(__self__, "user_id", user_id)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if first_time is not None:
            pulumi.set(__self__, "first_time", first_time)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if password_confirm is not None:
            pulumi.set(__self__, "password_confirm", password_confirm)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Input[str]:
        """
        Login password for the user; string, required, at least 8 characters long.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[str]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def roles(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The roles that will be assigned to the user.
        """
        return pulumi.get(self, "roles")

    @roles.setter
    def roles(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "roles", value)

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> pulumi.Input[str]:
        """
        The user ID.
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "user_id", value)

    @property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[str]]:
        """
        The user Email.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter(name="firstTime")
    def first_time(self) -> Optional[pulumi.Input[bool]]:
        """
        If the user must change the password first login. Applicable only one time, Later for user password resets use aqua console.
        """
        return pulumi.get(self, "first_time")

    @first_time.setter
    def first_time(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "first_time", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The user name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="passwordConfirm")
    def password_confirm(self) -> Optional[pulumi.Input[str]]:
        """
        Password confirmation.
        """
        return pulumi.get(self, "password_confirm")

    @password_confirm.setter
    def password_confirm(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password_confirm", value)


@pulumi.input_type
class _UserState:
    def __init__(__self__, *,
                 email: Optional[pulumi.Input[str]] = None,
                 first_time: Optional[pulumi.Input[bool]] = None,
                 is_super: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 password_confirm: Optional[pulumi.Input[str]] = None,
                 plan: Optional[pulumi.Input[str]] = None,
                 role: Optional[pulumi.Input[str]] = None,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 ui_access: Optional[pulumi.Input[bool]] = None,
                 user_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering User resources.
        :param pulumi.Input[str] email: The user Email.
        :param pulumi.Input[bool] first_time: If the user must change the password first login. Applicable only one time, Later for user password resets use aqua console.
        :param pulumi.Input[bool] is_super: Give the Permission Set full access, meaning all actions are allowed without restriction.
        :param pulumi.Input[str] name: The user name.
        :param pulumi.Input[str] password: Login password for the user; string, required, at least 8 characters long.
        :param pulumi.Input[str] password_confirm: Password confirmation.
        :param pulumi.Input[str] plan: User's Aqua plan (Developer / Team / Advanced).
        :param pulumi.Input[str] role: The first role that assigned to the user for backward compatibility.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] roles: The roles that will be assigned to the user.
        :param pulumi.Input[str] type: The user type (Aqua, LDAP, SAML, OAuth2, OpenID, Tenant Manager).
        :param pulumi.Input[bool] ui_access: Whether to allow UI access for users with this Permission Set.
        :param pulumi.Input[str] user_id: The user ID.
        """
        if email is not None:
            pulumi.set(__self__, "email", email)
        if first_time is not None:
            pulumi.set(__self__, "first_time", first_time)
        if is_super is not None:
            pulumi.set(__self__, "is_super", is_super)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if password_confirm is not None:
            pulumi.set(__self__, "password_confirm", password_confirm)
        if plan is not None:
            pulumi.set(__self__, "plan", plan)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if roles is not None:
            pulumi.set(__self__, "roles", roles)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if ui_access is not None:
            pulumi.set(__self__, "ui_access", ui_access)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)

    @property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[str]]:
        """
        The user Email.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter(name="firstTime")
    def first_time(self) -> Optional[pulumi.Input[bool]]:
        """
        If the user must change the password first login. Applicable only one time, Later for user password resets use aqua console.
        """
        return pulumi.get(self, "first_time")

    @first_time.setter
    def first_time(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "first_time", value)

    @property
    @pulumi.getter(name="isSuper")
    def is_super(self) -> Optional[pulumi.Input[bool]]:
        """
        Give the Permission Set full access, meaning all actions are allowed without restriction.
        """
        return pulumi.get(self, "is_super")

    @is_super.setter
    def is_super(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_super", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The user name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        Login password for the user; string, required, at least 8 characters long.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="passwordConfirm")
    def password_confirm(self) -> Optional[pulumi.Input[str]]:
        """
        Password confirmation.
        """
        return pulumi.get(self, "password_confirm")

    @password_confirm.setter
    def password_confirm(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password_confirm", value)

    @property
    @pulumi.getter
    def plan(self) -> Optional[pulumi.Input[str]]:
        """
        User's Aqua plan (Developer / Team / Advanced).
        """
        return pulumi.get(self, "plan")

    @plan.setter
    def plan(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "plan", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[str]]:
        """
        The first role that assigned to the user for backward compatibility.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role", value)

    @property
    @pulumi.getter
    def roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The roles that will be assigned to the user.
        """
        return pulumi.get(self, "roles")

    @roles.setter
    def roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "roles", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The user type (Aqua, LDAP, SAML, OAuth2, OpenID, Tenant Manager).
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="uiAccess")
    def ui_access(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to allow UI access for users with this Permission Set.
        """
        return pulumi.get(self, "ui_access")

    @ui_access.setter
    def ui_access(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ui_access", value)

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[pulumi.Input[str]]:
        """
        The user ID.
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_id", value)


class User(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 email: Optional[pulumi.Input[str]] = None,
                 first_time: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 password_confirm: Optional[pulumi.Input[str]] = None,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 user_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        The `User` resource manages your users within Aqua.

        The users created must have at least one Role that is already present within Aqua.

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_aquasec as aquasec

        ia_c = aquasec.User("iaC",
            user_id="IaC",
            password=var["password"],
            roles=["infrastructure"],
            email="infrastructure@example.com",
            first_time=True)
        # Display name for this user
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] email: The user Email.
        :param pulumi.Input[bool] first_time: If the user must change the password first login. Applicable only one time, Later for user password resets use aqua console.
        :param pulumi.Input[str] name: The user name.
        :param pulumi.Input[str] password: Login password for the user; string, required, at least 8 characters long.
        :param pulumi.Input[str] password_confirm: Password confirmation.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] roles: The roles that will be assigned to the user.
        :param pulumi.Input[str] user_id: The user ID.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: UserArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The `User` resource manages your users within Aqua.

        The users created must have at least one Role that is already present within Aqua.

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_aquasec as aquasec

        ia_c = aquasec.User("iaC",
            user_id="IaC",
            password=var["password"],
            roles=["infrastructure"],
            email="infrastructure@example.com",
            first_time=True)
        # Display name for this user
        ```

        :param str resource_name: The name of the resource.
        :param UserArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UserArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 email: Optional[pulumi.Input[str]] = None,
                 first_time: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 password_confirm: Optional[pulumi.Input[str]] = None,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 user_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UserArgs.__new__(UserArgs)

            __props__.__dict__["email"] = email
            __props__.__dict__["first_time"] = first_time
            __props__.__dict__["name"] = name
            if password is None and not opts.urn:
                raise TypeError("Missing required property 'password'")
            __props__.__dict__["password"] = password
            __props__.__dict__["password_confirm"] = password_confirm
            if roles is None and not opts.urn:
                raise TypeError("Missing required property 'roles'")
            __props__.__dict__["roles"] = roles
            if user_id is None and not opts.urn:
                raise TypeError("Missing required property 'user_id'")
            __props__.__dict__["user_id"] = user_id
            __props__.__dict__["is_super"] = None
            __props__.__dict__["plan"] = None
            __props__.__dict__["role"] = None
            __props__.__dict__["type"] = None
            __props__.__dict__["ui_access"] = None
        super(User, __self__).__init__(
            'aquasec:index/user:User',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            email: Optional[pulumi.Input[str]] = None,
            first_time: Optional[pulumi.Input[bool]] = None,
            is_super: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            password: Optional[pulumi.Input[str]] = None,
            password_confirm: Optional[pulumi.Input[str]] = None,
            plan: Optional[pulumi.Input[str]] = None,
            role: Optional[pulumi.Input[str]] = None,
            roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            type: Optional[pulumi.Input[str]] = None,
            ui_access: Optional[pulumi.Input[bool]] = None,
            user_id: Optional[pulumi.Input[str]] = None) -> 'User':
        """
        Get an existing User resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] email: The user Email.
        :param pulumi.Input[bool] first_time: If the user must change the password first login. Applicable only one time, Later for user password resets use aqua console.
        :param pulumi.Input[bool] is_super: Give the Permission Set full access, meaning all actions are allowed without restriction.
        :param pulumi.Input[str] name: The user name.
        :param pulumi.Input[str] password: Login password for the user; string, required, at least 8 characters long.
        :param pulumi.Input[str] password_confirm: Password confirmation.
        :param pulumi.Input[str] plan: User's Aqua plan (Developer / Team / Advanced).
        :param pulumi.Input[str] role: The first role that assigned to the user for backward compatibility.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] roles: The roles that will be assigned to the user.
        :param pulumi.Input[str] type: The user type (Aqua, LDAP, SAML, OAuth2, OpenID, Tenant Manager).
        :param pulumi.Input[bool] ui_access: Whether to allow UI access for users with this Permission Set.
        :param pulumi.Input[str] user_id: The user ID.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UserState.__new__(_UserState)

        __props__.__dict__["email"] = email
        __props__.__dict__["first_time"] = first_time
        __props__.__dict__["is_super"] = is_super
        __props__.__dict__["name"] = name
        __props__.__dict__["password"] = password
        __props__.__dict__["password_confirm"] = password_confirm
        __props__.__dict__["plan"] = plan
        __props__.__dict__["role"] = role
        __props__.__dict__["roles"] = roles
        __props__.__dict__["type"] = type
        __props__.__dict__["ui_access"] = ui_access
        __props__.__dict__["user_id"] = user_id
        return User(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def email(self) -> pulumi.Output[Optional[str]]:
        """
        The user Email.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter(name="firstTime")
    def first_time(self) -> pulumi.Output[Optional[bool]]:
        """
        If the user must change the password first login. Applicable only one time, Later for user password resets use aqua console.
        """
        return pulumi.get(self, "first_time")

    @property
    @pulumi.getter(name="isSuper")
    def is_super(self) -> pulumi.Output[bool]:
        """
        Give the Permission Set full access, meaning all actions are allowed without restriction.
        """
        return pulumi.get(self, "is_super")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The user name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[str]:
        """
        Login password for the user; string, required, at least 8 characters long.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="passwordConfirm")
    def password_confirm(self) -> pulumi.Output[Optional[str]]:
        """
        Password confirmation.
        """
        return pulumi.get(self, "password_confirm")

    @property
    @pulumi.getter
    def plan(self) -> pulumi.Output[str]:
        """
        User's Aqua plan (Developer / Team / Advanced).
        """
        return pulumi.get(self, "plan")

    @property
    @pulumi.getter
    def role(self) -> pulumi.Output[str]:
        """
        The first role that assigned to the user for backward compatibility.
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter
    def roles(self) -> pulumi.Output[Sequence[str]]:
        """
        The roles that will be assigned to the user.
        """
        return pulumi.get(self, "roles")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The user type (Aqua, LDAP, SAML, OAuth2, OpenID, Tenant Manager).
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="uiAccess")
    def ui_access(self) -> pulumi.Output[bool]:
        """
        Whether to allow UI access for users with this Permission Set.
        """
        return pulumi.get(self, "ui_access")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> pulumi.Output[str]:
        """
        The user ID.
        """
        return pulumi.get(self, "user_id")

