#!/usr/bin/env node
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const ec2 = require("@aws-cdk/aws-ec2");
const cdk = require("@aws-cdk/core");
const elbv2 = require("../lib");
const app = new cdk.App();
const stack = new cdk.Stack(app, 'aws-cdk-elbv2-integ');
const vpc = new ec2.Vpc(stack, 'VPC', {
    maxAzs: 2,
});
const lb = new elbv2.ApplicationLoadBalancer(stack, 'LB', {
    vpc,
    internetFacing: true,
});
const listener = lb.addListener('Listener', {
    port: 80,
});
const group1 = listener.addTargets('Target', {
    port: 80,
    targets: [new elbv2.IpTarget('10.0.128.4')],
});
const group2 = listener.addTargets('ConditionalTarget', {
    priority: 10,
    hostHeader: 'example.com',
    port: 80,
    targets: [new elbv2.IpTarget('10.0.128.5')],
});
listener.addAction('action1', {
    priority: 1,
    conditions: [
        elbv2.ListenerCondition.hostHeaders(['example.com']),
    ],
    action: elbv2.ListenerAction.fixedResponse(200, { messageBody: 'success' }),
});
group1.metricTargetResponseTime().createAlarm(stack, 'ResponseTimeHigh1', {
    threshold: 5,
    evaluationPeriods: 2,
});
group2.metricTargetResponseTime().createAlarm(stack, 'ResponseTimeHigh2', {
    threshold: 5,
    evaluationPeriods: 2,
});
app.synth();
//# sourceMappingURL=data:application/json;base64,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