"use strict";
const assert_1 = require("@aws-cdk/assert");
const ec2 = require("@aws-cdk/aws-ec2");
const cdk = require("@aws-cdk/core");
const elbv2 = require("../../lib");
let stack;
let group1;
let group2;
let lb;
module.exports = {
    'setUp'(cb) {
        stack = new cdk.Stack();
        const vpc = new ec2.Vpc(stack, 'Stack');
        group1 = new elbv2.NetworkTargetGroup(stack, 'TargetGroup1', { vpc, port: 80 });
        group2 = new elbv2.NetworkTargetGroup(stack, 'TargetGroup2', { vpc, port: 80 });
        lb = new elbv2.NetworkLoadBalancer(stack, 'LB', { vpc });
        cb();
    },
    'Forward to multiple targetgroups with an Action and stickiness'(test) {
        // WHEN
        lb.addListener('Listener', {
            port: 80,
            defaultAction: elbv2.NetworkListenerAction.forward([group1, group2], {
                stickinessDuration: cdk.Duration.hours(1),
            }),
        });
        // THEN
        assert_1.expect(stack).to(assert_1.haveResource('AWS::ElasticLoadBalancingV2::Listener', {
            DefaultActions: [
                {
                    ForwardConfig: {
                        TargetGroupStickinessConfig: {
                            DurationSeconds: 3600,
                            Enabled: true,
                        },
                        TargetGroups: [
                            {
                                TargetGroupArn: { Ref: 'TargetGroup1E5480F51' },
                            },
                            {
                                TargetGroupArn: { Ref: 'TargetGroup2D571E5D7' },
                            },
                        ],
                    },
                    Type: 'forward',
                },
            ],
        }));
        test.done();
    },
    'Weighted forward to multiple targetgroups with an Action'(test) {
        // WHEN
        lb.addListener('Listener', {
            port: 80,
            defaultAction: elbv2.NetworkListenerAction.weightedForward([
                { targetGroup: group1, weight: 10 },
                { targetGroup: group2, weight: 50 },
            ], {
                stickinessDuration: cdk.Duration.hours(1),
            }),
        });
        // THEN
        assert_1.expect(stack).to(assert_1.haveResource('AWS::ElasticLoadBalancingV2::Listener', {
            DefaultActions: [
                {
                    ForwardConfig: {
                        TargetGroupStickinessConfig: {
                            DurationSeconds: 3600,
                            Enabled: true,
                        },
                        TargetGroups: [
                            {
                                TargetGroupArn: { Ref: 'TargetGroup1E5480F51' },
                                Weight: 10,
                            },
                            {
                                TargetGroupArn: { Ref: 'TargetGroup2D571E5D7' },
                                Weight: 50,
                            },
                        ],
                    },
                    Type: 'forward',
                },
            ],
        }));
        test.done();
    },
};
//# sourceMappingURL=data:application/json;base64,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