# coding: utf-8

"""
    Lidarr

    Lidarr API docs  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel
from lidarr.models.medium_resource import MediumResource

class AlbumReleaseResource(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    id: Optional[int]
    album_id: Optional[int]
    foreign_release_id: Optional[str]
    title: Optional[str]
    status: Optional[str]
    duration: Optional[int]
    track_count: Optional[int]
    media: Optional[List]
    medium_count: Optional[int]
    disambiguation: Optional[str]
    country: Optional[List]
    label: Optional[List]
    format: Optional[str]
    monitored: Optional[bool]
    __properties = ["id", "albumId", "foreignReleaseId", "title", "status", "duration", "trackCount", "media", "mediumCount", "disambiguation", "country", "label", "format", "monitored"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True
        alias_generator = lambda x: x.split("_")[0] + "".join(word.capitalize() for word in x.split("_")[1:])

    def __getitem__(self, item):
        return getattr(self, item)

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AlbumReleaseResource:
        """Create an instance of AlbumReleaseResource from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                            "medium_count",
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in media (list)
        _items = []
        if self.media:
            for _item in self.media:
                if _item:
                    _items.append(_item.to_dict())
            _dict['media'] = _items
        # set to None if foreign_release_id (nullable) is None
        if self.foreign_release_id is None:
            _dict['foreignReleaseId'] = None

        # set to None if title (nullable) is None
        if self.title is None:
            _dict['title'] = None

        # set to None if status (nullable) is None
        if self.status is None:
            _dict['status'] = None

        # set to None if media (nullable) is None
        if self.media is None:
            _dict['media'] = None

        # set to None if disambiguation (nullable) is None
        if self.disambiguation is None:
            _dict['disambiguation'] = None

        # set to None if country (nullable) is None
        if self.country is None:
            _dict['country'] = None

        # set to None if label (nullable) is None
        if self.label is None:
            _dict['label'] = None

        # set to None if format (nullable) is None
        if self.format is None:
            _dict['format'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> AlbumReleaseResource:
        """Create an instance of AlbumReleaseResource from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return AlbumReleaseResource.parse_obj(obj)

        _obj = AlbumReleaseResource.parse_obj({
            "id": obj.get("id"),
            "album_id": obj.get("albumId"),
            "foreign_release_id": obj.get("foreignReleaseId"),
            "title": obj.get("title"),
            "status": obj.get("status"),
            "duration": obj.get("duration"),
            "track_count": obj.get("trackCount"),
            "media": [MediumResource.from_dict(_item) for _item in obj.get("media")] if obj.get("media") is not None else None,
            "medium_count": obj.get("mediumCount"),
            "disambiguation": obj.get("disambiguation"),
            "country": obj.get("country"),
            "label": obj.get("label"),
            "format": obj.get("format"),
            "monitored": obj.get("monitored")
        })
        return _obj

