# coding: utf-8

"""
    Lidarr

    Lidarr API docs  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel
from lidarr.models.artist_status_type import ArtistStatusType
from lidarr.models.links import Links
from lidarr.models.media_cover import MediaCover
from lidarr.models.member import Member
from lidarr.models.ratings import Ratings

class ArtistMetadata(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    id: Optional[int]
    foreign_artist_id: Optional[str]
    old_foreign_artist_ids: Optional[List]
    name: Optional[str]
    aliases: Optional[List]
    overview: Optional[str]
    disambiguation: Optional[str]
    type: Optional[str]
    status: Optional[ArtistStatusType]
    images: Optional[List]
    links: Optional[List]
    genres: Optional[List]
    ratings: Optional[Ratings]
    members: Optional[List]
    __properties = ["id", "foreignArtistId", "oldForeignArtistIds", "name", "aliases", "overview", "disambiguation", "type", "status", "images", "links", "genres", "ratings", "members"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True
        alias_generator = lambda x: x.split("_")[0] + "".join(word.capitalize() for word in x.split("_")[1:])

    def __getitem__(self, item):
        return getattr(self, item)

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ArtistMetadata:
        """Create an instance of ArtistMetadata from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in images (list)
        _items = []
        if self.images:
            for _item in self.images:
                if _item:
                    _items.append(_item.to_dict())
            _dict['images'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in links (list)
        _items = []
        if self.links:
            for _item in self.links:
                if _item:
                    _items.append(_item.to_dict())
            _dict['links'] = _items
        # override the default output from pydantic by calling `to_dict()` of ratings
        if self.ratings:
            _dict['ratings'] = self.ratings.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in members (list)
        _items = []
        if self.members:
            for _item in self.members:
                if _item:
                    _items.append(_item.to_dict())
            _dict['members'] = _items
        # set to None if foreign_artist_id (nullable) is None
        if self.foreign_artist_id is None:
            _dict['foreignArtistId'] = None

        # set to None if old_foreign_artist_ids (nullable) is None
        if self.old_foreign_artist_ids is None:
            _dict['oldForeignArtistIds'] = None

        # set to None if name (nullable) is None
        if self.name is None:
            _dict['name'] = None

        # set to None if aliases (nullable) is None
        if self.aliases is None:
            _dict['aliases'] = None

        # set to None if overview (nullable) is None
        if self.overview is None:
            _dict['overview'] = None

        # set to None if disambiguation (nullable) is None
        if self.disambiguation is None:
            _dict['disambiguation'] = None

        # set to None if type (nullable) is None
        if self.type is None:
            _dict['type'] = None

        # set to None if images (nullable) is None
        if self.images is None:
            _dict['images'] = None

        # set to None if links (nullable) is None
        if self.links is None:
            _dict['links'] = None

        # set to None if genres (nullable) is None
        if self.genres is None:
            _dict['genres'] = None

        # set to None if members (nullable) is None
        if self.members is None:
            _dict['members'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ArtistMetadata:
        """Create an instance of ArtistMetadata from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return ArtistMetadata.parse_obj(obj)

        _obj = ArtistMetadata.parse_obj({
            "id": obj.get("id"),
            "foreign_artist_id": obj.get("foreignArtistId"),
            "old_foreign_artist_ids": obj.get("oldForeignArtistIds"),
            "name": obj.get("name"),
            "aliases": obj.get("aliases"),
            "overview": obj.get("overview"),
            "disambiguation": obj.get("disambiguation"),
            "type": obj.get("type"),
            "status": obj.get("status"),
            "images": [MediaCover.from_dict(_item) for _item in obj.get("images")] if obj.get("images") is not None else None,
            "links": [Links.from_dict(_item) for _item in obj.get("links")] if obj.get("links") is not None else None,
            "genres": obj.get("genres"),
            "ratings": Ratings.from_dict(obj.get("ratings")) if obj.get("ratings") is not None else None,
            "members": [Member.from_dict(_item) for _item in obj.get("members")] if obj.get("members") is not None else None
        })
        return _obj

