# coding: utf-8

"""
    Lidarr

    Lidarr API docs  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import List, Optional
from pydantic import BaseModel
from lidarr.models.add_artist_options import AddArtistOptions
from lidarr.models.album import Album
from lidarr.models.artist_statistics_resource import ArtistStatisticsResource
from lidarr.models.artist_status_type import ArtistStatusType
from lidarr.models.links import Links
from lidarr.models.media_cover import MediaCover
from lidarr.models.member import Member
from lidarr.models.new_item_monitor_types import NewItemMonitorTypes
from lidarr.models.ratings import Ratings

class ArtistResource(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    id: Optional[int]
    artist_metadata_id: Optional[int]
    status: Optional[ArtistStatusType]
    ended: Optional[bool]
    artist_name: Optional[str]
    foreign_artist_id: Optional[str]
    mb_id: Optional[str]
    tadb_id: Optional[int]
    discogs_id: Optional[int]
    all_music_id: Optional[str]
    overview: Optional[str]
    artist_type: Optional[str]
    disambiguation: Optional[str]
    links: Optional[List]
    next_album: Optional[Album]
    last_album: Optional[Album]
    images: Optional[List]
    members: Optional[List]
    remote_poster: Optional[str]
    path: Optional[str]
    quality_profile_id: Optional[int]
    metadata_profile_id: Optional[int]
    monitored: Optional[bool]
    monitor_new_items: Optional[NewItemMonitorTypes]
    root_folder_path: Optional[str]
    genres: Optional[List]
    clean_name: Optional[str]
    sort_name: Optional[str]
    tags: Optional[List]
    added: Optional[datetime]
    add_options: Optional[AddArtistOptions]
    ratings: Optional[Ratings]
    statistics: Optional[ArtistStatisticsResource]
    __properties = ["id", "artistMetadataId", "status", "ended", "artistName", "foreignArtistId", "mbId", "tadbId", "discogsId", "allMusicId", "overview", "artistType", "disambiguation", "links", "nextAlbum", "lastAlbum", "images", "members", "remotePoster", "path", "qualityProfileId", "metadataProfileId", "monitored", "monitorNewItems", "rootFolderPath", "genres", "cleanName", "sortName", "tags", "added", "addOptions", "ratings", "statistics"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True
        alias_generator = lambda x: x.split("_")[0] + "".join(word.capitalize() for word in x.split("_")[1:])

    def __getitem__(self, item):
        return getattr(self, item)

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ArtistResource:
        """Create an instance of ArtistResource from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                            "ended",
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in links (list)
        _items = []
        if self.links:
            for _item in self.links:
                if _item:
                    _items.append(_item.to_dict())
            _dict['links'] = _items
        # override the default output from pydantic by calling `to_dict()` of next_album
        if self.next_album:
            _dict['nextAlbum'] = self.next_album.to_dict()
        # override the default output from pydantic by calling `to_dict()` of last_album
        if self.last_album:
            _dict['lastAlbum'] = self.last_album.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in images (list)
        _items = []
        if self.images:
            for _item in self.images:
                if _item:
                    _items.append(_item.to_dict())
            _dict['images'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in members (list)
        _items = []
        if self.members:
            for _item in self.members:
                if _item:
                    _items.append(_item.to_dict())
            _dict['members'] = _items
        # override the default output from pydantic by calling `to_dict()` of add_options
        if self.add_options:
            _dict['addOptions'] = self.add_options.to_dict()
        # override the default output from pydantic by calling `to_dict()` of ratings
        if self.ratings:
            _dict['ratings'] = self.ratings.to_dict()
        # override the default output from pydantic by calling `to_dict()` of statistics
        if self.statistics:
            _dict['statistics'] = self.statistics.to_dict()
        # set to None if artist_name (nullable) is None
        if self.artist_name is None:
            _dict['artistName'] = None

        # set to None if foreign_artist_id (nullable) is None
        if self.foreign_artist_id is None:
            _dict['foreignArtistId'] = None

        # set to None if mb_id (nullable) is None
        if self.mb_id is None:
            _dict['mbId'] = None

        # set to None if all_music_id (nullable) is None
        if self.all_music_id is None:
            _dict['allMusicId'] = None

        # set to None if overview (nullable) is None
        if self.overview is None:
            _dict['overview'] = None

        # set to None if artist_type (nullable) is None
        if self.artist_type is None:
            _dict['artistType'] = None

        # set to None if disambiguation (nullable) is None
        if self.disambiguation is None:
            _dict['disambiguation'] = None

        # set to None if links (nullable) is None
        if self.links is None:
            _dict['links'] = None

        # set to None if images (nullable) is None
        if self.images is None:
            _dict['images'] = None

        # set to None if members (nullable) is None
        if self.members is None:
            _dict['members'] = None

        # set to None if remote_poster (nullable) is None
        if self.remote_poster is None:
            _dict['remotePoster'] = None

        # set to None if path (nullable) is None
        if self.path is None:
            _dict['path'] = None

        # set to None if root_folder_path (nullable) is None
        if self.root_folder_path is None:
            _dict['rootFolderPath'] = None

        # set to None if genres (nullable) is None
        if self.genres is None:
            _dict['genres'] = None

        # set to None if clean_name (nullable) is None
        if self.clean_name is None:
            _dict['cleanName'] = None

        # set to None if sort_name (nullable) is None
        if self.sort_name is None:
            _dict['sortName'] = None

        # set to None if tags (nullable) is None
        if self.tags is None:
            _dict['tags'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ArtistResource:
        """Create an instance of ArtistResource from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return ArtistResource.parse_obj(obj)

        _obj = ArtistResource.parse_obj({
            "id": obj.get("id"),
            "artist_metadata_id": obj.get("artistMetadataId"),
            "status": obj.get("status"),
            "ended": obj.get("ended"),
            "artist_name": obj.get("artistName"),
            "foreign_artist_id": obj.get("foreignArtistId"),
            "mb_id": obj.get("mbId"),
            "tadb_id": obj.get("tadbId"),
            "discogs_id": obj.get("discogsId"),
            "all_music_id": obj.get("allMusicId"),
            "overview": obj.get("overview"),
            "artist_type": obj.get("artistType"),
            "disambiguation": obj.get("disambiguation"),
            "links": [Links.from_dict(_item) for _item in obj.get("links")] if obj.get("links") is not None else None,
            "next_album": Album.from_dict(obj.get("nextAlbum")) if obj.get("nextAlbum") is not None else None,
            "last_album": Album.from_dict(obj.get("lastAlbum")) if obj.get("lastAlbum") is not None else None,
            "images": [MediaCover.from_dict(_item) for _item in obj.get("images")] if obj.get("images") is not None else None,
            "members": [Member.from_dict(_item) for _item in obj.get("members")] if obj.get("members") is not None else None,
            "remote_poster": obj.get("remotePoster"),
            "path": obj.get("path"),
            "quality_profile_id": obj.get("qualityProfileId"),
            "metadata_profile_id": obj.get("metadataProfileId"),
            "monitored": obj.get("monitored"),
            "monitor_new_items": obj.get("monitorNewItems"),
            "root_folder_path": obj.get("rootFolderPath"),
            "genres": obj.get("genres"),
            "clean_name": obj.get("cleanName"),
            "sort_name": obj.get("sortName"),
            "tags": obj.get("tags"),
            "added": obj.get("added"),
            "add_options": AddArtistOptions.from_dict(obj.get("addOptions")) if obj.get("addOptions") is not None else None,
            "ratings": Ratings.from_dict(obj.get("ratings")) if obj.get("ratings") is not None else None,
            "statistics": ArtistStatisticsResource.from_dict(obj.get("statistics")) if obj.get("statistics") is not None else None
        })
        return _obj

