# -*- coding: utf-8 -*-
# Generated by Django 1.11.2 on 2018-11-30 19:38


from django.db import migrations


def add_keys(apps, schema_editor):
    '''
    We can't import the Post model directly as it may be a newer
    version than this migration expects. We use the historical version.
    '''
    Setting = apps.get_model('settings', 'Setting')

    key = ''
    try:
        key = 'APARNIK_BON_VALUE'
        Setting.objects.get(key=key)
    except Exception:
        Setting.objects.create(
            title='ارزش تومانی هر بن',
            key=key,
            value='100',
            value_type='i',
            is_show=True,
            is_variable_in_home=True,
        )

    try:
        key = 'APARNIK_BON_RETURN_DEFAULT_VALUE'
        Setting.objects.get(key=key)
    except Exception:
        Setting.objects.create(
            title='مقدار بن پیش فرضی برای هر محصول پس از خرید که به کاربر باز گردانده می شود. ',
            key=key,
            value='0',
            value_type='i',
            is_show=True,
            is_variable_in_home=False,
        )

    try:
        key = 'APARNIK_BON_RETURN_DEFAULT_EXPIRE_VALUE'
        Setting.objects.get(key=key)
    except Exception:
        Setting.objects.create(
            title='کاربر تا چه زمانی می تواند از بن بدست آمده از خرید یک محصول استفاده کند. عدد ۰ به معنای عدم محدودیت است. واحد ساعت است.',
            key=key,
            value='0',
            value_type='i',
            is_show=True,
            is_variable_in_home=False,
        )

    try:
        key = 'MAXIMUM_USE_APARNIK_BON'
        Setting.objects.get(key=key)
    except Exception:
        Setting.objects.create(
            title='مقدار پیش فرض استفاده بن برای خرید هر کالا',
            key=key,
            value='-2',
            value_type='i',
            is_show=True,
            is_variable_in_home=False,
        )

    try:
        key = 'HAS_PERMIT_DEFAULT_USE_WALLET'
        Setting.objects.get(key=key)
    except Exception:
        Setting.objects.create(
            title='مقدار پیش فرض اجازه پرداخت با کیف پول در هر کالا',
            key=key,
            value='True',
            value_type='b',
            is_show=True,
            is_variable_in_home=False,
        )

    key = 'INVITER_GIFT_CREDITS'
    inviter_gift_credits = Setting.objects.get(key=key)
    inviter_gift_credits.key = 'INVITER_GIFT_BON_CREDITS'
    inviter_gift_credits.title = 'مبلغ هدیه برای دعوت کننده در بدو قبول دعوت'
    inviter_gift_credits.save()


    key = 'INVITED_GIFT_CREDITS'
    invited_gift_credits = Setting.objects.get(key=key)
    invited_gift_credits.key = 'INVITED_GIFT_BON_CREDITS'
    invited_gift_credits.title = 'مبلغ هدیه برای دعوت شونده در بدو قبول دعوت'
    invited_gift_credits.save()


class Migration(migrations.Migration):

    dependencies = [
        ('settings', '0004_auto_20181130_1658'),
    ]

    operations = [
        migrations.RunPython(add_keys, reverse_code=migrations.RunPython.noop),
    ]
