'''
# `mongodbatlas_encryption_at_rest`

Refer to the Terraform Registory for docs: [`mongodbatlas_encryption_at_rest`](https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest).
'''
import abc
import builtins
import datetime
import enum
import typing

import jsii
import publication
import typing_extensions

from typeguard import check_type

from .._jsii import *

import cdktf as _cdktf_9a9027ec
import constructs as _constructs_77d1e7e8


class EncryptionAtRest(
    _cdktf_9a9027ec.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-mongodbatlas.encryptionAtRest.EncryptionAtRest",
):
    '''Represents a {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest mongodbatlas_encryption_at_rest}.'''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id_: builtins.str,
        *,
        project_id: builtins.str,
        aws_kms: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        aws_kms_config: typing.Optional[typing.Union["EncryptionAtRestAwsKmsConfig", typing.Dict[builtins.str, typing.Any]]] = None,
        azure_key_vault: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        azure_key_vault_config: typing.Optional[typing.Union["EncryptionAtRestAzureKeyVaultConfig", typing.Dict[builtins.str, typing.Any]]] = None,
        google_cloud_kms: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        google_cloud_kms_config: typing.Optional[typing.Union["EncryptionAtRestGoogleCloudKmsConfig", typing.Dict[builtins.str, typing.Any]]] = None,
        id: typing.Optional[builtins.str] = None,
        connection: typing.Optional[typing.Union[typing.Union[_cdktf_9a9027ec.SSHProvisionerConnection, typing.Dict[builtins.str, typing.Any]], typing.Union[_cdktf_9a9027ec.WinrmProvisionerConnection, typing.Dict[builtins.str, typing.Any]]]] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.Sequence[_cdktf_9a9027ec.ITerraformDependable]] = None,
        for_each: typing.Optional[_cdktf_9a9027ec.ITerraformIterator] = None,
        lifecycle: typing.Optional[typing.Union[_cdktf_9a9027ec.TerraformResourceLifecycle, typing.Dict[builtins.str, typing.Any]]] = None,
        provider: typing.Optional[_cdktf_9a9027ec.TerraformProvider] = None,
        provisioners: typing.Optional[typing.Sequence[typing.Union[typing.Union[_cdktf_9a9027ec.FileProvisioner, typing.Dict[builtins.str, typing.Any]], typing.Union[_cdktf_9a9027ec.LocalExecProvisioner, typing.Dict[builtins.str, typing.Any]], typing.Union[_cdktf_9a9027ec.RemoteExecProvisioner, typing.Dict[builtins.str, typing.Any]]]]] = None,
    ) -> None:
        '''Create a new {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest mongodbatlas_encryption_at_rest} Resource.

        :param scope: The scope in which to define this construct.
        :param id_: The scoped construct ID. Must be unique amongst siblings in the same scope
        :param project_id: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#project_id EncryptionAtRest#project_id}.
        :param aws_kms: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#aws_kms EncryptionAtRest#aws_kms}.
        :param aws_kms_config: aws_kms_config block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#aws_kms_config EncryptionAtRest#aws_kms_config}
        :param azure_key_vault: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#azure_key_vault EncryptionAtRest#azure_key_vault}.
        :param azure_key_vault_config: azure_key_vault_config block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#azure_key_vault_config EncryptionAtRest#azure_key_vault_config}
        :param google_cloud_kms: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#google_cloud_kms EncryptionAtRest#google_cloud_kms}.
        :param google_cloud_kms_config: google_cloud_kms_config block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#google_cloud_kms_config EncryptionAtRest#google_cloud_kms_config}
        :param id: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#id EncryptionAtRest#id}. Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2. If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
        :param connection: 
        :param count: 
        :param depends_on: 
        :param for_each: 
        :param lifecycle: 
        :param provider: 
        :param provisioners: 
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b8a749241b9925e4e5575c33df78a5f4c547da582518cff88d990656dedbacb8)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id_", value=id_, expected_type=type_hints["id_"])
        config = EncryptionAtRestConfig(
            project_id=project_id,
            aws_kms=aws_kms,
            aws_kms_config=aws_kms_config,
            azure_key_vault=azure_key_vault,
            azure_key_vault_config=azure_key_vault_config,
            google_cloud_kms=google_cloud_kms,
            google_cloud_kms_config=google_cloud_kms_config,
            id=id,
            connection=connection,
            count=count,
            depends_on=depends_on,
            for_each=for_each,
            lifecycle=lifecycle,
            provider=provider,
            provisioners=provisioners,
        )

        jsii.create(self.__class__, self, [scope, id_, config])

    @jsii.member(jsii_name="putAwsKmsConfig")
    def put_aws_kms_config(
        self,
        *,
        access_key_id: typing.Optional[builtins.str] = None,
        customer_master_key_id: typing.Optional[builtins.str] = None,
        enabled: typing.Optional[typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable]] = None,
        region: typing.Optional[builtins.str] = None,
        role_id: typing.Optional[builtins.str] = None,
        secret_access_key: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param access_key_id: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#access_key_id EncryptionAtRest#access_key_id}.
        :param customer_master_key_id: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#customer_master_key_id EncryptionAtRest#customer_master_key_id}.
        :param enabled: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#enabled EncryptionAtRest#enabled}.
        :param region: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#region EncryptionAtRest#region}.
        :param role_id: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#role_id EncryptionAtRest#role_id}.
        :param secret_access_key: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#secret_access_key EncryptionAtRest#secret_access_key}.
        '''
        value = EncryptionAtRestAwsKmsConfig(
            access_key_id=access_key_id,
            customer_master_key_id=customer_master_key_id,
            enabled=enabled,
            region=region,
            role_id=role_id,
            secret_access_key=secret_access_key,
        )

        return typing.cast(None, jsii.invoke(self, "putAwsKmsConfig", [value]))

    @jsii.member(jsii_name="putAzureKeyVaultConfig")
    def put_azure_key_vault_config(
        self,
        *,
        enabled: typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable],
        azure_environment: typing.Optional[builtins.str] = None,
        client_id: typing.Optional[builtins.str] = None,
        key_identifier: typing.Optional[builtins.str] = None,
        key_vault_name: typing.Optional[builtins.str] = None,
        resource_group_name: typing.Optional[builtins.str] = None,
        secret: typing.Optional[builtins.str] = None,
        subscription_id: typing.Optional[builtins.str] = None,
        tenant_id: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param enabled: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#enabled EncryptionAtRest#enabled}.
        :param azure_environment: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#azure_environment EncryptionAtRest#azure_environment}.
        :param client_id: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#client_id EncryptionAtRest#client_id}.
        :param key_identifier: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#key_identifier EncryptionAtRest#key_identifier}.
        :param key_vault_name: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#key_vault_name EncryptionAtRest#key_vault_name}.
        :param resource_group_name: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#resource_group_name EncryptionAtRest#resource_group_name}.
        :param secret: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#secret EncryptionAtRest#secret}.
        :param subscription_id: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#subscription_id EncryptionAtRest#subscription_id}.
        :param tenant_id: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#tenant_id EncryptionAtRest#tenant_id}.
        '''
        value = EncryptionAtRestAzureKeyVaultConfig(
            enabled=enabled,
            azure_environment=azure_environment,
            client_id=client_id,
            key_identifier=key_identifier,
            key_vault_name=key_vault_name,
            resource_group_name=resource_group_name,
            secret=secret,
            subscription_id=subscription_id,
            tenant_id=tenant_id,
        )

        return typing.cast(None, jsii.invoke(self, "putAzureKeyVaultConfig", [value]))

    @jsii.member(jsii_name="putGoogleCloudKmsConfig")
    def put_google_cloud_kms_config(
        self,
        *,
        enabled: typing.Optional[typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable]] = None,
        key_version_resource_id: typing.Optional[builtins.str] = None,
        service_account_key: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param enabled: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#enabled EncryptionAtRest#enabled}.
        :param key_version_resource_id: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#key_version_resource_id EncryptionAtRest#key_version_resource_id}.
        :param service_account_key: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#service_account_key EncryptionAtRest#service_account_key}.
        '''
        value = EncryptionAtRestGoogleCloudKmsConfig(
            enabled=enabled,
            key_version_resource_id=key_version_resource_id,
            service_account_key=service_account_key,
        )

        return typing.cast(None, jsii.invoke(self, "putGoogleCloudKmsConfig", [value]))

    @jsii.member(jsii_name="resetAwsKms")
    def reset_aws_kms(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetAwsKms", []))

    @jsii.member(jsii_name="resetAwsKmsConfig")
    def reset_aws_kms_config(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetAwsKmsConfig", []))

    @jsii.member(jsii_name="resetAzureKeyVault")
    def reset_azure_key_vault(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetAzureKeyVault", []))

    @jsii.member(jsii_name="resetAzureKeyVaultConfig")
    def reset_azure_key_vault_config(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetAzureKeyVaultConfig", []))

    @jsii.member(jsii_name="resetGoogleCloudKms")
    def reset_google_cloud_kms(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetGoogleCloudKms", []))

    @jsii.member(jsii_name="resetGoogleCloudKmsConfig")
    def reset_google_cloud_kms_config(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetGoogleCloudKmsConfig", []))

    @jsii.member(jsii_name="resetId")
    def reset_id(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetId", []))

    @jsii.member(jsii_name="synthesizeAttributes")
    def _synthesize_attributes(self) -> typing.Mapping[builtins.str, typing.Any]:
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "synthesizeAttributes", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="tfResourceType")
    def TF_RESOURCE_TYPE(cls) -> builtins.str:
        return typing.cast(builtins.str, jsii.sget(cls, "tfResourceType"))

    @builtins.property
    @jsii.member(jsii_name="awsKmsConfig")
    def aws_kms_config(self) -> "EncryptionAtRestAwsKmsConfigOutputReference":
        return typing.cast("EncryptionAtRestAwsKmsConfigOutputReference", jsii.get(self, "awsKmsConfig"))

    @builtins.property
    @jsii.member(jsii_name="azureKeyVaultConfig")
    def azure_key_vault_config(
        self,
    ) -> "EncryptionAtRestAzureKeyVaultConfigOutputReference":
        return typing.cast("EncryptionAtRestAzureKeyVaultConfigOutputReference", jsii.get(self, "azureKeyVaultConfig"))

    @builtins.property
    @jsii.member(jsii_name="googleCloudKmsConfig")
    def google_cloud_kms_config(
        self,
    ) -> "EncryptionAtRestGoogleCloudKmsConfigOutputReference":
        return typing.cast("EncryptionAtRestGoogleCloudKmsConfigOutputReference", jsii.get(self, "googleCloudKmsConfig"))

    @builtins.property
    @jsii.member(jsii_name="awsKmsConfigInput")
    def aws_kms_config_input(self) -> typing.Optional["EncryptionAtRestAwsKmsConfig"]:
        return typing.cast(typing.Optional["EncryptionAtRestAwsKmsConfig"], jsii.get(self, "awsKmsConfigInput"))

    @builtins.property
    @jsii.member(jsii_name="awsKmsInput")
    def aws_kms_input(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, builtins.str]], jsii.get(self, "awsKmsInput"))

    @builtins.property
    @jsii.member(jsii_name="azureKeyVaultConfigInput")
    def azure_key_vault_config_input(
        self,
    ) -> typing.Optional["EncryptionAtRestAzureKeyVaultConfig"]:
        return typing.cast(typing.Optional["EncryptionAtRestAzureKeyVaultConfig"], jsii.get(self, "azureKeyVaultConfigInput"))

    @builtins.property
    @jsii.member(jsii_name="azureKeyVaultInput")
    def azure_key_vault_input(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, builtins.str]], jsii.get(self, "azureKeyVaultInput"))

    @builtins.property
    @jsii.member(jsii_name="googleCloudKmsConfigInput")
    def google_cloud_kms_config_input(
        self,
    ) -> typing.Optional["EncryptionAtRestGoogleCloudKmsConfig"]:
        return typing.cast(typing.Optional["EncryptionAtRestGoogleCloudKmsConfig"], jsii.get(self, "googleCloudKmsConfigInput"))

    @builtins.property
    @jsii.member(jsii_name="googleCloudKmsInput")
    def google_cloud_kms_input(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, builtins.str]], jsii.get(self, "googleCloudKmsInput"))

    @builtins.property
    @jsii.member(jsii_name="idInput")
    def id_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "idInput"))

    @builtins.property
    @jsii.member(jsii_name="projectIdInput")
    def project_id_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "projectIdInput"))

    @builtins.property
    @jsii.member(jsii_name="awsKms")
    def aws_kms(self) -> typing.Mapping[builtins.str, builtins.str]:
        return typing.cast(typing.Mapping[builtins.str, builtins.str], jsii.get(self, "awsKms"))

    @aws_kms.setter
    def aws_kms(self, value: typing.Mapping[builtins.str, builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d625ab972abc671bf7777204ba5006fecaf1aa5a38f4cf36717ec3785939d2f2)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "awsKms", value)

    @builtins.property
    @jsii.member(jsii_name="azureKeyVault")
    def azure_key_vault(self) -> typing.Mapping[builtins.str, builtins.str]:
        return typing.cast(typing.Mapping[builtins.str, builtins.str], jsii.get(self, "azureKeyVault"))

    @azure_key_vault.setter
    def azure_key_vault(
        self,
        value: typing.Mapping[builtins.str, builtins.str],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__422e2c00b6be559b033687e5e17d7062e8c159959c0f86e0ccc13fba6283d714)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "azureKeyVault", value)

    @builtins.property
    @jsii.member(jsii_name="googleCloudKms")
    def google_cloud_kms(self) -> typing.Mapping[builtins.str, builtins.str]:
        return typing.cast(typing.Mapping[builtins.str, builtins.str], jsii.get(self, "googleCloudKms"))

    @google_cloud_kms.setter
    def google_cloud_kms(
        self,
        value: typing.Mapping[builtins.str, builtins.str],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d5dc984bdab637cd0715cb9b493da8e29eb3ca6b3dbfb81db51efa9b6aabed9b)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "googleCloudKms", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "id"))

    @id.setter
    def id(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__27277a75d95c364c5b70c731815b7acb3211a7b0c4171957c6427cce25a6e9f1)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="projectId")
    def project_id(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "projectId"))

    @project_id.setter
    def project_id(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9439e0e2caad1419ef55c3bce2d0e9762828a700c38e7fc4c0c6df694a3d7f9c)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "projectId", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-mongodbatlas.encryptionAtRest.EncryptionAtRestAwsKmsConfig",
    jsii_struct_bases=[],
    name_mapping={
        "access_key_id": "accessKeyId",
        "customer_master_key_id": "customerMasterKeyId",
        "enabled": "enabled",
        "region": "region",
        "role_id": "roleId",
        "secret_access_key": "secretAccessKey",
    },
)
class EncryptionAtRestAwsKmsConfig:
    def __init__(
        self,
        *,
        access_key_id: typing.Optional[builtins.str] = None,
        customer_master_key_id: typing.Optional[builtins.str] = None,
        enabled: typing.Optional[typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable]] = None,
        region: typing.Optional[builtins.str] = None,
        role_id: typing.Optional[builtins.str] = None,
        secret_access_key: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param access_key_id: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#access_key_id EncryptionAtRest#access_key_id}.
        :param customer_master_key_id: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#customer_master_key_id EncryptionAtRest#customer_master_key_id}.
        :param enabled: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#enabled EncryptionAtRest#enabled}.
        :param region: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#region EncryptionAtRest#region}.
        :param role_id: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#role_id EncryptionAtRest#role_id}.
        :param secret_access_key: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#secret_access_key EncryptionAtRest#secret_access_key}.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1dd6569dc4b956383c6698bba19ed570923e21ab1bcc7247a726669fa55ccaa1)
            check_type(argname="argument access_key_id", value=access_key_id, expected_type=type_hints["access_key_id"])
            check_type(argname="argument customer_master_key_id", value=customer_master_key_id, expected_type=type_hints["customer_master_key_id"])
            check_type(argname="argument enabled", value=enabled, expected_type=type_hints["enabled"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument role_id", value=role_id, expected_type=type_hints["role_id"])
            check_type(argname="argument secret_access_key", value=secret_access_key, expected_type=type_hints["secret_access_key"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if access_key_id is not None:
            self._values["access_key_id"] = access_key_id
        if customer_master_key_id is not None:
            self._values["customer_master_key_id"] = customer_master_key_id
        if enabled is not None:
            self._values["enabled"] = enabled
        if region is not None:
            self._values["region"] = region
        if role_id is not None:
            self._values["role_id"] = role_id
        if secret_access_key is not None:
            self._values["secret_access_key"] = secret_access_key

    @builtins.property
    def access_key_id(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#access_key_id EncryptionAtRest#access_key_id}.'''
        result = self._values.get("access_key_id")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def customer_master_key_id(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#customer_master_key_id EncryptionAtRest#customer_master_key_id}.'''
        result = self._values.get("customer_master_key_id")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def enabled(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable]]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#enabled EncryptionAtRest#enabled}.'''
        result = self._values.get("enabled")
        return typing.cast(typing.Optional[typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable]], result)

    @builtins.property
    def region(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#region EncryptionAtRest#region}.'''
        result = self._values.get("region")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def role_id(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#role_id EncryptionAtRest#role_id}.'''
        result = self._values.get("role_id")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def secret_access_key(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#secret_access_key EncryptionAtRest#secret_access_key}.'''
        result = self._values.get("secret_access_key")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "EncryptionAtRestAwsKmsConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class EncryptionAtRestAwsKmsConfigOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-mongodbatlas.encryptionAtRest.EncryptionAtRestAwsKmsConfigOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__58d2d3a567c0bf664f2b33d6fad122cea199f1c4af389e2ced9e5038115d59e5)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @jsii.member(jsii_name="resetAccessKeyId")
    def reset_access_key_id(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetAccessKeyId", []))

    @jsii.member(jsii_name="resetCustomerMasterKeyId")
    def reset_customer_master_key_id(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetCustomerMasterKeyId", []))

    @jsii.member(jsii_name="resetEnabled")
    def reset_enabled(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetEnabled", []))

    @jsii.member(jsii_name="resetRegion")
    def reset_region(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetRegion", []))

    @jsii.member(jsii_name="resetRoleId")
    def reset_role_id(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetRoleId", []))

    @jsii.member(jsii_name="resetSecretAccessKey")
    def reset_secret_access_key(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetSecretAccessKey", []))

    @builtins.property
    @jsii.member(jsii_name="accessKeyIdInput")
    def access_key_id_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "accessKeyIdInput"))

    @builtins.property
    @jsii.member(jsii_name="customerMasterKeyIdInput")
    def customer_master_key_id_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "customerMasterKeyIdInput"))

    @builtins.property
    @jsii.member(jsii_name="enabledInput")
    def enabled_input(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable]]:
        return typing.cast(typing.Optional[typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable]], jsii.get(self, "enabledInput"))

    @builtins.property
    @jsii.member(jsii_name="regionInput")
    def region_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "regionInput"))

    @builtins.property
    @jsii.member(jsii_name="roleIdInput")
    def role_id_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "roleIdInput"))

    @builtins.property
    @jsii.member(jsii_name="secretAccessKeyInput")
    def secret_access_key_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "secretAccessKeyInput"))

    @builtins.property
    @jsii.member(jsii_name="accessKeyId")
    def access_key_id(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "accessKeyId"))

    @access_key_id.setter
    def access_key_id(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f51b399a6b218c7cfaeda67a1bfe310fbffe2656af726f28bb6fd28a95df29c0)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "accessKeyId", value)

    @builtins.property
    @jsii.member(jsii_name="customerMasterKeyId")
    def customer_master_key_id(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "customerMasterKeyId"))

    @customer_master_key_id.setter
    def customer_master_key_id(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4361390b0e55e1cfd4f404c68d2fe4d747847ff2b16fd45d24d959a0abca2c9a)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "customerMasterKeyId", value)

    @builtins.property
    @jsii.member(jsii_name="enabled")
    def enabled(self) -> typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable]:
        return typing.cast(typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable], jsii.get(self, "enabled"))

    @enabled.setter
    def enabled(
        self,
        value: typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__eb2e8075f14e443d096f05767a14288428c6d1f96c44b927d083871cb521f851)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "enabled", value)

    @builtins.property
    @jsii.member(jsii_name="region")
    def region(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "region"))

    @region.setter
    def region(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ef4c80bc4747c81dba5c780f7c052b1dac12f90d2c983d89f17e1f0197cb6fcb)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "region", value)

    @builtins.property
    @jsii.member(jsii_name="roleId")
    def role_id(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "roleId"))

    @role_id.setter
    def role_id(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__55081dbc7a44d12c1a56eb8949356b1da8be074cf5a8ff28b995922027d106f1)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "roleId", value)

    @builtins.property
    @jsii.member(jsii_name="secretAccessKey")
    def secret_access_key(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "secretAccessKey"))

    @secret_access_key.setter
    def secret_access_key(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__12b709f63a750640efb8dbb285fc46e321a400ce0739ab0f311b94519db83ea0)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "secretAccessKey", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(self) -> typing.Optional[EncryptionAtRestAwsKmsConfig]:
        return typing.cast(typing.Optional[EncryptionAtRestAwsKmsConfig], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[EncryptionAtRestAwsKmsConfig],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2837550a221a143ba84f9f8051c03a38e6cdc75bf63b452e090b383c89e59814)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-mongodbatlas.encryptionAtRest.EncryptionAtRestAzureKeyVaultConfig",
    jsii_struct_bases=[],
    name_mapping={
        "enabled": "enabled",
        "azure_environment": "azureEnvironment",
        "client_id": "clientId",
        "key_identifier": "keyIdentifier",
        "key_vault_name": "keyVaultName",
        "resource_group_name": "resourceGroupName",
        "secret": "secret",
        "subscription_id": "subscriptionId",
        "tenant_id": "tenantId",
    },
)
class EncryptionAtRestAzureKeyVaultConfig:
    def __init__(
        self,
        *,
        enabled: typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable],
        azure_environment: typing.Optional[builtins.str] = None,
        client_id: typing.Optional[builtins.str] = None,
        key_identifier: typing.Optional[builtins.str] = None,
        key_vault_name: typing.Optional[builtins.str] = None,
        resource_group_name: typing.Optional[builtins.str] = None,
        secret: typing.Optional[builtins.str] = None,
        subscription_id: typing.Optional[builtins.str] = None,
        tenant_id: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param enabled: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#enabled EncryptionAtRest#enabled}.
        :param azure_environment: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#azure_environment EncryptionAtRest#azure_environment}.
        :param client_id: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#client_id EncryptionAtRest#client_id}.
        :param key_identifier: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#key_identifier EncryptionAtRest#key_identifier}.
        :param key_vault_name: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#key_vault_name EncryptionAtRest#key_vault_name}.
        :param resource_group_name: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#resource_group_name EncryptionAtRest#resource_group_name}.
        :param secret: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#secret EncryptionAtRest#secret}.
        :param subscription_id: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#subscription_id EncryptionAtRest#subscription_id}.
        :param tenant_id: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#tenant_id EncryptionAtRest#tenant_id}.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__af1862db25e54c77985632a2ac72a3a22ffc755c82b8d516e11b4c05257a8c22)
            check_type(argname="argument enabled", value=enabled, expected_type=type_hints["enabled"])
            check_type(argname="argument azure_environment", value=azure_environment, expected_type=type_hints["azure_environment"])
            check_type(argname="argument client_id", value=client_id, expected_type=type_hints["client_id"])
            check_type(argname="argument key_identifier", value=key_identifier, expected_type=type_hints["key_identifier"])
            check_type(argname="argument key_vault_name", value=key_vault_name, expected_type=type_hints["key_vault_name"])
            check_type(argname="argument resource_group_name", value=resource_group_name, expected_type=type_hints["resource_group_name"])
            check_type(argname="argument secret", value=secret, expected_type=type_hints["secret"])
            check_type(argname="argument subscription_id", value=subscription_id, expected_type=type_hints["subscription_id"])
            check_type(argname="argument tenant_id", value=tenant_id, expected_type=type_hints["tenant_id"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "enabled": enabled,
        }
        if azure_environment is not None:
            self._values["azure_environment"] = azure_environment
        if client_id is not None:
            self._values["client_id"] = client_id
        if key_identifier is not None:
            self._values["key_identifier"] = key_identifier
        if key_vault_name is not None:
            self._values["key_vault_name"] = key_vault_name
        if resource_group_name is not None:
            self._values["resource_group_name"] = resource_group_name
        if secret is not None:
            self._values["secret"] = secret
        if subscription_id is not None:
            self._values["subscription_id"] = subscription_id
        if tenant_id is not None:
            self._values["tenant_id"] = tenant_id

    @builtins.property
    def enabled(self) -> typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#enabled EncryptionAtRest#enabled}.'''
        result = self._values.get("enabled")
        assert result is not None, "Required property 'enabled' is missing"
        return typing.cast(typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable], result)

    @builtins.property
    def azure_environment(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#azure_environment EncryptionAtRest#azure_environment}.'''
        result = self._values.get("azure_environment")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def client_id(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#client_id EncryptionAtRest#client_id}.'''
        result = self._values.get("client_id")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def key_identifier(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#key_identifier EncryptionAtRest#key_identifier}.'''
        result = self._values.get("key_identifier")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def key_vault_name(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#key_vault_name EncryptionAtRest#key_vault_name}.'''
        result = self._values.get("key_vault_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def resource_group_name(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#resource_group_name EncryptionAtRest#resource_group_name}.'''
        result = self._values.get("resource_group_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def secret(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#secret EncryptionAtRest#secret}.'''
        result = self._values.get("secret")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def subscription_id(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#subscription_id EncryptionAtRest#subscription_id}.'''
        result = self._values.get("subscription_id")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def tenant_id(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#tenant_id EncryptionAtRest#tenant_id}.'''
        result = self._values.get("tenant_id")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "EncryptionAtRestAzureKeyVaultConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class EncryptionAtRestAzureKeyVaultConfigOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-mongodbatlas.encryptionAtRest.EncryptionAtRestAzureKeyVaultConfigOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7cf936d70031c0e28dd3de0139428b13036a86d3a0a83edaf6d7843d6466149b)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @jsii.member(jsii_name="resetAzureEnvironment")
    def reset_azure_environment(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetAzureEnvironment", []))

    @jsii.member(jsii_name="resetClientId")
    def reset_client_id(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetClientId", []))

    @jsii.member(jsii_name="resetKeyIdentifier")
    def reset_key_identifier(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetKeyIdentifier", []))

    @jsii.member(jsii_name="resetKeyVaultName")
    def reset_key_vault_name(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetKeyVaultName", []))

    @jsii.member(jsii_name="resetResourceGroupName")
    def reset_resource_group_name(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetResourceGroupName", []))

    @jsii.member(jsii_name="resetSecret")
    def reset_secret(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetSecret", []))

    @jsii.member(jsii_name="resetSubscriptionId")
    def reset_subscription_id(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetSubscriptionId", []))

    @jsii.member(jsii_name="resetTenantId")
    def reset_tenant_id(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetTenantId", []))

    @builtins.property
    @jsii.member(jsii_name="azureEnvironmentInput")
    def azure_environment_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "azureEnvironmentInput"))

    @builtins.property
    @jsii.member(jsii_name="clientIdInput")
    def client_id_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "clientIdInput"))

    @builtins.property
    @jsii.member(jsii_name="enabledInput")
    def enabled_input(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable]]:
        return typing.cast(typing.Optional[typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable]], jsii.get(self, "enabledInput"))

    @builtins.property
    @jsii.member(jsii_name="keyIdentifierInput")
    def key_identifier_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "keyIdentifierInput"))

    @builtins.property
    @jsii.member(jsii_name="keyVaultNameInput")
    def key_vault_name_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "keyVaultNameInput"))

    @builtins.property
    @jsii.member(jsii_name="resourceGroupNameInput")
    def resource_group_name_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "resourceGroupNameInput"))

    @builtins.property
    @jsii.member(jsii_name="secretInput")
    def secret_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "secretInput"))

    @builtins.property
    @jsii.member(jsii_name="subscriptionIdInput")
    def subscription_id_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "subscriptionIdInput"))

    @builtins.property
    @jsii.member(jsii_name="tenantIdInput")
    def tenant_id_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "tenantIdInput"))

    @builtins.property
    @jsii.member(jsii_name="azureEnvironment")
    def azure_environment(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "azureEnvironment"))

    @azure_environment.setter
    def azure_environment(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8a5080be53a162314178eb3d5a5754dcdf9af36d5bbeb8a5d7f68acba1b4af2e)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "azureEnvironment", value)

    @builtins.property
    @jsii.member(jsii_name="clientId")
    def client_id(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "clientId"))

    @client_id.setter
    def client_id(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7ae7fda14c6d425af21fb6567e49233b21a590ccbf3d8fcf8b7e85a73d07ed20)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "clientId", value)

    @builtins.property
    @jsii.member(jsii_name="enabled")
    def enabled(self) -> typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable]:
        return typing.cast(typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable], jsii.get(self, "enabled"))

    @enabled.setter
    def enabled(
        self,
        value: typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e3645fc98a9ddbe83aa53926f7f7c8e634518f2c97af7ec68b934366e3d3d4e6)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "enabled", value)

    @builtins.property
    @jsii.member(jsii_name="keyIdentifier")
    def key_identifier(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "keyIdentifier"))

    @key_identifier.setter
    def key_identifier(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4db41b5d2b0af428972a4e9f72116499c0eecc581aef510b14e1f4f416428977)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "keyIdentifier", value)

    @builtins.property
    @jsii.member(jsii_name="keyVaultName")
    def key_vault_name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "keyVaultName"))

    @key_vault_name.setter
    def key_vault_name(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a7c134ac3f2fb59beced0dce92b78bfc1f797c12d48e6488f9e3c144fa1f703a)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "keyVaultName", value)

    @builtins.property
    @jsii.member(jsii_name="resourceGroupName")
    def resource_group_name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "resourceGroupName"))

    @resource_group_name.setter
    def resource_group_name(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__48748e519eea9ea85d698ac8f416d359ab2181ce066b5f34a58f177d2e5bcd32)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "resourceGroupName", value)

    @builtins.property
    @jsii.member(jsii_name="secret")
    def secret(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "secret"))

    @secret.setter
    def secret(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__315e7d884e7ee505be7de1fc076a66df982f3ef2ee62a2ea8346b01ad7ae9eb4)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "secret", value)

    @builtins.property
    @jsii.member(jsii_name="subscriptionId")
    def subscription_id(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "subscriptionId"))

    @subscription_id.setter
    def subscription_id(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__030dbb056efbe20837256ce43acbbf3f0a042338f7eaf584d5da97a966f1ade6)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "subscriptionId", value)

    @builtins.property
    @jsii.member(jsii_name="tenantId")
    def tenant_id(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "tenantId"))

    @tenant_id.setter
    def tenant_id(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1b10d03016237213b406fbea0c0234c896b5432234d76f29390df77058785a79)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "tenantId", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(self) -> typing.Optional[EncryptionAtRestAzureKeyVaultConfig]:
        return typing.cast(typing.Optional[EncryptionAtRestAzureKeyVaultConfig], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[EncryptionAtRestAzureKeyVaultConfig],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__52199317422413f9c082734d0a9af04626b6ff66474a6ada6d72c26b41e7d7ab)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


@jsii.data_type(
    jsii_type="@cdktf/provider-mongodbatlas.encryptionAtRest.EncryptionAtRestConfig",
    jsii_struct_bases=[_cdktf_9a9027ec.TerraformMetaArguments],
    name_mapping={
        "connection": "connection",
        "count": "count",
        "depends_on": "dependsOn",
        "for_each": "forEach",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "provisioners": "provisioners",
        "project_id": "projectId",
        "aws_kms": "awsKms",
        "aws_kms_config": "awsKmsConfig",
        "azure_key_vault": "azureKeyVault",
        "azure_key_vault_config": "azureKeyVaultConfig",
        "google_cloud_kms": "googleCloudKms",
        "google_cloud_kms_config": "googleCloudKmsConfig",
        "id": "id",
    },
)
class EncryptionAtRestConfig(_cdktf_9a9027ec.TerraformMetaArguments):
    def __init__(
        self,
        *,
        connection: typing.Optional[typing.Union[typing.Union[_cdktf_9a9027ec.SSHProvisionerConnection, typing.Dict[builtins.str, typing.Any]], typing.Union[_cdktf_9a9027ec.WinrmProvisionerConnection, typing.Dict[builtins.str, typing.Any]]]] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.Sequence[_cdktf_9a9027ec.ITerraformDependable]] = None,
        for_each: typing.Optional[_cdktf_9a9027ec.ITerraformIterator] = None,
        lifecycle: typing.Optional[typing.Union[_cdktf_9a9027ec.TerraformResourceLifecycle, typing.Dict[builtins.str, typing.Any]]] = None,
        provider: typing.Optional[_cdktf_9a9027ec.TerraformProvider] = None,
        provisioners: typing.Optional[typing.Sequence[typing.Union[typing.Union[_cdktf_9a9027ec.FileProvisioner, typing.Dict[builtins.str, typing.Any]], typing.Union[_cdktf_9a9027ec.LocalExecProvisioner, typing.Dict[builtins.str, typing.Any]], typing.Union[_cdktf_9a9027ec.RemoteExecProvisioner, typing.Dict[builtins.str, typing.Any]]]]] = None,
        project_id: builtins.str,
        aws_kms: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        aws_kms_config: typing.Optional[typing.Union[EncryptionAtRestAwsKmsConfig, typing.Dict[builtins.str, typing.Any]]] = None,
        azure_key_vault: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        azure_key_vault_config: typing.Optional[typing.Union[EncryptionAtRestAzureKeyVaultConfig, typing.Dict[builtins.str, typing.Any]]] = None,
        google_cloud_kms: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        google_cloud_kms_config: typing.Optional[typing.Union["EncryptionAtRestGoogleCloudKmsConfig", typing.Dict[builtins.str, typing.Any]]] = None,
        id: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param connection: 
        :param count: 
        :param depends_on: 
        :param for_each: 
        :param lifecycle: 
        :param provider: 
        :param provisioners: 
        :param project_id: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#project_id EncryptionAtRest#project_id}.
        :param aws_kms: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#aws_kms EncryptionAtRest#aws_kms}.
        :param aws_kms_config: aws_kms_config block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#aws_kms_config EncryptionAtRest#aws_kms_config}
        :param azure_key_vault: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#azure_key_vault EncryptionAtRest#azure_key_vault}.
        :param azure_key_vault_config: azure_key_vault_config block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#azure_key_vault_config EncryptionAtRest#azure_key_vault_config}
        :param google_cloud_kms: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#google_cloud_kms EncryptionAtRest#google_cloud_kms}.
        :param google_cloud_kms_config: google_cloud_kms_config block. Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#google_cloud_kms_config EncryptionAtRest#google_cloud_kms_config}
        :param id: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#id EncryptionAtRest#id}. Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2. If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
        '''
        if isinstance(lifecycle, dict):
            lifecycle = _cdktf_9a9027ec.TerraformResourceLifecycle(**lifecycle)
        if isinstance(aws_kms_config, dict):
            aws_kms_config = EncryptionAtRestAwsKmsConfig(**aws_kms_config)
        if isinstance(azure_key_vault_config, dict):
            azure_key_vault_config = EncryptionAtRestAzureKeyVaultConfig(**azure_key_vault_config)
        if isinstance(google_cloud_kms_config, dict):
            google_cloud_kms_config = EncryptionAtRestGoogleCloudKmsConfig(**google_cloud_kms_config)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8fd0d6cbf8a84a372487ec153ba2f3813d8498010cc8bebed82e6cb3a5bb07f8)
            check_type(argname="argument connection", value=connection, expected_type=type_hints["connection"])
            check_type(argname="argument count", value=count, expected_type=type_hints["count"])
            check_type(argname="argument depends_on", value=depends_on, expected_type=type_hints["depends_on"])
            check_type(argname="argument for_each", value=for_each, expected_type=type_hints["for_each"])
            check_type(argname="argument lifecycle", value=lifecycle, expected_type=type_hints["lifecycle"])
            check_type(argname="argument provider", value=provider, expected_type=type_hints["provider"])
            check_type(argname="argument provisioners", value=provisioners, expected_type=type_hints["provisioners"])
            check_type(argname="argument project_id", value=project_id, expected_type=type_hints["project_id"])
            check_type(argname="argument aws_kms", value=aws_kms, expected_type=type_hints["aws_kms"])
            check_type(argname="argument aws_kms_config", value=aws_kms_config, expected_type=type_hints["aws_kms_config"])
            check_type(argname="argument azure_key_vault", value=azure_key_vault, expected_type=type_hints["azure_key_vault"])
            check_type(argname="argument azure_key_vault_config", value=azure_key_vault_config, expected_type=type_hints["azure_key_vault_config"])
            check_type(argname="argument google_cloud_kms", value=google_cloud_kms, expected_type=type_hints["google_cloud_kms"])
            check_type(argname="argument google_cloud_kms_config", value=google_cloud_kms_config, expected_type=type_hints["google_cloud_kms_config"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "project_id": project_id,
        }
        if connection is not None:
            self._values["connection"] = connection
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if for_each is not None:
            self._values["for_each"] = for_each
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if provisioners is not None:
            self._values["provisioners"] = provisioners
        if aws_kms is not None:
            self._values["aws_kms"] = aws_kms
        if aws_kms_config is not None:
            self._values["aws_kms_config"] = aws_kms_config
        if azure_key_vault is not None:
            self._values["azure_key_vault"] = azure_key_vault
        if azure_key_vault_config is not None:
            self._values["azure_key_vault_config"] = azure_key_vault_config
        if google_cloud_kms is not None:
            self._values["google_cloud_kms"] = google_cloud_kms
        if google_cloud_kms_config is not None:
            self._values["google_cloud_kms_config"] = google_cloud_kms_config
        if id is not None:
            self._values["id"] = id

    @builtins.property
    def connection(
        self,
    ) -> typing.Optional[typing.Union[_cdktf_9a9027ec.SSHProvisionerConnection, _cdktf_9a9027ec.WinrmProvisionerConnection]]:
        '''
        :stability: experimental
        '''
        result = self._values.get("connection")
        return typing.cast(typing.Optional[typing.Union[_cdktf_9a9027ec.SSHProvisionerConnection, _cdktf_9a9027ec.WinrmProvisionerConnection]], result)

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        '''
        :stability: experimental
        '''
        result = self._values.get("count")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def depends_on(
        self,
    ) -> typing.Optional[typing.List[_cdktf_9a9027ec.ITerraformDependable]]:
        '''
        :stability: experimental
        '''
        result = self._values.get("depends_on")
        return typing.cast(typing.Optional[typing.List[_cdktf_9a9027ec.ITerraformDependable]], result)

    @builtins.property
    def for_each(self) -> typing.Optional[_cdktf_9a9027ec.ITerraformIterator]:
        '''
        :stability: experimental
        '''
        result = self._values.get("for_each")
        return typing.cast(typing.Optional[_cdktf_9a9027ec.ITerraformIterator], result)

    @builtins.property
    def lifecycle(self) -> typing.Optional[_cdktf_9a9027ec.TerraformResourceLifecycle]:
        '''
        :stability: experimental
        '''
        result = self._values.get("lifecycle")
        return typing.cast(typing.Optional[_cdktf_9a9027ec.TerraformResourceLifecycle], result)

    @builtins.property
    def provider(self) -> typing.Optional[_cdktf_9a9027ec.TerraformProvider]:
        '''
        :stability: experimental
        '''
        result = self._values.get("provider")
        return typing.cast(typing.Optional[_cdktf_9a9027ec.TerraformProvider], result)

    @builtins.property
    def provisioners(
        self,
    ) -> typing.Optional[typing.List[typing.Union[_cdktf_9a9027ec.FileProvisioner, _cdktf_9a9027ec.LocalExecProvisioner, _cdktf_9a9027ec.RemoteExecProvisioner]]]:
        '''
        :stability: experimental
        '''
        result = self._values.get("provisioners")
        return typing.cast(typing.Optional[typing.List[typing.Union[_cdktf_9a9027ec.FileProvisioner, _cdktf_9a9027ec.LocalExecProvisioner, _cdktf_9a9027ec.RemoteExecProvisioner]]], result)

    @builtins.property
    def project_id(self) -> builtins.str:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#project_id EncryptionAtRest#project_id}.'''
        result = self._values.get("project_id")
        assert result is not None, "Required property 'project_id' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def aws_kms(self) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#aws_kms EncryptionAtRest#aws_kms}.'''
        result = self._values.get("aws_kms")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, builtins.str]], result)

    @builtins.property
    def aws_kms_config(self) -> typing.Optional[EncryptionAtRestAwsKmsConfig]:
        '''aws_kms_config block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#aws_kms_config EncryptionAtRest#aws_kms_config}
        '''
        result = self._values.get("aws_kms_config")
        return typing.cast(typing.Optional[EncryptionAtRestAwsKmsConfig], result)

    @builtins.property
    def azure_key_vault(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#azure_key_vault EncryptionAtRest#azure_key_vault}.'''
        result = self._values.get("azure_key_vault")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, builtins.str]], result)

    @builtins.property
    def azure_key_vault_config(
        self,
    ) -> typing.Optional[EncryptionAtRestAzureKeyVaultConfig]:
        '''azure_key_vault_config block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#azure_key_vault_config EncryptionAtRest#azure_key_vault_config}
        '''
        result = self._values.get("azure_key_vault_config")
        return typing.cast(typing.Optional[EncryptionAtRestAzureKeyVaultConfig], result)

    @builtins.property
    def google_cloud_kms(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#google_cloud_kms EncryptionAtRest#google_cloud_kms}.'''
        result = self._values.get("google_cloud_kms")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, builtins.str]], result)

    @builtins.property
    def google_cloud_kms_config(
        self,
    ) -> typing.Optional["EncryptionAtRestGoogleCloudKmsConfig"]:
        '''google_cloud_kms_config block.

        Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#google_cloud_kms_config EncryptionAtRest#google_cloud_kms_config}
        '''
        result = self._values.get("google_cloud_kms_config")
        return typing.cast(typing.Optional["EncryptionAtRestGoogleCloudKmsConfig"], result)

    @builtins.property
    def id(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#id EncryptionAtRest#id}.

        Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
        If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
        '''
        result = self._values.get("id")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "EncryptionAtRestConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@cdktf/provider-mongodbatlas.encryptionAtRest.EncryptionAtRestGoogleCloudKmsConfig",
    jsii_struct_bases=[],
    name_mapping={
        "enabled": "enabled",
        "key_version_resource_id": "keyVersionResourceId",
        "service_account_key": "serviceAccountKey",
    },
)
class EncryptionAtRestGoogleCloudKmsConfig:
    def __init__(
        self,
        *,
        enabled: typing.Optional[typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable]] = None,
        key_version_resource_id: typing.Optional[builtins.str] = None,
        service_account_key: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param enabled: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#enabled EncryptionAtRest#enabled}.
        :param key_version_resource_id: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#key_version_resource_id EncryptionAtRest#key_version_resource_id}.
        :param service_account_key: Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#service_account_key EncryptionAtRest#service_account_key}.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__aedb02119e179d4089eb0d364bb17330a58560982b3605a6181f3239dd678184)
            check_type(argname="argument enabled", value=enabled, expected_type=type_hints["enabled"])
            check_type(argname="argument key_version_resource_id", value=key_version_resource_id, expected_type=type_hints["key_version_resource_id"])
            check_type(argname="argument service_account_key", value=service_account_key, expected_type=type_hints["service_account_key"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if enabled is not None:
            self._values["enabled"] = enabled
        if key_version_resource_id is not None:
            self._values["key_version_resource_id"] = key_version_resource_id
        if service_account_key is not None:
            self._values["service_account_key"] = service_account_key

    @builtins.property
    def enabled(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable]]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#enabled EncryptionAtRest#enabled}.'''
        result = self._values.get("enabled")
        return typing.cast(typing.Optional[typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable]], result)

    @builtins.property
    def key_version_resource_id(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#key_version_resource_id EncryptionAtRest#key_version_resource_id}.'''
        result = self._values.get("key_version_resource_id")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def service_account_key(self) -> typing.Optional[builtins.str]:
        '''Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/encryption_at_rest#service_account_key EncryptionAtRest#service_account_key}.'''
        result = self._values.get("service_account_key")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "EncryptionAtRestGoogleCloudKmsConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class EncryptionAtRestGoogleCloudKmsConfigOutputReference(
    _cdktf_9a9027ec.ComplexObject,
    metaclass=jsii.JSIIMeta,
    jsii_type="@cdktf/provider-mongodbatlas.encryptionAtRest.EncryptionAtRestGoogleCloudKmsConfigOutputReference",
):
    def __init__(
        self,
        terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: The parent resource.
        :param terraform_attribute: The attribute on the parent resource this class is referencing.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4bfaca90c3f6809a2826ed8c38a1a8a7f49dbd6808ffe0e60b27580a2d2a466d)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @jsii.member(jsii_name="resetEnabled")
    def reset_enabled(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetEnabled", []))

    @jsii.member(jsii_name="resetKeyVersionResourceId")
    def reset_key_version_resource_id(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetKeyVersionResourceId", []))

    @jsii.member(jsii_name="resetServiceAccountKey")
    def reset_service_account_key(self) -> None:
        return typing.cast(None, jsii.invoke(self, "resetServiceAccountKey", []))

    @builtins.property
    @jsii.member(jsii_name="enabledInput")
    def enabled_input(
        self,
    ) -> typing.Optional[typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable]]:
        return typing.cast(typing.Optional[typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable]], jsii.get(self, "enabledInput"))

    @builtins.property
    @jsii.member(jsii_name="keyVersionResourceIdInput")
    def key_version_resource_id_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "keyVersionResourceIdInput"))

    @builtins.property
    @jsii.member(jsii_name="serviceAccountKeyInput")
    def service_account_key_input(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "serviceAccountKeyInput"))

    @builtins.property
    @jsii.member(jsii_name="enabled")
    def enabled(self) -> typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable]:
        return typing.cast(typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable], jsii.get(self, "enabled"))

    @enabled.setter
    def enabled(
        self,
        value: typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__52eeed5634eae91d25dda8d5f7fe8806b117f3485f1b87f00fbf14b0a0d12ddb)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "enabled", value)

    @builtins.property
    @jsii.member(jsii_name="keyVersionResourceId")
    def key_version_resource_id(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "keyVersionResourceId"))

    @key_version_resource_id.setter
    def key_version_resource_id(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b348720d95ed8204a70c897eee20442ba668247f32f91cab8899640b9f38dfd6)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "keyVersionResourceId", value)

    @builtins.property
    @jsii.member(jsii_name="serviceAccountKey")
    def service_account_key(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "serviceAccountKey"))

    @service_account_key.setter
    def service_account_key(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4346f8a20f517ffa99b4e5995f3f8146c333c2319ef9b7d2338e2109a11b41de)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "serviceAccountKey", value)

    @builtins.property
    @jsii.member(jsii_name="internalValue")
    def internal_value(self) -> typing.Optional[EncryptionAtRestGoogleCloudKmsConfig]:
        return typing.cast(typing.Optional[EncryptionAtRestGoogleCloudKmsConfig], jsii.get(self, "internalValue"))

    @internal_value.setter
    def internal_value(
        self,
        value: typing.Optional[EncryptionAtRestGoogleCloudKmsConfig],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__685dfa2d5d6e4991e48f4f73402afbfe5534a824ecc445c8046945ff7b7410e8)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "internalValue", value)


__all__ = [
    "EncryptionAtRest",
    "EncryptionAtRestAwsKmsConfig",
    "EncryptionAtRestAwsKmsConfigOutputReference",
    "EncryptionAtRestAzureKeyVaultConfig",
    "EncryptionAtRestAzureKeyVaultConfigOutputReference",
    "EncryptionAtRestConfig",
    "EncryptionAtRestGoogleCloudKmsConfig",
    "EncryptionAtRestGoogleCloudKmsConfigOutputReference",
]

publication.publish()

def _typecheckingstub__b8a749241b9925e4e5575c33df78a5f4c547da582518cff88d990656dedbacb8(
    scope: _constructs_77d1e7e8.Construct,
    id_: builtins.str,
    *,
    project_id: builtins.str,
    aws_kms: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
    aws_kms_config: typing.Optional[typing.Union[EncryptionAtRestAwsKmsConfig, typing.Dict[builtins.str, typing.Any]]] = None,
    azure_key_vault: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
    azure_key_vault_config: typing.Optional[typing.Union[EncryptionAtRestAzureKeyVaultConfig, typing.Dict[builtins.str, typing.Any]]] = None,
    google_cloud_kms: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
    google_cloud_kms_config: typing.Optional[typing.Union[EncryptionAtRestGoogleCloudKmsConfig, typing.Dict[builtins.str, typing.Any]]] = None,
    id: typing.Optional[builtins.str] = None,
    connection: typing.Optional[typing.Union[typing.Union[_cdktf_9a9027ec.SSHProvisionerConnection, typing.Dict[builtins.str, typing.Any]], typing.Union[_cdktf_9a9027ec.WinrmProvisionerConnection, typing.Dict[builtins.str, typing.Any]]]] = None,
    count: typing.Optional[jsii.Number] = None,
    depends_on: typing.Optional[typing.Sequence[_cdktf_9a9027ec.ITerraformDependable]] = None,
    for_each: typing.Optional[_cdktf_9a9027ec.ITerraformIterator] = None,
    lifecycle: typing.Optional[typing.Union[_cdktf_9a9027ec.TerraformResourceLifecycle, typing.Dict[builtins.str, typing.Any]]] = None,
    provider: typing.Optional[_cdktf_9a9027ec.TerraformProvider] = None,
    provisioners: typing.Optional[typing.Sequence[typing.Union[typing.Union[_cdktf_9a9027ec.FileProvisioner, typing.Dict[builtins.str, typing.Any]], typing.Union[_cdktf_9a9027ec.LocalExecProvisioner, typing.Dict[builtins.str, typing.Any]], typing.Union[_cdktf_9a9027ec.RemoteExecProvisioner, typing.Dict[builtins.str, typing.Any]]]]] = None,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__d625ab972abc671bf7777204ba5006fecaf1aa5a38f4cf36717ec3785939d2f2(
    value: typing.Mapping[builtins.str, builtins.str],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__422e2c00b6be559b033687e5e17d7062e8c159959c0f86e0ccc13fba6283d714(
    value: typing.Mapping[builtins.str, builtins.str],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__d5dc984bdab637cd0715cb9b493da8e29eb3ca6b3dbfb81db51efa9b6aabed9b(
    value: typing.Mapping[builtins.str, builtins.str],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__27277a75d95c364c5b70c731815b7acb3211a7b0c4171957c6427cce25a6e9f1(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__9439e0e2caad1419ef55c3bce2d0e9762828a700c38e7fc4c0c6df694a3d7f9c(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__1dd6569dc4b956383c6698bba19ed570923e21ab1bcc7247a726669fa55ccaa1(
    *,
    access_key_id: typing.Optional[builtins.str] = None,
    customer_master_key_id: typing.Optional[builtins.str] = None,
    enabled: typing.Optional[typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable]] = None,
    region: typing.Optional[builtins.str] = None,
    role_id: typing.Optional[builtins.str] = None,
    secret_access_key: typing.Optional[builtins.str] = None,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__58d2d3a567c0bf664f2b33d6fad122cea199f1c4af389e2ced9e5038115d59e5(
    terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
    terraform_attribute: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__f51b399a6b218c7cfaeda67a1bfe310fbffe2656af726f28bb6fd28a95df29c0(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__4361390b0e55e1cfd4f404c68d2fe4d747847ff2b16fd45d24d959a0abca2c9a(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__eb2e8075f14e443d096f05767a14288428c6d1f96c44b927d083871cb521f851(
    value: typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__ef4c80bc4747c81dba5c780f7c052b1dac12f90d2c983d89f17e1f0197cb6fcb(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__55081dbc7a44d12c1a56eb8949356b1da8be074cf5a8ff28b995922027d106f1(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__12b709f63a750640efb8dbb285fc46e321a400ce0739ab0f311b94519db83ea0(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__2837550a221a143ba84f9f8051c03a38e6cdc75bf63b452e090b383c89e59814(
    value: typing.Optional[EncryptionAtRestAwsKmsConfig],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__af1862db25e54c77985632a2ac72a3a22ffc755c82b8d516e11b4c05257a8c22(
    *,
    enabled: typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable],
    azure_environment: typing.Optional[builtins.str] = None,
    client_id: typing.Optional[builtins.str] = None,
    key_identifier: typing.Optional[builtins.str] = None,
    key_vault_name: typing.Optional[builtins.str] = None,
    resource_group_name: typing.Optional[builtins.str] = None,
    secret: typing.Optional[builtins.str] = None,
    subscription_id: typing.Optional[builtins.str] = None,
    tenant_id: typing.Optional[builtins.str] = None,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__7cf936d70031c0e28dd3de0139428b13036a86d3a0a83edaf6d7843d6466149b(
    terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
    terraform_attribute: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__8a5080be53a162314178eb3d5a5754dcdf9af36d5bbeb8a5d7f68acba1b4af2e(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__7ae7fda14c6d425af21fb6567e49233b21a590ccbf3d8fcf8b7e85a73d07ed20(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__e3645fc98a9ddbe83aa53926f7f7c8e634518f2c97af7ec68b934366e3d3d4e6(
    value: typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__4db41b5d2b0af428972a4e9f72116499c0eecc581aef510b14e1f4f416428977(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__a7c134ac3f2fb59beced0dce92b78bfc1f797c12d48e6488f9e3c144fa1f703a(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__48748e519eea9ea85d698ac8f416d359ab2181ce066b5f34a58f177d2e5bcd32(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__315e7d884e7ee505be7de1fc076a66df982f3ef2ee62a2ea8346b01ad7ae9eb4(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__030dbb056efbe20837256ce43acbbf3f0a042338f7eaf584d5da97a966f1ade6(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__1b10d03016237213b406fbea0c0234c896b5432234d76f29390df77058785a79(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__52199317422413f9c082734d0a9af04626b6ff66474a6ada6d72c26b41e7d7ab(
    value: typing.Optional[EncryptionAtRestAzureKeyVaultConfig],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__8fd0d6cbf8a84a372487ec153ba2f3813d8498010cc8bebed82e6cb3a5bb07f8(
    *,
    connection: typing.Optional[typing.Union[typing.Union[_cdktf_9a9027ec.SSHProvisionerConnection, typing.Dict[builtins.str, typing.Any]], typing.Union[_cdktf_9a9027ec.WinrmProvisionerConnection, typing.Dict[builtins.str, typing.Any]]]] = None,
    count: typing.Optional[jsii.Number] = None,
    depends_on: typing.Optional[typing.Sequence[_cdktf_9a9027ec.ITerraformDependable]] = None,
    for_each: typing.Optional[_cdktf_9a9027ec.ITerraformIterator] = None,
    lifecycle: typing.Optional[typing.Union[_cdktf_9a9027ec.TerraformResourceLifecycle, typing.Dict[builtins.str, typing.Any]]] = None,
    provider: typing.Optional[_cdktf_9a9027ec.TerraformProvider] = None,
    provisioners: typing.Optional[typing.Sequence[typing.Union[typing.Union[_cdktf_9a9027ec.FileProvisioner, typing.Dict[builtins.str, typing.Any]], typing.Union[_cdktf_9a9027ec.LocalExecProvisioner, typing.Dict[builtins.str, typing.Any]], typing.Union[_cdktf_9a9027ec.RemoteExecProvisioner, typing.Dict[builtins.str, typing.Any]]]]] = None,
    project_id: builtins.str,
    aws_kms: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
    aws_kms_config: typing.Optional[typing.Union[EncryptionAtRestAwsKmsConfig, typing.Dict[builtins.str, typing.Any]]] = None,
    azure_key_vault: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
    azure_key_vault_config: typing.Optional[typing.Union[EncryptionAtRestAzureKeyVaultConfig, typing.Dict[builtins.str, typing.Any]]] = None,
    google_cloud_kms: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
    google_cloud_kms_config: typing.Optional[typing.Union[EncryptionAtRestGoogleCloudKmsConfig, typing.Dict[builtins.str, typing.Any]]] = None,
    id: typing.Optional[builtins.str] = None,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__aedb02119e179d4089eb0d364bb17330a58560982b3605a6181f3239dd678184(
    *,
    enabled: typing.Optional[typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable]] = None,
    key_version_resource_id: typing.Optional[builtins.str] = None,
    service_account_key: typing.Optional[builtins.str] = None,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__4bfaca90c3f6809a2826ed8c38a1a8a7f49dbd6808ffe0e60b27580a2d2a466d(
    terraform_resource: _cdktf_9a9027ec.IInterpolatingParent,
    terraform_attribute: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__52eeed5634eae91d25dda8d5f7fe8806b117f3485f1b87f00fbf14b0a0d12ddb(
    value: typing.Union[builtins.bool, _cdktf_9a9027ec.IResolvable],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__b348720d95ed8204a70c897eee20442ba668247f32f91cab8899640b9f38dfd6(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__4346f8a20f517ffa99b4e5995f3f8146c333c2319ef9b7d2338e2109a11b41de(
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__685dfa2d5d6e4991e48f4f73402afbfe5534a824ecc445c8046945ff7b7410e8(
    value: typing.Optional[EncryptionAtRestGoogleCloudKmsConfig],
) -> None:
    """Type checking stubs"""
    pass
