import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AdvancedClusterConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/advanced_cluster#backup_enabled AdvancedCluster#backup_enabled}
    */
    readonly backupEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/advanced_cluster#cluster_type AdvancedCluster#cluster_type}
    */
    readonly clusterType: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/advanced_cluster#disk_size_gb AdvancedCluster#disk_size_gb}
    */
    readonly diskSizeGb?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/advanced_cluster#encryption_at_rest_provider AdvancedCluster#encryption_at_rest_provider}
    */
    readonly encryptionAtRestProvider?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/advanced_cluster#id AdvancedCluster#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/advanced_cluster#mongo_db_major_version AdvancedCluster#mongo_db_major_version}
    */
    readonly mongoDbMajorVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/advanced_cluster#name AdvancedCluster#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/advanced_cluster#paused AdvancedCluster#paused}
    */
    readonly paused?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/advanced_cluster#pit_enabled AdvancedCluster#pit_enabled}
    */
    readonly pitEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/advanced_cluster#project_id AdvancedCluster#project_id}
    */
    readonly projectId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/advanced_cluster#root_cert_type AdvancedCluster#root_cert_type}
    */
    readonly rootCertType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/advanced_cluster#termination_protection_enabled AdvancedCluster#termination_protection_enabled}
    */
    readonly terminationProtectionEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/advanced_cluster#version_release_system AdvancedCluster#version_release_system}
    */
    readonly versionReleaseSystem?: string;
    /**
    * advanced_configuration block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/advanced_cluster#advanced_configuration AdvancedCluster#advanced_configuration}
    */
    readonly advancedConfiguration?: AdvancedClusterAdvancedConfiguration;
    /**
    * bi_connector block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/advanced_cluster#bi_connector AdvancedCluster#bi_connector}
    */
    readonly biConnector?: AdvancedClusterBiConnector;
    /**
    * bi_connector_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/advanced_cluster#bi_connector_config AdvancedCluster#bi_connector_config}
    */
    readonly biConnectorConfig?: AdvancedClusterBiConnectorConfig;
    /**
    * labels block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/advanced_cluster#labels AdvancedCluster#labels}
    */
    readonly labels?: AdvancedClusterLabels[] | cdktf.IResolvable;
    /**
    * replication_specs block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/advanced_cluster#replication_specs AdvancedCluster#replication_specs}
    */
    readonly replicationSpecs: AdvancedClusterReplicationSpecs[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/advanced_cluster#timeouts AdvancedCluster#timeouts}
    */
    readonly timeouts?: AdvancedClusterTimeouts;
}
export interface AdvancedClusterConnectionStringsPrivateEndpointEndpoints {
}
export declare function advancedClusterConnectionStringsPrivateEndpointEndpointsToTerraform(struct?: AdvancedClusterConnectionStringsPrivateEndpointEndpoints): any;
export declare class AdvancedClusterConnectionStringsPrivateEndpointEndpointsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AdvancedClusterConnectionStringsPrivateEndpointEndpoints | undefined;
    set internalValue(value: AdvancedClusterConnectionStringsPrivateEndpointEndpoints | undefined);
    get endpointId(): string;
    get providerName(): string;
    get region(): string;
}
export declare class AdvancedClusterConnectionStringsPrivateEndpointEndpointsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AdvancedClusterConnectionStringsPrivateEndpointEndpointsOutputReference;
}
export interface AdvancedClusterConnectionStringsPrivateEndpoint {
}
export declare function advancedClusterConnectionStringsPrivateEndpointToTerraform(struct?: AdvancedClusterConnectionStringsPrivateEndpoint): any;
export declare class AdvancedClusterConnectionStringsPrivateEndpointOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AdvancedClusterConnectionStringsPrivateEndpoint | undefined;
    set internalValue(value: AdvancedClusterConnectionStringsPrivateEndpoint | undefined);
    get connectionString(): string;
    private _endpoints;
    get endpoints(): AdvancedClusterConnectionStringsPrivateEndpointEndpointsList;
    get srvConnectionString(): string;
    get type(): string;
}
export declare class AdvancedClusterConnectionStringsPrivateEndpointList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AdvancedClusterConnectionStringsPrivateEndpointOutputReference;
}
export interface AdvancedClusterConnectionStrings {
}
export declare function advancedClusterConnectionStringsToTerraform(struct?: AdvancedClusterConnectionStrings): any;
export declare class AdvancedClusterConnectionStringsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AdvancedClusterConnectionStrings | undefined;
    set internalValue(value: AdvancedClusterConnectionStrings | undefined);
    private _awsPrivateLink;
    get awsPrivateLink(): cdktf.StringMap;
    private _awsPrivateLinkSrv;
    get awsPrivateLinkSrv(): cdktf.StringMap;
    get private(): string;
    private _privateEndpoint;
    get privateEndpoint(): AdvancedClusterConnectionStringsPrivateEndpointList;
    get privateSrv(): string;
    get standard(): string;
    get standardSrv(): string;
}
export declare class AdvancedClusterConnectionStringsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AdvancedClusterConnectionStringsOutputReference;
}
export interface AdvancedClusterAdvancedConfiguration {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/advanced_cluster#default_read_concern AdvancedCluster#default_read_concern}
    */
    readonly defaultReadConcern?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/advanced_cluster#default_write_concern AdvancedCluster#default_write_concern}
    */
    readonly defaultWriteConcern?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/advanced_cluster#fail_index_key_too_long AdvancedCluster#fail_index_key_too_long}
    */
    readonly failIndexKeyTooLong?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/advanced_cluster#javascript_enabled AdvancedCluster#javascript_enabled}
    */
    readonly javascriptEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/advanced_cluster#minimum_enabled_tls_protocol AdvancedCluster#minimum_enabled_tls_protocol}
    */
    readonly minimumEnabledTlsProtocol?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/advanced_cluster#no_table_scan AdvancedCluster#no_table_scan}
    */
    readonly noTableScan?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/advanced_cluster#oplog_min_retention_hours AdvancedCluster#oplog_min_retention_hours}
    */
    readonly oplogMinRetentionHours?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/advanced_cluster#oplog_size_mb AdvancedCluster#oplog_size_mb}
    */
    readonly oplogSizeMb?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/advanced_cluster#sample_refresh_interval_bi_connector AdvancedCluster#sample_refresh_interval_bi_connector}
    */
    readonly sampleRefreshIntervalBiConnector?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/advanced_cluster#sample_size_bi_connector AdvancedCluster#sample_size_bi_connector}
    */
    readonly sampleSizeBiConnector?: number;
}
export declare function advancedClusterAdvancedConfigurationToTerraform(struct?: AdvancedClusterAdvancedConfigurationOutputReference | AdvancedClusterAdvancedConfiguration): any;
export declare class AdvancedClusterAdvancedConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AdvancedClusterAdvancedConfiguration | undefined;
    set internalValue(value: AdvancedClusterAdvancedConfiguration | undefined);
    private _defaultReadConcern?;
    get defaultReadConcern(): string;
    set defaultReadConcern(value: string);
    resetDefaultReadConcern(): void;
    get defaultReadConcernInput(): string | undefined;
    private _defaultWriteConcern?;
    get defaultWriteConcern(): string;
    set defaultWriteConcern(value: string);
    resetDefaultWriteConcern(): void;
    get defaultWriteConcernInput(): string | undefined;
    private _failIndexKeyTooLong?;
    get failIndexKeyTooLong(): boolean | cdktf.IResolvable;
    set failIndexKeyTooLong(value: boolean | cdktf.IResolvable);
    resetFailIndexKeyTooLong(): void;
    get failIndexKeyTooLongInput(): boolean | cdktf.IResolvable | undefined;
    private _javascriptEnabled?;
    get javascriptEnabled(): boolean | cdktf.IResolvable;
    set javascriptEnabled(value: boolean | cdktf.IResolvable);
    resetJavascriptEnabled(): void;
    get javascriptEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _minimumEnabledTlsProtocol?;
    get minimumEnabledTlsProtocol(): string;
    set minimumEnabledTlsProtocol(value: string);
    resetMinimumEnabledTlsProtocol(): void;
    get minimumEnabledTlsProtocolInput(): string | undefined;
    private _noTableScan?;
    get noTableScan(): boolean | cdktf.IResolvable;
    set noTableScan(value: boolean | cdktf.IResolvable);
    resetNoTableScan(): void;
    get noTableScanInput(): boolean | cdktf.IResolvable | undefined;
    private _oplogMinRetentionHours?;
    get oplogMinRetentionHours(): number;
    set oplogMinRetentionHours(value: number);
    resetOplogMinRetentionHours(): void;
    get oplogMinRetentionHoursInput(): number | undefined;
    private _oplogSizeMb?;
    get oplogSizeMb(): number;
    set oplogSizeMb(value: number);
    resetOplogSizeMb(): void;
    get oplogSizeMbInput(): number | undefined;
    private _sampleRefreshIntervalBiConnector?;
    get sampleRefreshIntervalBiConnector(): number;
    set sampleRefreshIntervalBiConnector(value: number);
    resetSampleRefreshIntervalBiConnector(): void;
    get sampleRefreshIntervalBiConnectorInput(): number | undefined;
    private _sampleSizeBiConnector?;
    get sampleSizeBiConnector(): number;
    set sampleSizeBiConnector(value: number);
    resetSampleSizeBiConnector(): void;
    get sampleSizeBiConnectorInput(): number | undefined;
}
export interface AdvancedClusterBiConnector {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/advanced_cluster#enabled AdvancedCluster#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/advanced_cluster#read_preference AdvancedCluster#read_preference}
    */
    readonly readPreference?: string;
}
export declare function advancedClusterBiConnectorToTerraform(struct?: AdvancedClusterBiConnectorOutputReference | AdvancedClusterBiConnector): any;
export declare class AdvancedClusterBiConnectorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AdvancedClusterBiConnector | undefined;
    set internalValue(value: AdvancedClusterBiConnector | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _readPreference?;
    get readPreference(): string;
    set readPreference(value: string);
    resetReadPreference(): void;
    get readPreferenceInput(): string | undefined;
}
export interface AdvancedClusterBiConnectorConfig {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/advanced_cluster#enabled AdvancedCluster#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/advanced_cluster#read_preference AdvancedCluster#read_preference}
    */
    readonly readPreference?: string;
}
export declare function advancedClusterBiConnectorConfigToTerraform(struct?: AdvancedClusterBiConnectorConfigOutputReference | AdvancedClusterBiConnectorConfig): any;
export declare class AdvancedClusterBiConnectorConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AdvancedClusterBiConnectorConfig | undefined;
    set internalValue(value: AdvancedClusterBiConnectorConfig | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _readPreference?;
    get readPreference(): string;
    set readPreference(value: string);
    resetReadPreference(): void;
    get readPreferenceInput(): string | undefined;
}
export interface AdvancedClusterLabels {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/advanced_cluster#key AdvancedCluster#key}
    */
    readonly key?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/advanced_cluster#value AdvancedCluster#value}
    */
    readonly value?: string;
}
export declare function advancedClusterLabelsToTerraform(struct?: AdvancedClusterLabels | cdktf.IResolvable): any;
export declare class AdvancedClusterLabelsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AdvancedClusterLabels | cdktf.IResolvable | undefined;
    set internalValue(value: AdvancedClusterLabels | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class AdvancedClusterLabelsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: AdvancedClusterLabels[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AdvancedClusterLabelsOutputReference;
}
export interface AdvancedClusterReplicationSpecsRegionConfigsAnalyticsAutoScaling {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/advanced_cluster#compute_enabled AdvancedCluster#compute_enabled}
    */
    readonly computeEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/advanced_cluster#compute_max_instance_size AdvancedCluster#compute_max_instance_size}
    */
    readonly computeMaxInstanceSize?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/advanced_cluster#compute_min_instance_size AdvancedCluster#compute_min_instance_size}
    */
    readonly computeMinInstanceSize?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/advanced_cluster#compute_scale_down_enabled AdvancedCluster#compute_scale_down_enabled}
    */
    readonly computeScaleDownEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/advanced_cluster#disk_gb_enabled AdvancedCluster#disk_gb_enabled}
    */
    readonly diskGbEnabled?: boolean | cdktf.IResolvable;
}
export declare function advancedClusterReplicationSpecsRegionConfigsAnalyticsAutoScalingToTerraform(struct?: AdvancedClusterReplicationSpecsRegionConfigsAnalyticsAutoScalingOutputReference | AdvancedClusterReplicationSpecsRegionConfigsAnalyticsAutoScaling): any;
export declare class AdvancedClusterReplicationSpecsRegionConfigsAnalyticsAutoScalingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AdvancedClusterReplicationSpecsRegionConfigsAnalyticsAutoScaling | undefined;
    set internalValue(value: AdvancedClusterReplicationSpecsRegionConfigsAnalyticsAutoScaling | undefined);
    private _computeEnabled?;
    get computeEnabled(): boolean | cdktf.IResolvable;
    set computeEnabled(value: boolean | cdktf.IResolvable);
    resetComputeEnabled(): void;
    get computeEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _computeMaxInstanceSize?;
    get computeMaxInstanceSize(): string;
    set computeMaxInstanceSize(value: string);
    resetComputeMaxInstanceSize(): void;
    get computeMaxInstanceSizeInput(): string | undefined;
    private _computeMinInstanceSize?;
    get computeMinInstanceSize(): string;
    set computeMinInstanceSize(value: string);
    resetComputeMinInstanceSize(): void;
    get computeMinInstanceSizeInput(): string | undefined;
    private _computeScaleDownEnabled?;
    get computeScaleDownEnabled(): boolean | cdktf.IResolvable;
    set computeScaleDownEnabled(value: boolean | cdktf.IResolvable);
    resetComputeScaleDownEnabled(): void;
    get computeScaleDownEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _diskGbEnabled?;
    get diskGbEnabled(): boolean | cdktf.IResolvable;
    set diskGbEnabled(value: boolean | cdktf.IResolvable);
    resetDiskGbEnabled(): void;
    get diskGbEnabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface AdvancedClusterReplicationSpecsRegionConfigsAnalyticsSpecs {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/advanced_cluster#disk_iops AdvancedCluster#disk_iops}
    */
    readonly diskIops?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/advanced_cluster#ebs_volume_type AdvancedCluster#ebs_volume_type}
    */
    readonly ebsVolumeType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/advanced_cluster#instance_size AdvancedCluster#instance_size}
    */
    readonly instanceSize: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/advanced_cluster#node_count AdvancedCluster#node_count}
    */
    readonly nodeCount?: number;
}
export declare function advancedClusterReplicationSpecsRegionConfigsAnalyticsSpecsToTerraform(struct?: AdvancedClusterReplicationSpecsRegionConfigsAnalyticsSpecsOutputReference | AdvancedClusterReplicationSpecsRegionConfigsAnalyticsSpecs): any;
export declare class AdvancedClusterReplicationSpecsRegionConfigsAnalyticsSpecsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AdvancedClusterReplicationSpecsRegionConfigsAnalyticsSpecs | undefined;
    set internalValue(value: AdvancedClusterReplicationSpecsRegionConfigsAnalyticsSpecs | undefined);
    private _diskIops?;
    get diskIops(): number;
    set diskIops(value: number);
    resetDiskIops(): void;
    get diskIopsInput(): number | undefined;
    private _ebsVolumeType?;
    get ebsVolumeType(): string;
    set ebsVolumeType(value: string);
    resetEbsVolumeType(): void;
    get ebsVolumeTypeInput(): string | undefined;
    private _instanceSize?;
    get instanceSize(): string;
    set instanceSize(value: string);
    get instanceSizeInput(): string | undefined;
    private _nodeCount?;
    get nodeCount(): number;
    set nodeCount(value: number);
    resetNodeCount(): void;
    get nodeCountInput(): number | undefined;
}
export interface AdvancedClusterReplicationSpecsRegionConfigsAutoScaling {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/advanced_cluster#compute_enabled AdvancedCluster#compute_enabled}
    */
    readonly computeEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/advanced_cluster#compute_max_instance_size AdvancedCluster#compute_max_instance_size}
    */
    readonly computeMaxInstanceSize?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/advanced_cluster#compute_min_instance_size AdvancedCluster#compute_min_instance_size}
    */
    readonly computeMinInstanceSize?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/advanced_cluster#compute_scale_down_enabled AdvancedCluster#compute_scale_down_enabled}
    */
    readonly computeScaleDownEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/advanced_cluster#disk_gb_enabled AdvancedCluster#disk_gb_enabled}
    */
    readonly diskGbEnabled?: boolean | cdktf.IResolvable;
}
export declare function advancedClusterReplicationSpecsRegionConfigsAutoScalingToTerraform(struct?: AdvancedClusterReplicationSpecsRegionConfigsAutoScalingOutputReference | AdvancedClusterReplicationSpecsRegionConfigsAutoScaling): any;
export declare class AdvancedClusterReplicationSpecsRegionConfigsAutoScalingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AdvancedClusterReplicationSpecsRegionConfigsAutoScaling | undefined;
    set internalValue(value: AdvancedClusterReplicationSpecsRegionConfigsAutoScaling | undefined);
    private _computeEnabled?;
    get computeEnabled(): boolean | cdktf.IResolvable;
    set computeEnabled(value: boolean | cdktf.IResolvable);
    resetComputeEnabled(): void;
    get computeEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _computeMaxInstanceSize?;
    get computeMaxInstanceSize(): string;
    set computeMaxInstanceSize(value: string);
    resetComputeMaxInstanceSize(): void;
    get computeMaxInstanceSizeInput(): string | undefined;
    private _computeMinInstanceSize?;
    get computeMinInstanceSize(): string;
    set computeMinInstanceSize(value: string);
    resetComputeMinInstanceSize(): void;
    get computeMinInstanceSizeInput(): string | undefined;
    private _computeScaleDownEnabled?;
    get computeScaleDownEnabled(): boolean | cdktf.IResolvable;
    set computeScaleDownEnabled(value: boolean | cdktf.IResolvable);
    resetComputeScaleDownEnabled(): void;
    get computeScaleDownEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _diskGbEnabled?;
    get diskGbEnabled(): boolean | cdktf.IResolvable;
    set diskGbEnabled(value: boolean | cdktf.IResolvable);
    resetDiskGbEnabled(): void;
    get diskGbEnabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface AdvancedClusterReplicationSpecsRegionConfigsElectableSpecs {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/advanced_cluster#disk_iops AdvancedCluster#disk_iops}
    */
    readonly diskIops?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/advanced_cluster#ebs_volume_type AdvancedCluster#ebs_volume_type}
    */
    readonly ebsVolumeType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/advanced_cluster#instance_size AdvancedCluster#instance_size}
    */
    readonly instanceSize: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/advanced_cluster#node_count AdvancedCluster#node_count}
    */
    readonly nodeCount?: number;
}
export declare function advancedClusterReplicationSpecsRegionConfigsElectableSpecsToTerraform(struct?: AdvancedClusterReplicationSpecsRegionConfigsElectableSpecsOutputReference | AdvancedClusterReplicationSpecsRegionConfigsElectableSpecs): any;
export declare class AdvancedClusterReplicationSpecsRegionConfigsElectableSpecsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AdvancedClusterReplicationSpecsRegionConfigsElectableSpecs | undefined;
    set internalValue(value: AdvancedClusterReplicationSpecsRegionConfigsElectableSpecs | undefined);
    private _diskIops?;
    get diskIops(): number;
    set diskIops(value: number);
    resetDiskIops(): void;
    get diskIopsInput(): number | undefined;
    private _ebsVolumeType?;
    get ebsVolumeType(): string;
    set ebsVolumeType(value: string);
    resetEbsVolumeType(): void;
    get ebsVolumeTypeInput(): string | undefined;
    private _instanceSize?;
    get instanceSize(): string;
    set instanceSize(value: string);
    get instanceSizeInput(): string | undefined;
    private _nodeCount?;
    get nodeCount(): number;
    set nodeCount(value: number);
    resetNodeCount(): void;
    get nodeCountInput(): number | undefined;
}
export interface AdvancedClusterReplicationSpecsRegionConfigsReadOnlySpecs {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/advanced_cluster#disk_iops AdvancedCluster#disk_iops}
    */
    readonly diskIops?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/advanced_cluster#ebs_volume_type AdvancedCluster#ebs_volume_type}
    */
    readonly ebsVolumeType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/advanced_cluster#instance_size AdvancedCluster#instance_size}
    */
    readonly instanceSize: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/advanced_cluster#node_count AdvancedCluster#node_count}
    */
    readonly nodeCount?: number;
}
export declare function advancedClusterReplicationSpecsRegionConfigsReadOnlySpecsToTerraform(struct?: AdvancedClusterReplicationSpecsRegionConfigsReadOnlySpecsOutputReference | AdvancedClusterReplicationSpecsRegionConfigsReadOnlySpecs): any;
export declare class AdvancedClusterReplicationSpecsRegionConfigsReadOnlySpecsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AdvancedClusterReplicationSpecsRegionConfigsReadOnlySpecs | undefined;
    set internalValue(value: AdvancedClusterReplicationSpecsRegionConfigsReadOnlySpecs | undefined);
    private _diskIops?;
    get diskIops(): number;
    set diskIops(value: number);
    resetDiskIops(): void;
    get diskIopsInput(): number | undefined;
    private _ebsVolumeType?;
    get ebsVolumeType(): string;
    set ebsVolumeType(value: string);
    resetEbsVolumeType(): void;
    get ebsVolumeTypeInput(): string | undefined;
    private _instanceSize?;
    get instanceSize(): string;
    set instanceSize(value: string);
    get instanceSizeInput(): string | undefined;
    private _nodeCount?;
    get nodeCount(): number;
    set nodeCount(value: number);
    resetNodeCount(): void;
    get nodeCountInput(): number | undefined;
}
export interface AdvancedClusterReplicationSpecsRegionConfigs {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/advanced_cluster#backing_provider_name AdvancedCluster#backing_provider_name}
    */
    readonly backingProviderName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/advanced_cluster#priority AdvancedCluster#priority}
    */
    readonly priority: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/advanced_cluster#provider_name AdvancedCluster#provider_name}
    */
    readonly providerName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/advanced_cluster#region_name AdvancedCluster#region_name}
    */
    readonly regionName: string;
    /**
    * analytics_auto_scaling block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/advanced_cluster#analytics_auto_scaling AdvancedCluster#analytics_auto_scaling}
    */
    readonly analyticsAutoScaling?: AdvancedClusterReplicationSpecsRegionConfigsAnalyticsAutoScaling;
    /**
    * analytics_specs block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/advanced_cluster#analytics_specs AdvancedCluster#analytics_specs}
    */
    readonly analyticsSpecs?: AdvancedClusterReplicationSpecsRegionConfigsAnalyticsSpecs;
    /**
    * auto_scaling block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/advanced_cluster#auto_scaling AdvancedCluster#auto_scaling}
    */
    readonly autoScaling?: AdvancedClusterReplicationSpecsRegionConfigsAutoScaling;
    /**
    * electable_specs block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/advanced_cluster#electable_specs AdvancedCluster#electable_specs}
    */
    readonly electableSpecs?: AdvancedClusterReplicationSpecsRegionConfigsElectableSpecs;
    /**
    * read_only_specs block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/advanced_cluster#read_only_specs AdvancedCluster#read_only_specs}
    */
    readonly readOnlySpecs?: AdvancedClusterReplicationSpecsRegionConfigsReadOnlySpecs;
}
export declare function advancedClusterReplicationSpecsRegionConfigsToTerraform(struct?: AdvancedClusterReplicationSpecsRegionConfigs | cdktf.IResolvable): any;
export declare class AdvancedClusterReplicationSpecsRegionConfigsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AdvancedClusterReplicationSpecsRegionConfigs | cdktf.IResolvable | undefined;
    set internalValue(value: AdvancedClusterReplicationSpecsRegionConfigs | cdktf.IResolvable | undefined);
    private _backingProviderName?;
    get backingProviderName(): string;
    set backingProviderName(value: string);
    resetBackingProviderName(): void;
    get backingProviderNameInput(): string | undefined;
    private _priority?;
    get priority(): number;
    set priority(value: number);
    get priorityInput(): number | undefined;
    private _providerName?;
    get providerName(): string;
    set providerName(value: string);
    get providerNameInput(): string | undefined;
    private _regionName?;
    get regionName(): string;
    set regionName(value: string);
    get regionNameInput(): string | undefined;
    private _analyticsAutoScaling;
    get analyticsAutoScaling(): AdvancedClusterReplicationSpecsRegionConfigsAnalyticsAutoScalingOutputReference;
    putAnalyticsAutoScaling(value: AdvancedClusterReplicationSpecsRegionConfigsAnalyticsAutoScaling): void;
    resetAnalyticsAutoScaling(): void;
    get analyticsAutoScalingInput(): AdvancedClusterReplicationSpecsRegionConfigsAnalyticsAutoScaling | undefined;
    private _analyticsSpecs;
    get analyticsSpecs(): AdvancedClusterReplicationSpecsRegionConfigsAnalyticsSpecsOutputReference;
    putAnalyticsSpecs(value: AdvancedClusterReplicationSpecsRegionConfigsAnalyticsSpecs): void;
    resetAnalyticsSpecs(): void;
    get analyticsSpecsInput(): AdvancedClusterReplicationSpecsRegionConfigsAnalyticsSpecs | undefined;
    private _autoScaling;
    get autoScaling(): AdvancedClusterReplicationSpecsRegionConfigsAutoScalingOutputReference;
    putAutoScaling(value: AdvancedClusterReplicationSpecsRegionConfigsAutoScaling): void;
    resetAutoScaling(): void;
    get autoScalingInput(): AdvancedClusterReplicationSpecsRegionConfigsAutoScaling | undefined;
    private _electableSpecs;
    get electableSpecs(): AdvancedClusterReplicationSpecsRegionConfigsElectableSpecsOutputReference;
    putElectableSpecs(value: AdvancedClusterReplicationSpecsRegionConfigsElectableSpecs): void;
    resetElectableSpecs(): void;
    get electableSpecsInput(): AdvancedClusterReplicationSpecsRegionConfigsElectableSpecs | undefined;
    private _readOnlySpecs;
    get readOnlySpecs(): AdvancedClusterReplicationSpecsRegionConfigsReadOnlySpecsOutputReference;
    putReadOnlySpecs(value: AdvancedClusterReplicationSpecsRegionConfigsReadOnlySpecs): void;
    resetReadOnlySpecs(): void;
    get readOnlySpecsInput(): AdvancedClusterReplicationSpecsRegionConfigsReadOnlySpecs | undefined;
}
export declare class AdvancedClusterReplicationSpecsRegionConfigsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: AdvancedClusterReplicationSpecsRegionConfigs[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AdvancedClusterReplicationSpecsRegionConfigsOutputReference;
}
export interface AdvancedClusterReplicationSpecs {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/advanced_cluster#num_shards AdvancedCluster#num_shards}
    */
    readonly numShards?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/advanced_cluster#zone_name AdvancedCluster#zone_name}
    */
    readonly zoneName?: string;
    /**
    * region_configs block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/advanced_cluster#region_configs AdvancedCluster#region_configs}
    */
    readonly regionConfigs: AdvancedClusterReplicationSpecsRegionConfigs[] | cdktf.IResolvable;
}
export declare function advancedClusterReplicationSpecsToTerraform(struct?: AdvancedClusterReplicationSpecs | cdktf.IResolvable): any;
export declare class AdvancedClusterReplicationSpecsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AdvancedClusterReplicationSpecs | cdktf.IResolvable | undefined;
    set internalValue(value: AdvancedClusterReplicationSpecs | cdktf.IResolvable | undefined);
    private _containerId;
    get containerId(): cdktf.StringMap;
    get id(): string;
    private _numShards?;
    get numShards(): number;
    set numShards(value: number);
    resetNumShards(): void;
    get numShardsInput(): number | undefined;
    private _zoneName?;
    get zoneName(): string;
    set zoneName(value: string);
    resetZoneName(): void;
    get zoneNameInput(): string | undefined;
    private _regionConfigs;
    get regionConfigs(): AdvancedClusterReplicationSpecsRegionConfigsList;
    putRegionConfigs(value: AdvancedClusterReplicationSpecsRegionConfigs[] | cdktf.IResolvable): void;
    get regionConfigsInput(): cdktf.IResolvable | AdvancedClusterReplicationSpecsRegionConfigs[] | undefined;
}
export declare class AdvancedClusterReplicationSpecsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: AdvancedClusterReplicationSpecs[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AdvancedClusterReplicationSpecsOutputReference;
}
export interface AdvancedClusterTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/advanced_cluster#create AdvancedCluster#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/advanced_cluster#delete AdvancedCluster#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/advanced_cluster#update AdvancedCluster#update}
    */
    readonly update?: string;
}
export declare function advancedClusterTimeoutsToTerraform(struct?: AdvancedClusterTimeoutsOutputReference | AdvancedClusterTimeouts | cdktf.IResolvable): any;
export declare class AdvancedClusterTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AdvancedClusterTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: AdvancedClusterTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/mongodbatlas/r/advanced_cluster mongodbatlas_advanced_cluster}
*/
export declare class AdvancedCluster extends cdktf.TerraformResource {
    static readonly tfResourceType = "mongodbatlas_advanced_cluster";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/mongodbatlas/r/advanced_cluster mongodbatlas_advanced_cluster} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AdvancedClusterConfig
    */
    constructor(scope: Construct, id: string, config: AdvancedClusterConfig);
    private _backupEnabled?;
    get backupEnabled(): boolean | cdktf.IResolvable;
    set backupEnabled(value: boolean | cdktf.IResolvable);
    resetBackupEnabled(): void;
    get backupEnabledInput(): boolean | cdktf.IResolvable | undefined;
    get clusterId(): string;
    private _clusterType?;
    get clusterType(): string;
    set clusterType(value: string);
    get clusterTypeInput(): string | undefined;
    private _connectionStrings;
    get connectionStrings(): AdvancedClusterConnectionStringsList;
    get createDate(): string;
    private _diskSizeGb?;
    get diskSizeGb(): number;
    set diskSizeGb(value: number);
    resetDiskSizeGb(): void;
    get diskSizeGbInput(): number | undefined;
    private _encryptionAtRestProvider?;
    get encryptionAtRestProvider(): string;
    set encryptionAtRestProvider(value: string);
    resetEncryptionAtRestProvider(): void;
    get encryptionAtRestProviderInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _mongoDbMajorVersion?;
    get mongoDbMajorVersion(): string;
    set mongoDbMajorVersion(value: string);
    resetMongoDbMajorVersion(): void;
    get mongoDbMajorVersionInput(): string | undefined;
    get mongoDbVersion(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _paused?;
    get paused(): boolean | cdktf.IResolvable;
    set paused(value: boolean | cdktf.IResolvable);
    resetPaused(): void;
    get pausedInput(): boolean | cdktf.IResolvable | undefined;
    private _pitEnabled?;
    get pitEnabled(): boolean | cdktf.IResolvable;
    set pitEnabled(value: boolean | cdktf.IResolvable);
    resetPitEnabled(): void;
    get pitEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
    private _rootCertType?;
    get rootCertType(): string;
    set rootCertType(value: string);
    resetRootCertType(): void;
    get rootCertTypeInput(): string | undefined;
    get stateName(): string;
    private _terminationProtectionEnabled?;
    get terminationProtectionEnabled(): boolean | cdktf.IResolvable;
    set terminationProtectionEnabled(value: boolean | cdktf.IResolvable);
    resetTerminationProtectionEnabled(): void;
    get terminationProtectionEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _versionReleaseSystem?;
    get versionReleaseSystem(): string;
    set versionReleaseSystem(value: string);
    resetVersionReleaseSystem(): void;
    get versionReleaseSystemInput(): string | undefined;
    private _advancedConfiguration;
    get advancedConfiguration(): AdvancedClusterAdvancedConfigurationOutputReference;
    putAdvancedConfiguration(value: AdvancedClusterAdvancedConfiguration): void;
    resetAdvancedConfiguration(): void;
    get advancedConfigurationInput(): AdvancedClusterAdvancedConfiguration | undefined;
    private _biConnector;
    get biConnector(): AdvancedClusterBiConnectorOutputReference;
    putBiConnector(value: AdvancedClusterBiConnector): void;
    resetBiConnector(): void;
    get biConnectorInput(): AdvancedClusterBiConnector | undefined;
    private _biConnectorConfig;
    get biConnectorConfig(): AdvancedClusterBiConnectorConfigOutputReference;
    putBiConnectorConfig(value: AdvancedClusterBiConnectorConfig): void;
    resetBiConnectorConfig(): void;
    get biConnectorConfigInput(): AdvancedClusterBiConnectorConfig | undefined;
    private _labels;
    get labels(): AdvancedClusterLabelsList;
    putLabels(value: AdvancedClusterLabels[] | cdktf.IResolvable): void;
    resetLabels(): void;
    get labelsInput(): cdktf.IResolvable | AdvancedClusterLabels[] | undefined;
    private _replicationSpecs;
    get replicationSpecs(): AdvancedClusterReplicationSpecsList;
    putReplicationSpecs(value: AdvancedClusterReplicationSpecs[] | cdktf.IResolvable): void;
    get replicationSpecsInput(): cdktf.IResolvable | AdvancedClusterReplicationSpecs[] | undefined;
    private _timeouts;
    get timeouts(): AdvancedClusterTimeoutsOutputReference;
    putTimeouts(value: AdvancedClusterTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | AdvancedClusterTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
