import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ApiKeyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/api_key#description ApiKey#description}
    */
    readonly description: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/api_key#id ApiKey#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/api_key#org_id ApiKey#org_id}
    */
    readonly orgId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/api_key#role_names ApiKey#role_names}
    */
    readonly roleNames: string[];
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/mongodbatlas/r/api_key mongodbatlas_api_key}
*/
export declare class ApiKey extends cdktf.TerraformResource {
    static readonly tfResourceType = "mongodbatlas_api_key";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/mongodbatlas/r/api_key mongodbatlas_api_key} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ApiKeyConfig
    */
    constructor(scope: Construct, id: string, config: ApiKeyConfig);
    get apiKeyId(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _orgId?;
    get orgId(): string;
    set orgId(value: string);
    get orgIdInput(): string | undefined;
    get privateKey(): string;
    get publicKey(): string;
    private _roleNames?;
    get roleNames(): string[];
    set roleNames(value: string[]);
    get roleNamesInput(): string[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
