import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AuditingConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/auditing#audit_authorization_success Auditing#audit_authorization_success}
    */
    readonly auditAuthorizationSuccess?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/auditing#audit_filter Auditing#audit_filter}
    */
    readonly auditFilter?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/auditing#enabled Auditing#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/auditing#id Auditing#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/auditing#project_id Auditing#project_id}
    */
    readonly projectId: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/mongodbatlas/r/auditing mongodbatlas_auditing}
*/
export declare class Auditing extends cdktf.TerraformResource {
    static readonly tfResourceType = "mongodbatlas_auditing";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/mongodbatlas/r/auditing mongodbatlas_auditing} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AuditingConfig
    */
    constructor(scope: Construct, id: string, config: AuditingConfig);
    private _auditAuthorizationSuccess?;
    get auditAuthorizationSuccess(): boolean | cdktf.IResolvable;
    set auditAuthorizationSuccess(value: boolean | cdktf.IResolvable);
    resetAuditAuthorizationSuccess(): void;
    get auditAuthorizationSuccessInput(): boolean | cdktf.IResolvable | undefined;
    private _auditFilter?;
    get auditFilter(): string;
    set auditFilter(value: string);
    resetAuditFilter(): void;
    get auditFilterInput(): string | undefined;
    get configurationType(): string;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
