import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CloudBackupScheduleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cloud_backup_schedule#auto_export_enabled CloudBackupSchedule#auto_export_enabled}
    */
    readonly autoExportEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cloud_backup_schedule#cluster_name CloudBackupSchedule#cluster_name}
    */
    readonly clusterName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cloud_backup_schedule#id CloudBackupSchedule#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cloud_backup_schedule#project_id CloudBackupSchedule#project_id}
    */
    readonly projectId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cloud_backup_schedule#reference_hour_of_day CloudBackupSchedule#reference_hour_of_day}
    */
    readonly referenceHourOfDay?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cloud_backup_schedule#reference_minute_of_hour CloudBackupSchedule#reference_minute_of_hour}
    */
    readonly referenceMinuteOfHour?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cloud_backup_schedule#restore_window_days CloudBackupSchedule#restore_window_days}
    */
    readonly restoreWindowDays?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cloud_backup_schedule#update_snapshots CloudBackupSchedule#update_snapshots}
    */
    readonly updateSnapshots?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cloud_backup_schedule#use_org_and_group_names_in_export_prefix CloudBackupSchedule#use_org_and_group_names_in_export_prefix}
    */
    readonly useOrgAndGroupNamesInExportPrefix?: boolean | cdktf.IResolvable;
    /**
    * copy_settings block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cloud_backup_schedule#copy_settings CloudBackupSchedule#copy_settings}
    */
    readonly copySettings?: CloudBackupScheduleCopySettings[] | cdktf.IResolvable;
    /**
    * export block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cloud_backup_schedule#export CloudBackupSchedule#export}
    */
    readonly export?: CloudBackupScheduleExport;
    /**
    * policy_item_daily block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cloud_backup_schedule#policy_item_daily CloudBackupSchedule#policy_item_daily}
    */
    readonly policyItemDaily?: CloudBackupSchedulePolicyItemDaily;
    /**
    * policy_item_hourly block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cloud_backup_schedule#policy_item_hourly CloudBackupSchedule#policy_item_hourly}
    */
    readonly policyItemHourly?: CloudBackupSchedulePolicyItemHourly;
    /**
    * policy_item_monthly block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cloud_backup_schedule#policy_item_monthly CloudBackupSchedule#policy_item_monthly}
    */
    readonly policyItemMonthly?: CloudBackupSchedulePolicyItemMonthly[] | cdktf.IResolvable;
    /**
    * policy_item_weekly block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cloud_backup_schedule#policy_item_weekly CloudBackupSchedule#policy_item_weekly}
    */
    readonly policyItemWeekly?: CloudBackupSchedulePolicyItemWeekly[] | cdktf.IResolvable;
}
export interface CloudBackupScheduleCopySettings {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cloud_backup_schedule#cloud_provider CloudBackupSchedule#cloud_provider}
    */
    readonly cloudProvider?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cloud_backup_schedule#frequencies CloudBackupSchedule#frequencies}
    */
    readonly frequencies?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cloud_backup_schedule#region_name CloudBackupSchedule#region_name}
    */
    readonly regionName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cloud_backup_schedule#replication_spec_id CloudBackupSchedule#replication_spec_id}
    */
    readonly replicationSpecId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cloud_backup_schedule#should_copy_oplogs CloudBackupSchedule#should_copy_oplogs}
    */
    readonly shouldCopyOplogs?: boolean | cdktf.IResolvable;
}
export declare function cloudBackupScheduleCopySettingsToTerraform(struct?: CloudBackupScheduleCopySettings | cdktf.IResolvable): any;
export declare class CloudBackupScheduleCopySettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CloudBackupScheduleCopySettings | cdktf.IResolvable | undefined;
    set internalValue(value: CloudBackupScheduleCopySettings | cdktf.IResolvable | undefined);
    private _cloudProvider?;
    get cloudProvider(): string;
    set cloudProvider(value: string);
    resetCloudProvider(): void;
    get cloudProviderInput(): string | undefined;
    private _frequencies?;
    get frequencies(): string[];
    set frequencies(value: string[]);
    resetFrequencies(): void;
    get frequenciesInput(): string[] | undefined;
    private _regionName?;
    get regionName(): string;
    set regionName(value: string);
    resetRegionName(): void;
    get regionNameInput(): string | undefined;
    private _replicationSpecId?;
    get replicationSpecId(): string;
    set replicationSpecId(value: string);
    resetReplicationSpecId(): void;
    get replicationSpecIdInput(): string | undefined;
    private _shouldCopyOplogs?;
    get shouldCopyOplogs(): boolean | cdktf.IResolvable;
    set shouldCopyOplogs(value: boolean | cdktf.IResolvable);
    resetShouldCopyOplogs(): void;
    get shouldCopyOplogsInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class CloudBackupScheduleCopySettingsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CloudBackupScheduleCopySettings[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CloudBackupScheduleCopySettingsOutputReference;
}
export interface CloudBackupScheduleExport {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cloud_backup_schedule#export_bucket_id CloudBackupSchedule#export_bucket_id}
    */
    readonly exportBucketId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cloud_backup_schedule#frequency_type CloudBackupSchedule#frequency_type}
    */
    readonly frequencyType?: string;
}
export declare function cloudBackupScheduleExportToTerraform(struct?: CloudBackupScheduleExportOutputReference | CloudBackupScheduleExport): any;
export declare class CloudBackupScheduleExportOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudBackupScheduleExport | undefined;
    set internalValue(value: CloudBackupScheduleExport | undefined);
    private _exportBucketId?;
    get exportBucketId(): string;
    set exportBucketId(value: string);
    resetExportBucketId(): void;
    get exportBucketIdInput(): string | undefined;
    private _frequencyType?;
    get frequencyType(): string;
    set frequencyType(value: string);
    resetFrequencyType(): void;
    get frequencyTypeInput(): string | undefined;
}
export interface CloudBackupSchedulePolicyItemDaily {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cloud_backup_schedule#frequency_interval CloudBackupSchedule#frequency_interval}
    */
    readonly frequencyInterval: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cloud_backup_schedule#retention_unit CloudBackupSchedule#retention_unit}
    */
    readonly retentionUnit: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cloud_backup_schedule#retention_value CloudBackupSchedule#retention_value}
    */
    readonly retentionValue: number;
}
export declare function cloudBackupSchedulePolicyItemDailyToTerraform(struct?: CloudBackupSchedulePolicyItemDailyOutputReference | CloudBackupSchedulePolicyItemDaily): any;
export declare class CloudBackupSchedulePolicyItemDailyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudBackupSchedulePolicyItemDaily | undefined;
    set internalValue(value: CloudBackupSchedulePolicyItemDaily | undefined);
    private _frequencyInterval?;
    get frequencyInterval(): number;
    set frequencyInterval(value: number);
    get frequencyIntervalInput(): number | undefined;
    get frequencyType(): string;
    get id(): string;
    private _retentionUnit?;
    get retentionUnit(): string;
    set retentionUnit(value: string);
    get retentionUnitInput(): string | undefined;
    private _retentionValue?;
    get retentionValue(): number;
    set retentionValue(value: number);
    get retentionValueInput(): number | undefined;
}
export interface CloudBackupSchedulePolicyItemHourly {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cloud_backup_schedule#frequency_interval CloudBackupSchedule#frequency_interval}
    */
    readonly frequencyInterval: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cloud_backup_schedule#retention_unit CloudBackupSchedule#retention_unit}
    */
    readonly retentionUnit: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cloud_backup_schedule#retention_value CloudBackupSchedule#retention_value}
    */
    readonly retentionValue: number;
}
export declare function cloudBackupSchedulePolicyItemHourlyToTerraform(struct?: CloudBackupSchedulePolicyItemHourlyOutputReference | CloudBackupSchedulePolicyItemHourly): any;
export declare class CloudBackupSchedulePolicyItemHourlyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudBackupSchedulePolicyItemHourly | undefined;
    set internalValue(value: CloudBackupSchedulePolicyItemHourly | undefined);
    private _frequencyInterval?;
    get frequencyInterval(): number;
    set frequencyInterval(value: number);
    get frequencyIntervalInput(): number | undefined;
    get frequencyType(): string;
    get id(): string;
    private _retentionUnit?;
    get retentionUnit(): string;
    set retentionUnit(value: string);
    get retentionUnitInput(): string | undefined;
    private _retentionValue?;
    get retentionValue(): number;
    set retentionValue(value: number);
    get retentionValueInput(): number | undefined;
}
export interface CloudBackupSchedulePolicyItemMonthly {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cloud_backup_schedule#frequency_interval CloudBackupSchedule#frequency_interval}
    */
    readonly frequencyInterval: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cloud_backup_schedule#retention_unit CloudBackupSchedule#retention_unit}
    */
    readonly retentionUnit: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cloud_backup_schedule#retention_value CloudBackupSchedule#retention_value}
    */
    readonly retentionValue: number;
}
export declare function cloudBackupSchedulePolicyItemMonthlyToTerraform(struct?: CloudBackupSchedulePolicyItemMonthly | cdktf.IResolvable): any;
export declare class CloudBackupSchedulePolicyItemMonthlyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CloudBackupSchedulePolicyItemMonthly | cdktf.IResolvable | undefined;
    set internalValue(value: CloudBackupSchedulePolicyItemMonthly | cdktf.IResolvable | undefined);
    private _frequencyInterval?;
    get frequencyInterval(): number;
    set frequencyInterval(value: number);
    get frequencyIntervalInput(): number | undefined;
    get frequencyType(): string;
    get id(): string;
    private _retentionUnit?;
    get retentionUnit(): string;
    set retentionUnit(value: string);
    get retentionUnitInput(): string | undefined;
    private _retentionValue?;
    get retentionValue(): number;
    set retentionValue(value: number);
    get retentionValueInput(): number | undefined;
}
export declare class CloudBackupSchedulePolicyItemMonthlyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CloudBackupSchedulePolicyItemMonthly[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CloudBackupSchedulePolicyItemMonthlyOutputReference;
}
export interface CloudBackupSchedulePolicyItemWeekly {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cloud_backup_schedule#frequency_interval CloudBackupSchedule#frequency_interval}
    */
    readonly frequencyInterval: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cloud_backup_schedule#retention_unit CloudBackupSchedule#retention_unit}
    */
    readonly retentionUnit: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cloud_backup_schedule#retention_value CloudBackupSchedule#retention_value}
    */
    readonly retentionValue: number;
}
export declare function cloudBackupSchedulePolicyItemWeeklyToTerraform(struct?: CloudBackupSchedulePolicyItemWeekly | cdktf.IResolvable): any;
export declare class CloudBackupSchedulePolicyItemWeeklyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CloudBackupSchedulePolicyItemWeekly | cdktf.IResolvable | undefined;
    set internalValue(value: CloudBackupSchedulePolicyItemWeekly | cdktf.IResolvable | undefined);
    private _frequencyInterval?;
    get frequencyInterval(): number;
    set frequencyInterval(value: number);
    get frequencyIntervalInput(): number | undefined;
    get frequencyType(): string;
    get id(): string;
    private _retentionUnit?;
    get retentionUnit(): string;
    set retentionUnit(value: string);
    get retentionUnitInput(): string | undefined;
    private _retentionValue?;
    get retentionValue(): number;
    set retentionValue(value: number);
    get retentionValueInput(): number | undefined;
}
export declare class CloudBackupSchedulePolicyItemWeeklyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CloudBackupSchedulePolicyItemWeekly[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CloudBackupSchedulePolicyItemWeeklyOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cloud_backup_schedule mongodbatlas_cloud_backup_schedule}
*/
export declare class CloudBackupSchedule extends cdktf.TerraformResource {
    static readonly tfResourceType = "mongodbatlas_cloud_backup_schedule";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cloud_backup_schedule mongodbatlas_cloud_backup_schedule} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CloudBackupScheduleConfig
    */
    constructor(scope: Construct, id: string, config: CloudBackupScheduleConfig);
    private _autoExportEnabled?;
    get autoExportEnabled(): boolean | cdktf.IResolvable;
    set autoExportEnabled(value: boolean | cdktf.IResolvable);
    resetAutoExportEnabled(): void;
    get autoExportEnabledInput(): boolean | cdktf.IResolvable | undefined;
    get clusterId(): string;
    private _clusterName?;
    get clusterName(): string;
    set clusterName(value: string);
    get clusterNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get idPolicy(): string;
    get nextSnapshot(): string;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
    private _referenceHourOfDay?;
    get referenceHourOfDay(): number;
    set referenceHourOfDay(value: number);
    resetReferenceHourOfDay(): void;
    get referenceHourOfDayInput(): number | undefined;
    private _referenceMinuteOfHour?;
    get referenceMinuteOfHour(): number;
    set referenceMinuteOfHour(value: number);
    resetReferenceMinuteOfHour(): void;
    get referenceMinuteOfHourInput(): number | undefined;
    private _restoreWindowDays?;
    get restoreWindowDays(): number;
    set restoreWindowDays(value: number);
    resetRestoreWindowDays(): void;
    get restoreWindowDaysInput(): number | undefined;
    private _updateSnapshots?;
    get updateSnapshots(): boolean | cdktf.IResolvable;
    set updateSnapshots(value: boolean | cdktf.IResolvable);
    resetUpdateSnapshots(): void;
    get updateSnapshotsInput(): boolean | cdktf.IResolvable | undefined;
    private _useOrgAndGroupNamesInExportPrefix?;
    get useOrgAndGroupNamesInExportPrefix(): boolean | cdktf.IResolvable;
    set useOrgAndGroupNamesInExportPrefix(value: boolean | cdktf.IResolvable);
    resetUseOrgAndGroupNamesInExportPrefix(): void;
    get useOrgAndGroupNamesInExportPrefixInput(): boolean | cdktf.IResolvable | undefined;
    private _copySettings;
    get copySettings(): CloudBackupScheduleCopySettingsList;
    putCopySettings(value: CloudBackupScheduleCopySettings[] | cdktf.IResolvable): void;
    resetCopySettings(): void;
    get copySettingsInput(): cdktf.IResolvable | CloudBackupScheduleCopySettings[] | undefined;
    private _export;
    get export(): CloudBackupScheduleExportOutputReference;
    putExport(value: CloudBackupScheduleExport): void;
    resetExport(): void;
    get exportInput(): CloudBackupScheduleExport | undefined;
    private _policyItemDaily;
    get policyItemDaily(): CloudBackupSchedulePolicyItemDailyOutputReference;
    putPolicyItemDaily(value: CloudBackupSchedulePolicyItemDaily): void;
    resetPolicyItemDaily(): void;
    get policyItemDailyInput(): CloudBackupSchedulePolicyItemDaily | undefined;
    private _policyItemHourly;
    get policyItemHourly(): CloudBackupSchedulePolicyItemHourlyOutputReference;
    putPolicyItemHourly(value: CloudBackupSchedulePolicyItemHourly): void;
    resetPolicyItemHourly(): void;
    get policyItemHourlyInput(): CloudBackupSchedulePolicyItemHourly | undefined;
    private _policyItemMonthly;
    get policyItemMonthly(): CloudBackupSchedulePolicyItemMonthlyList;
    putPolicyItemMonthly(value: CloudBackupSchedulePolicyItemMonthly[] | cdktf.IResolvable): void;
    resetPolicyItemMonthly(): void;
    get policyItemMonthlyInput(): cdktf.IResolvable | CloudBackupSchedulePolicyItemMonthly[] | undefined;
    private _policyItemWeekly;
    get policyItemWeekly(): CloudBackupSchedulePolicyItemWeeklyList;
    putPolicyItemWeekly(value: CloudBackupSchedulePolicyItemWeekly[] | cdktf.IResolvable): void;
    resetPolicyItemWeekly(): void;
    get policyItemWeeklyInput(): cdktf.IResolvable | CloudBackupSchedulePolicyItemWeekly[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
