import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CloudBackupSnapshotExportJobConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cloud_backup_snapshot_export_job#cluster_name CloudBackupSnapshotExportJob#cluster_name}
    */
    readonly clusterName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cloud_backup_snapshot_export_job#export_bucket_id CloudBackupSnapshotExportJob#export_bucket_id}
    */
    readonly exportBucketId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cloud_backup_snapshot_export_job#project_id CloudBackupSnapshotExportJob#project_id}
    */
    readonly projectId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cloud_backup_snapshot_export_job#snapshot_id CloudBackupSnapshotExportJob#snapshot_id}
    */
    readonly snapshotId: string;
    /**
    * custom_data block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cloud_backup_snapshot_export_job#custom_data CloudBackupSnapshotExportJob#custom_data}
    */
    readonly customData: CloudBackupSnapshotExportJobCustomData[] | cdktf.IResolvable;
}
export interface CloudBackupSnapshotExportJobComponents {
}
export declare function cloudBackupSnapshotExportJobComponentsToTerraform(struct?: CloudBackupSnapshotExportJobComponents): any;
export declare class CloudBackupSnapshotExportJobComponentsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CloudBackupSnapshotExportJobComponents | undefined;
    set internalValue(value: CloudBackupSnapshotExportJobComponents | undefined);
    get exportId(): string;
    get replicaSetName(): string;
}
export declare class CloudBackupSnapshotExportJobComponentsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CloudBackupSnapshotExportJobComponentsOutputReference;
}
export interface CloudBackupSnapshotExportJobCustomData {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cloud_backup_snapshot_export_job#key CloudBackupSnapshotExportJob#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cloud_backup_snapshot_export_job#value CloudBackupSnapshotExportJob#value}
    */
    readonly value: string;
}
export declare function cloudBackupSnapshotExportJobCustomDataToTerraform(struct?: CloudBackupSnapshotExportJobCustomData | cdktf.IResolvable): any;
export declare class CloudBackupSnapshotExportJobCustomDataOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CloudBackupSnapshotExportJobCustomData | cdktf.IResolvable | undefined;
    set internalValue(value: CloudBackupSnapshotExportJobCustomData | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class CloudBackupSnapshotExportJobCustomDataList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CloudBackupSnapshotExportJobCustomData[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CloudBackupSnapshotExportJobCustomDataOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cloud_backup_snapshot_export_job mongodbatlas_cloud_backup_snapshot_export_job}
*/
export declare class CloudBackupSnapshotExportJob extends cdktf.TerraformResource {
    static readonly tfResourceType = "mongodbatlas_cloud_backup_snapshot_export_job";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cloud_backup_snapshot_export_job mongodbatlas_cloud_backup_snapshot_export_job} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CloudBackupSnapshotExportJobConfig
    */
    constructor(scope: Construct, id: string, config: CloudBackupSnapshotExportJobConfig);
    private _clusterName?;
    get clusterName(): string;
    set clusterName(value: string);
    get clusterNameInput(): string | undefined;
    private _components;
    get components(): CloudBackupSnapshotExportJobComponentsList;
    get createdAt(): string;
    get errMsg(): string;
    private _exportBucketId?;
    get exportBucketId(): string;
    set exportBucketId(value: string);
    get exportBucketIdInput(): string | undefined;
    get exportJobId(): string;
    get exportStatusExportedCollections(): number;
    get exportStatusTotalCollections(): number;
    get finishedAt(): string;
    get id(): string;
    get prefix(): string;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
    private _snapshotId?;
    get snapshotId(): string;
    set snapshotId(value: string);
    get snapshotIdInput(): string | undefined;
    get state(): string;
    private _customData;
    get customData(): CloudBackupSnapshotExportJobCustomDataList;
    putCustomData(value: CloudBackupSnapshotExportJobCustomData[] | cdktf.IResolvable): void;
    get customDataInput(): cdktf.IResolvable | CloudBackupSnapshotExportJobCustomData[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
