import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CloudBackupSnapshotRestoreJobConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cloud_backup_snapshot_restore_job#cluster_name CloudBackupSnapshotRestoreJob#cluster_name}
    */
    readonly clusterName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cloud_backup_snapshot_restore_job#delivery_type CloudBackupSnapshotRestoreJob#delivery_type}
    */
    readonly deliveryType?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cloud_backup_snapshot_restore_job#id CloudBackupSnapshotRestoreJob#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cloud_backup_snapshot_restore_job#project_id CloudBackupSnapshotRestoreJob#project_id}
    */
    readonly projectId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cloud_backup_snapshot_restore_job#snapshot_id CloudBackupSnapshotRestoreJob#snapshot_id}
    */
    readonly snapshotId: string;
    /**
    * delivery_type_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cloud_backup_snapshot_restore_job#delivery_type_config CloudBackupSnapshotRestoreJob#delivery_type_config}
    */
    readonly deliveryTypeConfig?: CloudBackupSnapshotRestoreJobDeliveryTypeConfig;
}
export interface CloudBackupSnapshotRestoreJobDeliveryTypeConfig {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cloud_backup_snapshot_restore_job#automated CloudBackupSnapshotRestoreJob#automated}
    */
    readonly automated?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cloud_backup_snapshot_restore_job#download CloudBackupSnapshotRestoreJob#download}
    */
    readonly download?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cloud_backup_snapshot_restore_job#oplog_inc CloudBackupSnapshotRestoreJob#oplog_inc}
    */
    readonly oplogInc?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cloud_backup_snapshot_restore_job#oplog_ts CloudBackupSnapshotRestoreJob#oplog_ts}
    */
    readonly oplogTs?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cloud_backup_snapshot_restore_job#point_in_time CloudBackupSnapshotRestoreJob#point_in_time}
    */
    readonly pointInTime?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cloud_backup_snapshot_restore_job#point_in_time_utc_seconds CloudBackupSnapshotRestoreJob#point_in_time_utc_seconds}
    */
    readonly pointInTimeUtcSeconds?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cloud_backup_snapshot_restore_job#target_cluster_name CloudBackupSnapshotRestoreJob#target_cluster_name}
    */
    readonly targetClusterName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cloud_backup_snapshot_restore_job#target_project_id CloudBackupSnapshotRestoreJob#target_project_id}
    */
    readonly targetProjectId?: string;
}
export declare function cloudBackupSnapshotRestoreJobDeliveryTypeConfigToTerraform(struct?: CloudBackupSnapshotRestoreJobDeliveryTypeConfigOutputReference | CloudBackupSnapshotRestoreJobDeliveryTypeConfig): any;
export declare class CloudBackupSnapshotRestoreJobDeliveryTypeConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudBackupSnapshotRestoreJobDeliveryTypeConfig | undefined;
    set internalValue(value: CloudBackupSnapshotRestoreJobDeliveryTypeConfig | undefined);
    private _automated?;
    get automated(): boolean | cdktf.IResolvable;
    set automated(value: boolean | cdktf.IResolvable);
    resetAutomated(): void;
    get automatedInput(): boolean | cdktf.IResolvable | undefined;
    private _download?;
    get download(): boolean | cdktf.IResolvable;
    set download(value: boolean | cdktf.IResolvable);
    resetDownload(): void;
    get downloadInput(): boolean | cdktf.IResolvable | undefined;
    private _oplogInc?;
    get oplogInc(): number;
    set oplogInc(value: number);
    resetOplogInc(): void;
    get oplogIncInput(): number | undefined;
    private _oplogTs?;
    get oplogTs(): number;
    set oplogTs(value: number);
    resetOplogTs(): void;
    get oplogTsInput(): number | undefined;
    private _pointInTime?;
    get pointInTime(): boolean | cdktf.IResolvable;
    set pointInTime(value: boolean | cdktf.IResolvable);
    resetPointInTime(): void;
    get pointInTimeInput(): boolean | cdktf.IResolvable | undefined;
    private _pointInTimeUtcSeconds?;
    get pointInTimeUtcSeconds(): number;
    set pointInTimeUtcSeconds(value: number);
    resetPointInTimeUtcSeconds(): void;
    get pointInTimeUtcSecondsInput(): number | undefined;
    private _targetClusterName?;
    get targetClusterName(): string;
    set targetClusterName(value: string);
    resetTargetClusterName(): void;
    get targetClusterNameInput(): string | undefined;
    private _targetProjectId?;
    get targetProjectId(): string;
    set targetProjectId(value: string);
    resetTargetProjectId(): void;
    get targetProjectIdInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cloud_backup_snapshot_restore_job mongodbatlas_cloud_backup_snapshot_restore_job}
*/
export declare class CloudBackupSnapshotRestoreJob extends cdktf.TerraformResource {
    static readonly tfResourceType = "mongodbatlas_cloud_backup_snapshot_restore_job";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cloud_backup_snapshot_restore_job mongodbatlas_cloud_backup_snapshot_restore_job} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CloudBackupSnapshotRestoreJobConfig
    */
    constructor(scope: Construct, id: string, config: CloudBackupSnapshotRestoreJobConfig);
    get cancelled(): cdktf.IResolvable;
    private _clusterName?;
    get clusterName(): string;
    set clusterName(value: string);
    get clusterNameInput(): string | undefined;
    get createdAt(): string;
    private _deliveryType?;
    get deliveryType(): {
        [key: string]: string;
    };
    set deliveryType(value: {
        [key: string]: string;
    });
    resetDeliveryType(): void;
    get deliveryTypeInput(): {
        [key: string]: string;
    } | undefined;
    get deliveryUrl(): string[];
    get expired(): cdktf.IResolvable;
    get expiresAt(): string;
    get finishedAt(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
    private _snapshotId?;
    get snapshotId(): string;
    set snapshotId(value: string);
    get snapshotIdInput(): string | undefined;
    get snapshotRestoreJobId(): string;
    get timestamp(): string;
    private _deliveryTypeConfig;
    get deliveryTypeConfig(): CloudBackupSnapshotRestoreJobDeliveryTypeConfigOutputReference;
    putDeliveryTypeConfig(value: CloudBackupSnapshotRestoreJobDeliveryTypeConfig): void;
    resetDeliveryTypeConfig(): void;
    get deliveryTypeConfigInput(): CloudBackupSnapshotRestoreJobDeliveryTypeConfig | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
