import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CloudBackupSnapshotConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cloud_backup_snapshot#cluster_name CloudBackupSnapshot#cluster_name}
    */
    readonly clusterName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cloud_backup_snapshot#description CloudBackupSnapshot#description}
    */
    readonly description: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cloud_backup_snapshot#id CloudBackupSnapshot#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cloud_backup_snapshot#project_id CloudBackupSnapshot#project_id}
    */
    readonly projectId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cloud_backup_snapshot#retention_in_days CloudBackupSnapshot#retention_in_days}
    */
    readonly retentionInDays: number;
}
export interface CloudBackupSnapshotMembers {
}
export declare function cloudBackupSnapshotMembersToTerraform(struct?: CloudBackupSnapshotMembers): any;
export declare class CloudBackupSnapshotMembersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CloudBackupSnapshotMembers | undefined;
    set internalValue(value: CloudBackupSnapshotMembers | undefined);
    get cloudProvider(): string;
    get id(): string;
    get replicaSetName(): string;
}
export declare class CloudBackupSnapshotMembersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CloudBackupSnapshotMembersOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cloud_backup_snapshot mongodbatlas_cloud_backup_snapshot}
*/
export declare class CloudBackupSnapshot extends cdktf.TerraformResource {
    static readonly tfResourceType = "mongodbatlas_cloud_backup_snapshot";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cloud_backup_snapshot mongodbatlas_cloud_backup_snapshot} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CloudBackupSnapshotConfig
    */
    constructor(scope: Construct, id: string, config: CloudBackupSnapshotConfig);
    get cloudProvider(): string;
    private _clusterName?;
    get clusterName(): string;
    set clusterName(value: string);
    get clusterNameInput(): string | undefined;
    get createdAt(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    get descriptionInput(): string | undefined;
    get expiresAt(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get masterKeyUuid(): string;
    private _members;
    get members(): CloudBackupSnapshotMembersList;
    get mongodVersion(): string;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
    get replicaSetName(): string;
    private _retentionInDays?;
    get retentionInDays(): number;
    set retentionInDays(value: number);
    get retentionInDaysInput(): number | undefined;
    get snapshotId(): string;
    get snapshotIds(): string[];
    get snapshotType(): string;
    get status(): string;
    get storageSizeBytes(): number;
    get type(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
