import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CloudProviderAccessAuthorizationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cloud_provider_access_authorization#id CloudProviderAccessAuthorization#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cloud_provider_access_authorization#project_id CloudProviderAccessAuthorization#project_id}
    */
    readonly projectId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cloud_provider_access_authorization#role_id CloudProviderAccessAuthorization#role_id}
    */
    readonly roleId: string;
    /**
    * aws block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cloud_provider_access_authorization#aws CloudProviderAccessAuthorization#aws}
    */
    readonly aws?: CloudProviderAccessAuthorizationAws;
}
export interface CloudProviderAccessAuthorizationFeatureUsages {
}
export declare function cloudProviderAccessAuthorizationFeatureUsagesToTerraform(struct?: CloudProviderAccessAuthorizationFeatureUsages): any;
export declare class CloudProviderAccessAuthorizationFeatureUsagesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CloudProviderAccessAuthorizationFeatureUsages | undefined;
    set internalValue(value: CloudProviderAccessAuthorizationFeatureUsages | undefined);
    private _featureId;
    get featureId(): cdktf.StringMap;
    get featureType(): string;
}
export declare class CloudProviderAccessAuthorizationFeatureUsagesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CloudProviderAccessAuthorizationFeatureUsagesOutputReference;
}
export interface CloudProviderAccessAuthorizationAws {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cloud_provider_access_authorization#iam_assumed_role_arn CloudProviderAccessAuthorization#iam_assumed_role_arn}
    */
    readonly iamAssumedRoleArn: string;
}
export declare function cloudProviderAccessAuthorizationAwsToTerraform(struct?: CloudProviderAccessAuthorizationAwsOutputReference | CloudProviderAccessAuthorizationAws): any;
export declare class CloudProviderAccessAuthorizationAwsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudProviderAccessAuthorizationAws | undefined;
    set internalValue(value: CloudProviderAccessAuthorizationAws | undefined);
    private _iamAssumedRoleArn?;
    get iamAssumedRoleArn(): string;
    set iamAssumedRoleArn(value: string);
    get iamAssumedRoleArnInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cloud_provider_access_authorization mongodbatlas_cloud_provider_access_authorization}
*/
export declare class CloudProviderAccessAuthorization extends cdktf.TerraformResource {
    static readonly tfResourceType = "mongodbatlas_cloud_provider_access_authorization";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cloud_provider_access_authorization mongodbatlas_cloud_provider_access_authorization} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CloudProviderAccessAuthorizationConfig
    */
    constructor(scope: Construct, id: string, config: CloudProviderAccessAuthorizationConfig);
    get authorizedDate(): string;
    private _featureUsages;
    get featureUsages(): CloudProviderAccessAuthorizationFeatureUsagesList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
    private _roleId?;
    get roleId(): string;
    set roleId(value: string);
    get roleIdInput(): string | undefined;
    private _aws;
    get aws(): CloudProviderAccessAuthorizationAwsOutputReference;
    putAws(value: CloudProviderAccessAuthorizationAws): void;
    resetAws(): void;
    get awsInput(): CloudProviderAccessAuthorizationAws | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
