import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CloudProviderAccessConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cloud_provider_access#iam_assumed_role_arn CloudProviderAccess#iam_assumed_role_arn}
    */
    readonly iamAssumedRoleArn?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cloud_provider_access#id CloudProviderAccess#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cloud_provider_access#project_id CloudProviderAccess#project_id}
    */
    readonly projectId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cloud_provider_access#provider_name CloudProviderAccess#provider_name}
    */
    readonly providerName: string;
}
export interface CloudProviderAccessFeatureUsages {
}
export declare function cloudProviderAccessFeatureUsagesToTerraform(struct?: CloudProviderAccessFeatureUsages): any;
export declare class CloudProviderAccessFeatureUsagesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CloudProviderAccessFeatureUsages | undefined;
    set internalValue(value: CloudProviderAccessFeatureUsages | undefined);
    private _featureId;
    get featureId(): cdktf.StringMap;
    get featureType(): string;
}
export declare class CloudProviderAccessFeatureUsagesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CloudProviderAccessFeatureUsagesOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cloud_provider_access mongodbatlas_cloud_provider_access}
*/
export declare class CloudProviderAccess extends cdktf.TerraformResource {
    static readonly tfResourceType = "mongodbatlas_cloud_provider_access";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cloud_provider_access mongodbatlas_cloud_provider_access} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CloudProviderAccessConfig
    */
    constructor(scope: Construct, id: string, config: CloudProviderAccessConfig);
    get atlasAssumedRoleExternalId(): string;
    get atlasAwsAccountArn(): string;
    get authorizedDate(): string;
    get createdDate(): string;
    private _featureUsages;
    get featureUsages(): CloudProviderAccessFeatureUsagesList;
    private _iamAssumedRoleArn?;
    get iamAssumedRoleArn(): string;
    set iamAssumedRoleArn(value: string);
    resetIamAssumedRoleArn(): void;
    get iamAssumedRoleArnInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
    private _providerName?;
    get providerName(): string;
    set providerName(value: string);
    get providerNameInput(): string | undefined;
    get roleId(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
