import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CloudProviderSnapshotBackupPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cloud_provider_snapshot_backup_policy#cluster_name CloudProviderSnapshotBackupPolicy#cluster_name}
    */
    readonly clusterName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cloud_provider_snapshot_backup_policy#id CloudProviderSnapshotBackupPolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cloud_provider_snapshot_backup_policy#project_id CloudProviderSnapshotBackupPolicy#project_id}
    */
    readonly projectId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cloud_provider_snapshot_backup_policy#reference_hour_of_day CloudProviderSnapshotBackupPolicy#reference_hour_of_day}
    */
    readonly referenceHourOfDay?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cloud_provider_snapshot_backup_policy#reference_minute_of_hour CloudProviderSnapshotBackupPolicy#reference_minute_of_hour}
    */
    readonly referenceMinuteOfHour?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cloud_provider_snapshot_backup_policy#restore_window_days CloudProviderSnapshotBackupPolicy#restore_window_days}
    */
    readonly restoreWindowDays?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cloud_provider_snapshot_backup_policy#update_snapshots CloudProviderSnapshotBackupPolicy#update_snapshots}
    */
    readonly updateSnapshots?: boolean | cdktf.IResolvable;
    /**
    * policies block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cloud_provider_snapshot_backup_policy#policies CloudProviderSnapshotBackupPolicy#policies}
    */
    readonly policies: CloudProviderSnapshotBackupPolicyPolicies[] | cdktf.IResolvable;
}
export interface CloudProviderSnapshotBackupPolicyPoliciesPolicyItem {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cloud_provider_snapshot_backup_policy#frequency_interval CloudProviderSnapshotBackupPolicy#frequency_interval}
    */
    readonly frequencyInterval: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cloud_provider_snapshot_backup_policy#frequency_type CloudProviderSnapshotBackupPolicy#frequency_type}
    */
    readonly frequencyType: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cloud_provider_snapshot_backup_policy#id CloudProviderSnapshotBackupPolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cloud_provider_snapshot_backup_policy#retention_unit CloudProviderSnapshotBackupPolicy#retention_unit}
    */
    readonly retentionUnit: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cloud_provider_snapshot_backup_policy#retention_value CloudProviderSnapshotBackupPolicy#retention_value}
    */
    readonly retentionValue: number;
}
export declare function cloudProviderSnapshotBackupPolicyPoliciesPolicyItemToTerraform(struct?: CloudProviderSnapshotBackupPolicyPoliciesPolicyItem | cdktf.IResolvable): any;
export declare class CloudProviderSnapshotBackupPolicyPoliciesPolicyItemOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CloudProviderSnapshotBackupPolicyPoliciesPolicyItem | cdktf.IResolvable | undefined;
    set internalValue(value: CloudProviderSnapshotBackupPolicyPoliciesPolicyItem | cdktf.IResolvable | undefined);
    private _frequencyInterval?;
    get frequencyInterval(): number;
    set frequencyInterval(value: number);
    get frequencyIntervalInput(): number | undefined;
    private _frequencyType?;
    get frequencyType(): string;
    set frequencyType(value: string);
    get frequencyTypeInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    get idInput(): string | undefined;
    private _retentionUnit?;
    get retentionUnit(): string;
    set retentionUnit(value: string);
    get retentionUnitInput(): string | undefined;
    private _retentionValue?;
    get retentionValue(): number;
    set retentionValue(value: number);
    get retentionValueInput(): number | undefined;
}
export declare class CloudProviderSnapshotBackupPolicyPoliciesPolicyItemList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CloudProviderSnapshotBackupPolicyPoliciesPolicyItem[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CloudProviderSnapshotBackupPolicyPoliciesPolicyItemOutputReference;
}
export interface CloudProviderSnapshotBackupPolicyPolicies {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cloud_provider_snapshot_backup_policy#id CloudProviderSnapshotBackupPolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id: string;
    /**
    * policy_item block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cloud_provider_snapshot_backup_policy#policy_item CloudProviderSnapshotBackupPolicy#policy_item}
    */
    readonly policyItem: CloudProviderSnapshotBackupPolicyPoliciesPolicyItem[] | cdktf.IResolvable;
}
export declare function cloudProviderSnapshotBackupPolicyPoliciesToTerraform(struct?: CloudProviderSnapshotBackupPolicyPolicies | cdktf.IResolvable): any;
export declare class CloudProviderSnapshotBackupPolicyPoliciesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CloudProviderSnapshotBackupPolicyPolicies | cdktf.IResolvable | undefined;
    set internalValue(value: CloudProviderSnapshotBackupPolicyPolicies | cdktf.IResolvable | undefined);
    private _id?;
    get id(): string;
    set id(value: string);
    get idInput(): string | undefined;
    private _policyItem;
    get policyItem(): CloudProviderSnapshotBackupPolicyPoliciesPolicyItemList;
    putPolicyItem(value: CloudProviderSnapshotBackupPolicyPoliciesPolicyItem[] | cdktf.IResolvable): void;
    get policyItemInput(): cdktf.IResolvable | CloudProviderSnapshotBackupPolicyPoliciesPolicyItem[] | undefined;
}
export declare class CloudProviderSnapshotBackupPolicyPoliciesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CloudProviderSnapshotBackupPolicyPolicies[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CloudProviderSnapshotBackupPolicyPoliciesOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cloud_provider_snapshot_backup_policy mongodbatlas_cloud_provider_snapshot_backup_policy}
*/
export declare class CloudProviderSnapshotBackupPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType = "mongodbatlas_cloud_provider_snapshot_backup_policy";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cloud_provider_snapshot_backup_policy mongodbatlas_cloud_provider_snapshot_backup_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CloudProviderSnapshotBackupPolicyConfig
    */
    constructor(scope: Construct, id: string, config: CloudProviderSnapshotBackupPolicyConfig);
    get clusterId(): string;
    private _clusterName?;
    get clusterName(): string;
    set clusterName(value: string);
    get clusterNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get nextSnapshot(): string;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
    private _referenceHourOfDay?;
    get referenceHourOfDay(): number;
    set referenceHourOfDay(value: number);
    resetReferenceHourOfDay(): void;
    get referenceHourOfDayInput(): number | undefined;
    private _referenceMinuteOfHour?;
    get referenceMinuteOfHour(): number;
    set referenceMinuteOfHour(value: number);
    resetReferenceMinuteOfHour(): void;
    get referenceMinuteOfHourInput(): number | undefined;
    private _restoreWindowDays?;
    get restoreWindowDays(): number;
    set restoreWindowDays(value: number);
    resetRestoreWindowDays(): void;
    get restoreWindowDaysInput(): number | undefined;
    private _updateSnapshots?;
    get updateSnapshots(): boolean | cdktf.IResolvable;
    set updateSnapshots(value: boolean | cdktf.IResolvable);
    resetUpdateSnapshots(): void;
    get updateSnapshotsInput(): boolean | cdktf.IResolvable | undefined;
    private _policies;
    get policies(): CloudProviderSnapshotBackupPolicyPoliciesList;
    putPolicies(value: CloudProviderSnapshotBackupPolicyPolicies[] | cdktf.IResolvable): void;
    get policiesInput(): cdktf.IResolvable | CloudProviderSnapshotBackupPolicyPolicies[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
