import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ClusterConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cluster#auto_scaling_compute_enabled Cluster#auto_scaling_compute_enabled}
    */
    readonly autoScalingComputeEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cluster#auto_scaling_compute_scale_down_enabled Cluster#auto_scaling_compute_scale_down_enabled}
    */
    readonly autoScalingComputeScaleDownEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cluster#auto_scaling_disk_gb_enabled Cluster#auto_scaling_disk_gb_enabled}
    */
    readonly autoScalingDiskGbEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cluster#backing_provider_name Cluster#backing_provider_name}
    */
    readonly backingProviderName?: string;
    /**
    * Clusters running MongoDB FCV 4.2 or later and any new Atlas clusters of any type do not support this parameter
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cluster#backup_enabled Cluster#backup_enabled}
    */
    readonly backupEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cluster#bi_connector Cluster#bi_connector}
    */
    readonly biConnector?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cluster#cloud_backup Cluster#cloud_backup}
    */
    readonly cloudBackup?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cluster#cluster_type Cluster#cluster_type}
    */
    readonly clusterType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cluster#disk_size_gb Cluster#disk_size_gb}
    */
    readonly diskSizeGb?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cluster#encryption_at_rest_provider Cluster#encryption_at_rest_provider}
    */
    readonly encryptionAtRestProvider?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cluster#id Cluster#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cluster#mongo_db_major_version Cluster#mongo_db_major_version}
    */
    readonly mongoDbMajorVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cluster#name Cluster#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cluster#num_shards Cluster#num_shards}
    */
    readonly numShards?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cluster#paused Cluster#paused}
    */
    readonly paused?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cluster#pit_enabled Cluster#pit_enabled}
    */
    readonly pitEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cluster#project_id Cluster#project_id}
    */
    readonly projectId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cluster#provider_auto_scaling_compute_max_instance_size Cluster#provider_auto_scaling_compute_max_instance_size}
    */
    readonly providerAutoScalingComputeMaxInstanceSize?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cluster#provider_auto_scaling_compute_min_instance_size Cluster#provider_auto_scaling_compute_min_instance_size}
    */
    readonly providerAutoScalingComputeMinInstanceSize?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cluster#provider_backup_enabled Cluster#provider_backup_enabled}
    */
    readonly providerBackupEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cluster#provider_disk_iops Cluster#provider_disk_iops}
    */
    readonly providerDiskIops?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cluster#provider_disk_type_name Cluster#provider_disk_type_name}
    */
    readonly providerDiskTypeName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cluster#provider_encrypt_ebs_volume Cluster#provider_encrypt_ebs_volume}
    */
    readonly providerEncryptEbsVolume?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cluster#provider_instance_size_name Cluster#provider_instance_size_name}
    */
    readonly providerInstanceSizeName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cluster#provider_name Cluster#provider_name}
    */
    readonly providerName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cluster#provider_region_name Cluster#provider_region_name}
    */
    readonly providerRegionName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cluster#provider_volume_type Cluster#provider_volume_type}
    */
    readonly providerVolumeType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cluster#replication_factor Cluster#replication_factor}
    */
    readonly replicationFactor?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cluster#termination_protection_enabled Cluster#termination_protection_enabled}
    */
    readonly terminationProtectionEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cluster#version_release_system Cluster#version_release_system}
    */
    readonly versionReleaseSystem?: string;
    /**
    * advanced_configuration block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cluster#advanced_configuration Cluster#advanced_configuration}
    */
    readonly advancedConfiguration?: ClusterAdvancedConfiguration;
    /**
    * bi_connector_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cluster#bi_connector_config Cluster#bi_connector_config}
    */
    readonly biConnectorConfig?: ClusterBiConnectorConfig;
    /**
    * labels block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cluster#labels Cluster#labels}
    */
    readonly labels?: ClusterLabels[] | cdktf.IResolvable;
    /**
    * replication_specs block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cluster#replication_specs Cluster#replication_specs}
    */
    readonly replicationSpecs?: ClusterReplicationSpecs[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cluster#timeouts Cluster#timeouts}
    */
    readonly timeouts?: ClusterTimeouts;
}
export interface ClusterConnectionStringsPrivateEndpointEndpoints {
}
export declare function clusterConnectionStringsPrivateEndpointEndpointsToTerraform(struct?: ClusterConnectionStringsPrivateEndpointEndpoints): any;
export declare class ClusterConnectionStringsPrivateEndpointEndpointsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ClusterConnectionStringsPrivateEndpointEndpoints | undefined;
    set internalValue(value: ClusterConnectionStringsPrivateEndpointEndpoints | undefined);
    get endpointId(): string;
    get providerName(): string;
    get region(): string;
}
export declare class ClusterConnectionStringsPrivateEndpointEndpointsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ClusterConnectionStringsPrivateEndpointEndpointsOutputReference;
}
export interface ClusterConnectionStringsPrivateEndpoint {
}
export declare function clusterConnectionStringsPrivateEndpointToTerraform(struct?: ClusterConnectionStringsPrivateEndpoint): any;
export declare class ClusterConnectionStringsPrivateEndpointOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ClusterConnectionStringsPrivateEndpoint | undefined;
    set internalValue(value: ClusterConnectionStringsPrivateEndpoint | undefined);
    get connectionString(): string;
    private _endpoints;
    get endpoints(): ClusterConnectionStringsPrivateEndpointEndpointsList;
    get srvConnectionString(): string;
    get type(): string;
}
export declare class ClusterConnectionStringsPrivateEndpointList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ClusterConnectionStringsPrivateEndpointOutputReference;
}
export interface ClusterConnectionStrings {
}
export declare function clusterConnectionStringsToTerraform(struct?: ClusterConnectionStrings): any;
export declare class ClusterConnectionStringsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ClusterConnectionStrings | undefined;
    set internalValue(value: ClusterConnectionStrings | undefined);
    private _awsPrivateLink;
    get awsPrivateLink(): cdktf.StringMap;
    private _awsPrivateLinkSrv;
    get awsPrivateLinkSrv(): cdktf.StringMap;
    get private(): string;
    private _privateEndpoint;
    get privateEndpoint(): ClusterConnectionStringsPrivateEndpointList;
    get privateSrv(): string;
    get standard(): string;
    get standardSrv(): string;
}
export declare class ClusterConnectionStringsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ClusterConnectionStringsOutputReference;
}
export interface ClusterSnapshotBackupPolicyPoliciesPolicyItem {
}
export declare function clusterSnapshotBackupPolicyPoliciesPolicyItemToTerraform(struct?: ClusterSnapshotBackupPolicyPoliciesPolicyItem): any;
export declare class ClusterSnapshotBackupPolicyPoliciesPolicyItemOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ClusterSnapshotBackupPolicyPoliciesPolicyItem | undefined;
    set internalValue(value: ClusterSnapshotBackupPolicyPoliciesPolicyItem | undefined);
    get frequencyInterval(): number;
    get frequencyType(): string;
    get id(): string;
    get retentionUnit(): string;
    get retentionValue(): number;
}
export declare class ClusterSnapshotBackupPolicyPoliciesPolicyItemList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ClusterSnapshotBackupPolicyPoliciesPolicyItemOutputReference;
}
export interface ClusterSnapshotBackupPolicyPolicies {
}
export declare function clusterSnapshotBackupPolicyPoliciesToTerraform(struct?: ClusterSnapshotBackupPolicyPolicies): any;
export declare class ClusterSnapshotBackupPolicyPoliciesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ClusterSnapshotBackupPolicyPolicies | undefined;
    set internalValue(value: ClusterSnapshotBackupPolicyPolicies | undefined);
    get id(): string;
    private _policyItem;
    get policyItem(): ClusterSnapshotBackupPolicyPoliciesPolicyItemList;
}
export declare class ClusterSnapshotBackupPolicyPoliciesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ClusterSnapshotBackupPolicyPoliciesOutputReference;
}
export interface ClusterSnapshotBackupPolicy {
}
export declare function clusterSnapshotBackupPolicyToTerraform(struct?: ClusterSnapshotBackupPolicy): any;
export declare class ClusterSnapshotBackupPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ClusterSnapshotBackupPolicy | undefined;
    set internalValue(value: ClusterSnapshotBackupPolicy | undefined);
    get clusterId(): string;
    get clusterName(): string;
    get nextSnapshot(): string;
    private _policies;
    get policies(): ClusterSnapshotBackupPolicyPoliciesList;
    get referenceHourOfDay(): number;
    get referenceMinuteOfHour(): number;
    get restoreWindowDays(): number;
    get updateSnapshots(): cdktf.IResolvable;
}
export declare class ClusterSnapshotBackupPolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ClusterSnapshotBackupPolicyOutputReference;
}
export interface ClusterAdvancedConfiguration {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cluster#default_read_concern Cluster#default_read_concern}
    */
    readonly defaultReadConcern?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cluster#default_write_concern Cluster#default_write_concern}
    */
    readonly defaultWriteConcern?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cluster#fail_index_key_too_long Cluster#fail_index_key_too_long}
    */
    readonly failIndexKeyTooLong?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cluster#javascript_enabled Cluster#javascript_enabled}
    */
    readonly javascriptEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cluster#minimum_enabled_tls_protocol Cluster#minimum_enabled_tls_protocol}
    */
    readonly minimumEnabledTlsProtocol?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cluster#no_table_scan Cluster#no_table_scan}
    */
    readonly noTableScan?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cluster#oplog_min_retention_hours Cluster#oplog_min_retention_hours}
    */
    readonly oplogMinRetentionHours?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cluster#oplog_size_mb Cluster#oplog_size_mb}
    */
    readonly oplogSizeMb?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cluster#sample_refresh_interval_bi_connector Cluster#sample_refresh_interval_bi_connector}
    */
    readonly sampleRefreshIntervalBiConnector?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cluster#sample_size_bi_connector Cluster#sample_size_bi_connector}
    */
    readonly sampleSizeBiConnector?: number;
}
export declare function clusterAdvancedConfigurationToTerraform(struct?: ClusterAdvancedConfigurationOutputReference | ClusterAdvancedConfiguration): any;
export declare class ClusterAdvancedConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ClusterAdvancedConfiguration | undefined;
    set internalValue(value: ClusterAdvancedConfiguration | undefined);
    private _defaultReadConcern?;
    get defaultReadConcern(): string;
    set defaultReadConcern(value: string);
    resetDefaultReadConcern(): void;
    get defaultReadConcernInput(): string | undefined;
    private _defaultWriteConcern?;
    get defaultWriteConcern(): string;
    set defaultWriteConcern(value: string);
    resetDefaultWriteConcern(): void;
    get defaultWriteConcernInput(): string | undefined;
    private _failIndexKeyTooLong?;
    get failIndexKeyTooLong(): boolean | cdktf.IResolvable;
    set failIndexKeyTooLong(value: boolean | cdktf.IResolvable);
    resetFailIndexKeyTooLong(): void;
    get failIndexKeyTooLongInput(): boolean | cdktf.IResolvable | undefined;
    private _javascriptEnabled?;
    get javascriptEnabled(): boolean | cdktf.IResolvable;
    set javascriptEnabled(value: boolean | cdktf.IResolvable);
    resetJavascriptEnabled(): void;
    get javascriptEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _minimumEnabledTlsProtocol?;
    get minimumEnabledTlsProtocol(): string;
    set minimumEnabledTlsProtocol(value: string);
    resetMinimumEnabledTlsProtocol(): void;
    get minimumEnabledTlsProtocolInput(): string | undefined;
    private _noTableScan?;
    get noTableScan(): boolean | cdktf.IResolvable;
    set noTableScan(value: boolean | cdktf.IResolvable);
    resetNoTableScan(): void;
    get noTableScanInput(): boolean | cdktf.IResolvable | undefined;
    private _oplogMinRetentionHours?;
    get oplogMinRetentionHours(): number;
    set oplogMinRetentionHours(value: number);
    resetOplogMinRetentionHours(): void;
    get oplogMinRetentionHoursInput(): number | undefined;
    private _oplogSizeMb?;
    get oplogSizeMb(): number;
    set oplogSizeMb(value: number);
    resetOplogSizeMb(): void;
    get oplogSizeMbInput(): number | undefined;
    private _sampleRefreshIntervalBiConnector?;
    get sampleRefreshIntervalBiConnector(): number;
    set sampleRefreshIntervalBiConnector(value: number);
    resetSampleRefreshIntervalBiConnector(): void;
    get sampleRefreshIntervalBiConnectorInput(): number | undefined;
    private _sampleSizeBiConnector?;
    get sampleSizeBiConnector(): number;
    set sampleSizeBiConnector(value: number);
    resetSampleSizeBiConnector(): void;
    get sampleSizeBiConnectorInput(): number | undefined;
}
export interface ClusterBiConnectorConfig {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cluster#enabled Cluster#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cluster#read_preference Cluster#read_preference}
    */
    readonly readPreference?: string;
}
export declare function clusterBiConnectorConfigToTerraform(struct?: ClusterBiConnectorConfigOutputReference | ClusterBiConnectorConfig): any;
export declare class ClusterBiConnectorConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ClusterBiConnectorConfig | undefined;
    set internalValue(value: ClusterBiConnectorConfig | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _readPreference?;
    get readPreference(): string;
    set readPreference(value: string);
    resetReadPreference(): void;
    get readPreferenceInput(): string | undefined;
}
export interface ClusterLabels {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cluster#key Cluster#key}
    */
    readonly key?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cluster#value Cluster#value}
    */
    readonly value?: string;
}
export declare function clusterLabelsToTerraform(struct?: ClusterLabels | cdktf.IResolvable): any;
export declare class ClusterLabelsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ClusterLabels | cdktf.IResolvable | undefined;
    set internalValue(value: ClusterLabels | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class ClusterLabelsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ClusterLabels[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ClusterLabelsOutputReference;
}
export interface ClusterReplicationSpecsRegionsConfig {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cluster#analytics_nodes Cluster#analytics_nodes}
    */
    readonly analyticsNodes?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cluster#electable_nodes Cluster#electable_nodes}
    */
    readonly electableNodes?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cluster#priority Cluster#priority}
    */
    readonly priority?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cluster#read_only_nodes Cluster#read_only_nodes}
    */
    readonly readOnlyNodes?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cluster#region_name Cluster#region_name}
    */
    readonly regionName: string;
}
export declare function clusterReplicationSpecsRegionsConfigToTerraform(struct?: ClusterReplicationSpecsRegionsConfig | cdktf.IResolvable): any;
export declare class ClusterReplicationSpecsRegionsConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ClusterReplicationSpecsRegionsConfig | cdktf.IResolvable | undefined;
    set internalValue(value: ClusterReplicationSpecsRegionsConfig | cdktf.IResolvable | undefined);
    private _analyticsNodes?;
    get analyticsNodes(): number;
    set analyticsNodes(value: number);
    resetAnalyticsNodes(): void;
    get analyticsNodesInput(): number | undefined;
    private _electableNodes?;
    get electableNodes(): number;
    set electableNodes(value: number);
    resetElectableNodes(): void;
    get electableNodesInput(): number | undefined;
    private _priority?;
    get priority(): number;
    set priority(value: number);
    resetPriority(): void;
    get priorityInput(): number | undefined;
    private _readOnlyNodes?;
    get readOnlyNodes(): number;
    set readOnlyNodes(value: number);
    resetReadOnlyNodes(): void;
    get readOnlyNodesInput(): number | undefined;
    private _regionName?;
    get regionName(): string;
    set regionName(value: string);
    get regionNameInput(): string | undefined;
}
export declare class ClusterReplicationSpecsRegionsConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ClusterReplicationSpecsRegionsConfig[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ClusterReplicationSpecsRegionsConfigOutputReference;
}
export interface ClusterReplicationSpecs {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cluster#id Cluster#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cluster#num_shards Cluster#num_shards}
    */
    readonly numShards: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cluster#zone_name Cluster#zone_name}
    */
    readonly zoneName?: string;
    /**
    * regions_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cluster#regions_config Cluster#regions_config}
    */
    readonly regionsConfig?: ClusterReplicationSpecsRegionsConfig[] | cdktf.IResolvable;
}
export declare function clusterReplicationSpecsToTerraform(struct?: ClusterReplicationSpecs | cdktf.IResolvable): any;
export declare class ClusterReplicationSpecsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ClusterReplicationSpecs | cdktf.IResolvable | undefined;
    set internalValue(value: ClusterReplicationSpecs | cdktf.IResolvable | undefined);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _numShards?;
    get numShards(): number;
    set numShards(value: number);
    get numShardsInput(): number | undefined;
    private _zoneName?;
    get zoneName(): string;
    set zoneName(value: string);
    resetZoneName(): void;
    get zoneNameInput(): string | undefined;
    private _regionsConfig;
    get regionsConfig(): ClusterReplicationSpecsRegionsConfigList;
    putRegionsConfig(value: ClusterReplicationSpecsRegionsConfig[] | cdktf.IResolvable): void;
    resetRegionsConfig(): void;
    get regionsConfigInput(): cdktf.IResolvable | ClusterReplicationSpecsRegionsConfig[] | undefined;
}
export declare class ClusterReplicationSpecsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ClusterReplicationSpecs[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ClusterReplicationSpecsOutputReference;
}
export interface ClusterTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cluster#create Cluster#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cluster#delete Cluster#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cluster#update Cluster#update}
    */
    readonly update?: string;
}
export declare function clusterTimeoutsToTerraform(struct?: ClusterTimeoutsOutputReference | ClusterTimeouts | cdktf.IResolvable): any;
export declare class ClusterTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ClusterTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ClusterTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cluster mongodbatlas_cluster}
*/
export declare class Cluster extends cdktf.TerraformResource {
    static readonly tfResourceType = "mongodbatlas_cluster";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/mongodbatlas/r/cluster mongodbatlas_cluster} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ClusterConfig
    */
    constructor(scope: Construct, id: string, config: ClusterConfig);
    private _autoScalingComputeEnabled?;
    get autoScalingComputeEnabled(): boolean | cdktf.IResolvable;
    set autoScalingComputeEnabled(value: boolean | cdktf.IResolvable);
    resetAutoScalingComputeEnabled(): void;
    get autoScalingComputeEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _autoScalingComputeScaleDownEnabled?;
    get autoScalingComputeScaleDownEnabled(): boolean | cdktf.IResolvable;
    set autoScalingComputeScaleDownEnabled(value: boolean | cdktf.IResolvable);
    resetAutoScalingComputeScaleDownEnabled(): void;
    get autoScalingComputeScaleDownEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _autoScalingDiskGbEnabled?;
    get autoScalingDiskGbEnabled(): boolean | cdktf.IResolvable;
    set autoScalingDiskGbEnabled(value: boolean | cdktf.IResolvable);
    resetAutoScalingDiskGbEnabled(): void;
    get autoScalingDiskGbEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _backingProviderName?;
    get backingProviderName(): string;
    set backingProviderName(value: string);
    resetBackingProviderName(): void;
    get backingProviderNameInput(): string | undefined;
    private _backupEnabled?;
    get backupEnabled(): boolean | cdktf.IResolvable;
    set backupEnabled(value: boolean | cdktf.IResolvable);
    resetBackupEnabled(): void;
    get backupEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _biConnector?;
    get biConnector(): {
        [key: string]: string;
    };
    set biConnector(value: {
        [key: string]: string;
    });
    resetBiConnector(): void;
    get biConnectorInput(): {
        [key: string]: string;
    } | undefined;
    private _cloudBackup?;
    get cloudBackup(): boolean | cdktf.IResolvable;
    set cloudBackup(value: boolean | cdktf.IResolvable);
    resetCloudBackup(): void;
    get cloudBackupInput(): boolean | cdktf.IResolvable | undefined;
    get clusterId(): string;
    private _clusterType?;
    get clusterType(): string;
    set clusterType(value: string);
    resetClusterType(): void;
    get clusterTypeInput(): string | undefined;
    private _connectionStrings;
    get connectionStrings(): ClusterConnectionStringsList;
    get containerId(): string;
    private _diskSizeGb?;
    get diskSizeGb(): number;
    set diskSizeGb(value: number);
    resetDiskSizeGb(): void;
    get diskSizeGbInput(): number | undefined;
    private _encryptionAtRestProvider?;
    get encryptionAtRestProvider(): string;
    set encryptionAtRestProvider(value: string);
    resetEncryptionAtRestProvider(): void;
    get encryptionAtRestProviderInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _mongoDbMajorVersion?;
    get mongoDbMajorVersion(): string;
    set mongoDbMajorVersion(value: string);
    resetMongoDbMajorVersion(): void;
    get mongoDbMajorVersionInput(): string | undefined;
    get mongoDbVersion(): string;
    get mongoUri(): string;
    get mongoUriUpdated(): string;
    get mongoUriWithOptions(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _numShards?;
    get numShards(): number;
    set numShards(value: number);
    resetNumShards(): void;
    get numShardsInput(): number | undefined;
    private _paused?;
    get paused(): boolean | cdktf.IResolvable;
    set paused(value: boolean | cdktf.IResolvable);
    resetPaused(): void;
    get pausedInput(): boolean | cdktf.IResolvable | undefined;
    private _pitEnabled?;
    get pitEnabled(): boolean | cdktf.IResolvable;
    set pitEnabled(value: boolean | cdktf.IResolvable);
    resetPitEnabled(): void;
    get pitEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
    private _providerAutoScalingComputeMaxInstanceSize?;
    get providerAutoScalingComputeMaxInstanceSize(): string;
    set providerAutoScalingComputeMaxInstanceSize(value: string);
    resetProviderAutoScalingComputeMaxInstanceSize(): void;
    get providerAutoScalingComputeMaxInstanceSizeInput(): string | undefined;
    private _providerAutoScalingComputeMinInstanceSize?;
    get providerAutoScalingComputeMinInstanceSize(): string;
    set providerAutoScalingComputeMinInstanceSize(value: string);
    resetProviderAutoScalingComputeMinInstanceSize(): void;
    get providerAutoScalingComputeMinInstanceSizeInput(): string | undefined;
    private _providerBackupEnabled?;
    get providerBackupEnabled(): boolean | cdktf.IResolvable;
    set providerBackupEnabled(value: boolean | cdktf.IResolvable);
    resetProviderBackupEnabled(): void;
    get providerBackupEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _providerDiskIops?;
    get providerDiskIops(): number;
    set providerDiskIops(value: number);
    resetProviderDiskIops(): void;
    get providerDiskIopsInput(): number | undefined;
    private _providerDiskTypeName?;
    get providerDiskTypeName(): string;
    set providerDiskTypeName(value: string);
    resetProviderDiskTypeName(): void;
    get providerDiskTypeNameInput(): string | undefined;
    private _providerEncryptEbsVolume?;
    get providerEncryptEbsVolume(): boolean | cdktf.IResolvable;
    set providerEncryptEbsVolume(value: boolean | cdktf.IResolvable);
    resetProviderEncryptEbsVolume(): void;
    get providerEncryptEbsVolumeInput(): boolean | cdktf.IResolvable | undefined;
    get providerEncryptEbsVolumeFlag(): cdktf.IResolvable;
    private _providerInstanceSizeName?;
    get providerInstanceSizeName(): string;
    set providerInstanceSizeName(value: string);
    get providerInstanceSizeNameInput(): string | undefined;
    private _providerName?;
    get providerName(): string;
    set providerName(value: string);
    get providerNameInput(): string | undefined;
    private _providerRegionName?;
    get providerRegionName(): string;
    set providerRegionName(value: string);
    resetProviderRegionName(): void;
    get providerRegionNameInput(): string | undefined;
    private _providerVolumeType?;
    get providerVolumeType(): string;
    set providerVolumeType(value: string);
    resetProviderVolumeType(): void;
    get providerVolumeTypeInput(): string | undefined;
    private _replicationFactor?;
    get replicationFactor(): number;
    set replicationFactor(value: number);
    resetReplicationFactor(): void;
    get replicationFactorInput(): number | undefined;
    private _snapshotBackupPolicy;
    get snapshotBackupPolicy(): ClusterSnapshotBackupPolicyList;
    get srvAddress(): string;
    get stateName(): string;
    private _terminationProtectionEnabled?;
    get terminationProtectionEnabled(): boolean | cdktf.IResolvable;
    set terminationProtectionEnabled(value: boolean | cdktf.IResolvable);
    resetTerminationProtectionEnabled(): void;
    get terminationProtectionEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _versionReleaseSystem?;
    get versionReleaseSystem(): string;
    set versionReleaseSystem(value: string);
    resetVersionReleaseSystem(): void;
    get versionReleaseSystemInput(): string | undefined;
    private _advancedConfiguration;
    get advancedConfiguration(): ClusterAdvancedConfigurationOutputReference;
    putAdvancedConfiguration(value: ClusterAdvancedConfiguration): void;
    resetAdvancedConfiguration(): void;
    get advancedConfigurationInput(): ClusterAdvancedConfiguration | undefined;
    private _biConnectorConfig;
    get biConnectorConfig(): ClusterBiConnectorConfigOutputReference;
    putBiConnectorConfig(value: ClusterBiConnectorConfig): void;
    resetBiConnectorConfig(): void;
    get biConnectorConfigInput(): ClusterBiConnectorConfig | undefined;
    private _labels;
    get labels(): ClusterLabelsList;
    putLabels(value: ClusterLabels[] | cdktf.IResolvable): void;
    resetLabels(): void;
    get labelsInput(): cdktf.IResolvable | ClusterLabels[] | undefined;
    private _replicationSpecs;
    get replicationSpecs(): ClusterReplicationSpecsList;
    putReplicationSpecs(value: ClusterReplicationSpecs[] | cdktf.IResolvable): void;
    resetReplicationSpecs(): void;
    get replicationSpecsInput(): cdktf.IResolvable | ClusterReplicationSpecs[] | undefined;
    private _timeouts;
    get timeouts(): ClusterTimeoutsOutputReference;
    putTimeouts(value: ClusterTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ClusterTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
