import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CustomDbRoleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/custom_db_role#id CustomDbRole#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/custom_db_role#project_id CustomDbRole#project_id}
    */
    readonly projectId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/custom_db_role#role_name CustomDbRole#role_name}
    */
    readonly roleName: string;
    /**
    * actions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/custom_db_role#actions CustomDbRole#actions}
    */
    readonly actions?: CustomDbRoleActions[] | cdktf.IResolvable;
    /**
    * inherited_roles block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/custom_db_role#inherited_roles CustomDbRole#inherited_roles}
    */
    readonly inheritedRoles?: CustomDbRoleInheritedRoles[] | cdktf.IResolvable;
}
export interface CustomDbRoleActionsResources {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/custom_db_role#cluster CustomDbRole#cluster}
    */
    readonly cluster?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/custom_db_role#collection_name CustomDbRole#collection_name}
    */
    readonly collectionName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/custom_db_role#database_name CustomDbRole#database_name}
    */
    readonly databaseName?: string;
}
export declare function customDbRoleActionsResourcesToTerraform(struct?: CustomDbRoleActionsResources | cdktf.IResolvable): any;
export declare class CustomDbRoleActionsResourcesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CustomDbRoleActionsResources | cdktf.IResolvable | undefined;
    set internalValue(value: CustomDbRoleActionsResources | cdktf.IResolvable | undefined);
    private _cluster?;
    get cluster(): boolean | cdktf.IResolvable;
    set cluster(value: boolean | cdktf.IResolvable);
    resetCluster(): void;
    get clusterInput(): boolean | cdktf.IResolvable | undefined;
    private _collectionName?;
    get collectionName(): string;
    set collectionName(value: string);
    resetCollectionName(): void;
    get collectionNameInput(): string | undefined;
    private _databaseName?;
    get databaseName(): string;
    set databaseName(value: string);
    resetDatabaseName(): void;
    get databaseNameInput(): string | undefined;
}
export declare class CustomDbRoleActionsResourcesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CustomDbRoleActionsResources[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CustomDbRoleActionsResourcesOutputReference;
}
export interface CustomDbRoleActions {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/custom_db_role#action CustomDbRole#action}
    */
    readonly action: string;
    /**
    * resources block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/custom_db_role#resources CustomDbRole#resources}
    */
    readonly resources: CustomDbRoleActionsResources[] | cdktf.IResolvable;
}
export declare function customDbRoleActionsToTerraform(struct?: CustomDbRoleActions | cdktf.IResolvable): any;
export declare class CustomDbRoleActionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CustomDbRoleActions | cdktf.IResolvable | undefined;
    set internalValue(value: CustomDbRoleActions | cdktf.IResolvable | undefined);
    private _action?;
    get action(): string;
    set action(value: string);
    get actionInput(): string | undefined;
    private _resources;
    get resources(): CustomDbRoleActionsResourcesList;
    putResources(value: CustomDbRoleActionsResources[] | cdktf.IResolvable): void;
    get resourcesInput(): cdktf.IResolvable | CustomDbRoleActionsResources[] | undefined;
}
export declare class CustomDbRoleActionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CustomDbRoleActions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CustomDbRoleActionsOutputReference;
}
export interface CustomDbRoleInheritedRoles {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/custom_db_role#database_name CustomDbRole#database_name}
    */
    readonly databaseName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/custom_db_role#role_name CustomDbRole#role_name}
    */
    readonly roleName: string;
}
export declare function customDbRoleInheritedRolesToTerraform(struct?: CustomDbRoleInheritedRoles | cdktf.IResolvable): any;
export declare class CustomDbRoleInheritedRolesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CustomDbRoleInheritedRoles | cdktf.IResolvable | undefined;
    set internalValue(value: CustomDbRoleInheritedRoles | cdktf.IResolvable | undefined);
    private _databaseName?;
    get databaseName(): string;
    set databaseName(value: string);
    get databaseNameInput(): string | undefined;
    private _roleName?;
    get roleName(): string;
    set roleName(value: string);
    get roleNameInput(): string | undefined;
}
export declare class CustomDbRoleInheritedRolesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CustomDbRoleInheritedRoles[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CustomDbRoleInheritedRolesOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/mongodbatlas/r/custom_db_role mongodbatlas_custom_db_role}
*/
export declare class CustomDbRole extends cdktf.TerraformResource {
    static readonly tfResourceType = "mongodbatlas_custom_db_role";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/mongodbatlas/r/custom_db_role mongodbatlas_custom_db_role} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CustomDbRoleConfig
    */
    constructor(scope: Construct, id: string, config: CustomDbRoleConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
    private _roleName?;
    get roleName(): string;
    set roleName(value: string);
    get roleNameInput(): string | undefined;
    private _actions;
    get actions(): CustomDbRoleActionsList;
    putActions(value: CustomDbRoleActions[] | cdktf.IResolvable): void;
    resetActions(): void;
    get actionsInput(): cdktf.IResolvable | CustomDbRoleActions[] | undefined;
    private _inheritedRoles;
    get inheritedRoles(): CustomDbRoleInheritedRolesList;
    putInheritedRoles(value: CustomDbRoleInheritedRoles[] | cdktf.IResolvable): void;
    resetInheritedRoles(): void;
    get inheritedRolesInput(): cdktf.IResolvable | CustomDbRoleInheritedRoles[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
