import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataLakeConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/data_lake#id DataLake#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/data_lake#name DataLake#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/data_lake#project_id DataLake#project_id}
    */
    readonly projectId: string;
    /**
    * aws block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/data_lake#aws DataLake#aws}
    */
    readonly aws: DataLakeAws;
    /**
    * data_process_region block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/data_lake#data_process_region DataLake#data_process_region}
    */
    readonly dataProcessRegion?: DataLakeDataProcessRegion;
}
export interface DataLakeStorageDatabasesCollectionsDataSources {
}
export declare function dataLakeStorageDatabasesCollectionsDataSourcesToTerraform(struct?: DataLakeStorageDatabasesCollectionsDataSources): any;
export declare class DataLakeStorageDatabasesCollectionsDataSourcesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataLakeStorageDatabasesCollectionsDataSources | undefined;
    set internalValue(value: DataLakeStorageDatabasesCollectionsDataSources | undefined);
    get defaultFormat(): string;
    get path(): string;
    get storeName(): string;
}
export declare class DataLakeStorageDatabasesCollectionsDataSourcesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataLakeStorageDatabasesCollectionsDataSourcesOutputReference;
}
export interface DataLakeStorageDatabasesCollections {
}
export declare function dataLakeStorageDatabasesCollectionsToTerraform(struct?: DataLakeStorageDatabasesCollections): any;
export declare class DataLakeStorageDatabasesCollectionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataLakeStorageDatabasesCollections | undefined;
    set internalValue(value: DataLakeStorageDatabasesCollections | undefined);
    private _dataSources;
    get dataSources(): DataLakeStorageDatabasesCollectionsDataSourcesList;
    get name(): string;
}
export declare class DataLakeStorageDatabasesCollectionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataLakeStorageDatabasesCollectionsOutputReference;
}
export interface DataLakeStorageDatabasesViews {
}
export declare function dataLakeStorageDatabasesViewsToTerraform(struct?: DataLakeStorageDatabasesViews): any;
export declare class DataLakeStorageDatabasesViewsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataLakeStorageDatabasesViews | undefined;
    set internalValue(value: DataLakeStorageDatabasesViews | undefined);
    get name(): string;
    get pipeline(): string;
    get source(): string;
}
export declare class DataLakeStorageDatabasesViewsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataLakeStorageDatabasesViewsOutputReference;
}
export interface DataLakeStorageDatabases {
}
export declare function dataLakeStorageDatabasesToTerraform(struct?: DataLakeStorageDatabases): any;
export declare class DataLakeStorageDatabasesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataLakeStorageDatabases | undefined;
    set internalValue(value: DataLakeStorageDatabases | undefined);
    private _collections;
    get collections(): DataLakeStorageDatabasesCollectionsList;
    get maxWildcardCollections(): number;
    get name(): string;
    private _views;
    get views(): DataLakeStorageDatabasesViewsList;
}
export declare class DataLakeStorageDatabasesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataLakeStorageDatabasesOutputReference;
}
export interface DataLakeStorageStores {
}
export declare function dataLakeStorageStoresToTerraform(struct?: DataLakeStorageStores): any;
export declare class DataLakeStorageStoresOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataLakeStorageStores | undefined;
    set internalValue(value: DataLakeStorageStores | undefined);
    get additionalStorageClasses(): string[];
    get bucket(): string;
    get delimiter(): string;
    get includeTags(): cdktf.IResolvable;
    get name(): string;
    get prefix(): string;
    get provider(): string;
    get region(): string;
}
export declare class DataLakeStorageStoresList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataLakeStorageStoresOutputReference;
}
export interface DataLakeAws {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/data_lake#role_id DataLake#role_id}
    */
    readonly roleId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/data_lake#test_s3_bucket DataLake#test_s3_bucket}
    */
    readonly testS3Bucket: string;
}
export declare function dataLakeAwsToTerraform(struct?: DataLakeAwsOutputReference | DataLakeAws): any;
export declare class DataLakeAwsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataLakeAws | undefined;
    set internalValue(value: DataLakeAws | undefined);
    get externalId(): string;
    get iamAssumedRoleArn(): string;
    get iamUserArn(): string;
    private _roleId?;
    get roleId(): string;
    set roleId(value: string);
    get roleIdInput(): string | undefined;
    private _testS3Bucket?;
    get testS3Bucket(): string;
    set testS3Bucket(value: string);
    get testS3BucketInput(): string | undefined;
}
export interface DataLakeDataProcessRegion {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/data_lake#cloud_provider DataLake#cloud_provider}
    */
    readonly cloudProvider: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/data_lake#region DataLake#region}
    */
    readonly region: string;
}
export declare function dataLakeDataProcessRegionToTerraform(struct?: DataLakeDataProcessRegionOutputReference | DataLakeDataProcessRegion): any;
export declare class DataLakeDataProcessRegionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataLakeDataProcessRegion | undefined;
    set internalValue(value: DataLakeDataProcessRegion | undefined);
    private _cloudProvider?;
    get cloudProvider(): string;
    set cloudProvider(value: string);
    get cloudProviderInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    get regionInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/mongodbatlas/r/data_lake mongodbatlas_data_lake}
*/
export declare class DataLake extends cdktf.TerraformResource {
    static readonly tfResourceType = "mongodbatlas_data_lake";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/mongodbatlas/r/data_lake mongodbatlas_data_lake} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataLakeConfig
    */
    constructor(scope: Construct, id: string, config: DataLakeConfig);
    get hostnames(): string[];
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
    get state(): string;
    private _storageDatabases;
    get storageDatabases(): DataLakeStorageDatabasesList;
    private _storageStores;
    get storageStores(): DataLakeStorageStoresList;
    private _aws;
    get aws(): DataLakeAwsOutputReference;
    putAws(value: DataLakeAws): void;
    get awsInput(): DataLakeAws | undefined;
    private _dataProcessRegion;
    get dataProcessRegion(): DataLakeDataProcessRegionOutputReference;
    putDataProcessRegion(value: DataLakeDataProcessRegion): void;
    resetDataProcessRegion(): void;
    get dataProcessRegionInput(): DataLakeDataProcessRegion | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
