import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataMongodbatlasAdvancedClusterConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/advanced_cluster#id DataMongodbatlasAdvancedCluster#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/advanced_cluster#name DataMongodbatlasAdvancedCluster#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/advanced_cluster#pit_enabled DataMongodbatlasAdvancedCluster#pit_enabled}
    */
    readonly pitEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/advanced_cluster#project_id DataMongodbatlasAdvancedCluster#project_id}
    */
    readonly projectId: string;
}
export interface DataMongodbatlasAdvancedClusterAdvancedConfiguration {
}
export declare function dataMongodbatlasAdvancedClusterAdvancedConfigurationToTerraform(struct?: DataMongodbatlasAdvancedClusterAdvancedConfiguration): any;
export declare class DataMongodbatlasAdvancedClusterAdvancedConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasAdvancedClusterAdvancedConfiguration | undefined;
    set internalValue(value: DataMongodbatlasAdvancedClusterAdvancedConfiguration | undefined);
    get defaultReadConcern(): string;
    get defaultWriteConcern(): string;
    get failIndexKeyTooLong(): cdktf.IResolvable;
    get javascriptEnabled(): cdktf.IResolvable;
    get minimumEnabledTlsProtocol(): string;
    get noTableScan(): cdktf.IResolvable;
    get oplogMinRetentionHours(): number;
    get oplogSizeMb(): number;
    get sampleRefreshIntervalBiConnector(): number;
    get sampleSizeBiConnector(): number;
}
export declare class DataMongodbatlasAdvancedClusterAdvancedConfigurationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasAdvancedClusterAdvancedConfigurationOutputReference;
}
export interface DataMongodbatlasAdvancedClusterBiConnectorConfig {
}
export declare function dataMongodbatlasAdvancedClusterBiConnectorConfigToTerraform(struct?: DataMongodbatlasAdvancedClusterBiConnectorConfig): any;
export declare class DataMongodbatlasAdvancedClusterBiConnectorConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasAdvancedClusterBiConnectorConfig | undefined;
    set internalValue(value: DataMongodbatlasAdvancedClusterBiConnectorConfig | undefined);
    get enabled(): cdktf.IResolvable;
    get readPreference(): string;
}
export declare class DataMongodbatlasAdvancedClusterBiConnectorConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasAdvancedClusterBiConnectorConfigOutputReference;
}
export interface DataMongodbatlasAdvancedClusterConnectionStringsPrivateEndpointEndpoints {
}
export declare function dataMongodbatlasAdvancedClusterConnectionStringsPrivateEndpointEndpointsToTerraform(struct?: DataMongodbatlasAdvancedClusterConnectionStringsPrivateEndpointEndpoints): any;
export declare class DataMongodbatlasAdvancedClusterConnectionStringsPrivateEndpointEndpointsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasAdvancedClusterConnectionStringsPrivateEndpointEndpoints | undefined;
    set internalValue(value: DataMongodbatlasAdvancedClusterConnectionStringsPrivateEndpointEndpoints | undefined);
    get endpointId(): string;
    get providerName(): string;
    get region(): string;
}
export declare class DataMongodbatlasAdvancedClusterConnectionStringsPrivateEndpointEndpointsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasAdvancedClusterConnectionStringsPrivateEndpointEndpointsOutputReference;
}
export interface DataMongodbatlasAdvancedClusterConnectionStringsPrivateEndpoint {
}
export declare function dataMongodbatlasAdvancedClusterConnectionStringsPrivateEndpointToTerraform(struct?: DataMongodbatlasAdvancedClusterConnectionStringsPrivateEndpoint): any;
export declare class DataMongodbatlasAdvancedClusterConnectionStringsPrivateEndpointOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasAdvancedClusterConnectionStringsPrivateEndpoint | undefined;
    set internalValue(value: DataMongodbatlasAdvancedClusterConnectionStringsPrivateEndpoint | undefined);
    get connectionString(): string;
    private _endpoints;
    get endpoints(): DataMongodbatlasAdvancedClusterConnectionStringsPrivateEndpointEndpointsList;
    get srvConnectionString(): string;
    get type(): string;
}
export declare class DataMongodbatlasAdvancedClusterConnectionStringsPrivateEndpointList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasAdvancedClusterConnectionStringsPrivateEndpointOutputReference;
}
export interface DataMongodbatlasAdvancedClusterConnectionStrings {
}
export declare function dataMongodbatlasAdvancedClusterConnectionStringsToTerraform(struct?: DataMongodbatlasAdvancedClusterConnectionStrings): any;
export declare class DataMongodbatlasAdvancedClusterConnectionStringsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasAdvancedClusterConnectionStrings | undefined;
    set internalValue(value: DataMongodbatlasAdvancedClusterConnectionStrings | undefined);
    private _awsPrivateLink;
    get awsPrivateLink(): cdktf.StringMap;
    private _awsPrivateLinkSrv;
    get awsPrivateLinkSrv(): cdktf.StringMap;
    get private(): string;
    private _privateEndpoint;
    get privateEndpoint(): DataMongodbatlasAdvancedClusterConnectionStringsPrivateEndpointList;
    get privateSrv(): string;
    get standard(): string;
    get standardSrv(): string;
}
export declare class DataMongodbatlasAdvancedClusterConnectionStringsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasAdvancedClusterConnectionStringsOutputReference;
}
export interface DataMongodbatlasAdvancedClusterLabels {
}
export declare function dataMongodbatlasAdvancedClusterLabelsToTerraform(struct?: DataMongodbatlasAdvancedClusterLabels): any;
export declare class DataMongodbatlasAdvancedClusterLabelsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasAdvancedClusterLabels | undefined;
    set internalValue(value: DataMongodbatlasAdvancedClusterLabels | undefined);
    get key(): string;
    get value(): string;
}
export declare class DataMongodbatlasAdvancedClusterLabelsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasAdvancedClusterLabelsOutputReference;
}
export interface DataMongodbatlasAdvancedClusterReplicationSpecsRegionConfigsAnalyticsAutoScaling {
}
export declare function dataMongodbatlasAdvancedClusterReplicationSpecsRegionConfigsAnalyticsAutoScalingToTerraform(struct?: DataMongodbatlasAdvancedClusterReplicationSpecsRegionConfigsAnalyticsAutoScaling): any;
export declare class DataMongodbatlasAdvancedClusterReplicationSpecsRegionConfigsAnalyticsAutoScalingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasAdvancedClusterReplicationSpecsRegionConfigsAnalyticsAutoScaling | undefined;
    set internalValue(value: DataMongodbatlasAdvancedClusterReplicationSpecsRegionConfigsAnalyticsAutoScaling | undefined);
    get computeEnabled(): cdktf.IResolvable;
    get computeMaxInstanceSize(): string;
    get computeMinInstanceSize(): string;
    get computeScaleDownEnabled(): cdktf.IResolvable;
    get diskGbEnabled(): cdktf.IResolvable;
}
export declare class DataMongodbatlasAdvancedClusterReplicationSpecsRegionConfigsAnalyticsAutoScalingList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasAdvancedClusterReplicationSpecsRegionConfigsAnalyticsAutoScalingOutputReference;
}
export interface DataMongodbatlasAdvancedClusterReplicationSpecsRegionConfigsAnalyticsSpecs {
}
export declare function dataMongodbatlasAdvancedClusterReplicationSpecsRegionConfigsAnalyticsSpecsToTerraform(struct?: DataMongodbatlasAdvancedClusterReplicationSpecsRegionConfigsAnalyticsSpecs): any;
export declare class DataMongodbatlasAdvancedClusterReplicationSpecsRegionConfigsAnalyticsSpecsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasAdvancedClusterReplicationSpecsRegionConfigsAnalyticsSpecs | undefined;
    set internalValue(value: DataMongodbatlasAdvancedClusterReplicationSpecsRegionConfigsAnalyticsSpecs | undefined);
    get diskIops(): number;
    get ebsVolumeType(): string;
    get instanceSize(): string;
    get nodeCount(): number;
}
export declare class DataMongodbatlasAdvancedClusterReplicationSpecsRegionConfigsAnalyticsSpecsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasAdvancedClusterReplicationSpecsRegionConfigsAnalyticsSpecsOutputReference;
}
export interface DataMongodbatlasAdvancedClusterReplicationSpecsRegionConfigsAutoScaling {
}
export declare function dataMongodbatlasAdvancedClusterReplicationSpecsRegionConfigsAutoScalingToTerraform(struct?: DataMongodbatlasAdvancedClusterReplicationSpecsRegionConfigsAutoScaling): any;
export declare class DataMongodbatlasAdvancedClusterReplicationSpecsRegionConfigsAutoScalingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasAdvancedClusterReplicationSpecsRegionConfigsAutoScaling | undefined;
    set internalValue(value: DataMongodbatlasAdvancedClusterReplicationSpecsRegionConfigsAutoScaling | undefined);
    get computeEnabled(): cdktf.IResolvable;
    get computeMaxInstanceSize(): string;
    get computeMinInstanceSize(): string;
    get computeScaleDownEnabled(): cdktf.IResolvable;
    get diskGbEnabled(): cdktf.IResolvable;
}
export declare class DataMongodbatlasAdvancedClusterReplicationSpecsRegionConfigsAutoScalingList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasAdvancedClusterReplicationSpecsRegionConfigsAutoScalingOutputReference;
}
export interface DataMongodbatlasAdvancedClusterReplicationSpecsRegionConfigsElectableSpecs {
}
export declare function dataMongodbatlasAdvancedClusterReplicationSpecsRegionConfigsElectableSpecsToTerraform(struct?: DataMongodbatlasAdvancedClusterReplicationSpecsRegionConfigsElectableSpecs): any;
export declare class DataMongodbatlasAdvancedClusterReplicationSpecsRegionConfigsElectableSpecsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasAdvancedClusterReplicationSpecsRegionConfigsElectableSpecs | undefined;
    set internalValue(value: DataMongodbatlasAdvancedClusterReplicationSpecsRegionConfigsElectableSpecs | undefined);
    get diskIops(): number;
    get ebsVolumeType(): string;
    get instanceSize(): string;
    get nodeCount(): number;
}
export declare class DataMongodbatlasAdvancedClusterReplicationSpecsRegionConfigsElectableSpecsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasAdvancedClusterReplicationSpecsRegionConfigsElectableSpecsOutputReference;
}
export interface DataMongodbatlasAdvancedClusterReplicationSpecsRegionConfigsReadOnlySpecs {
}
export declare function dataMongodbatlasAdvancedClusterReplicationSpecsRegionConfigsReadOnlySpecsToTerraform(struct?: DataMongodbatlasAdvancedClusterReplicationSpecsRegionConfigsReadOnlySpecs): any;
export declare class DataMongodbatlasAdvancedClusterReplicationSpecsRegionConfigsReadOnlySpecsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasAdvancedClusterReplicationSpecsRegionConfigsReadOnlySpecs | undefined;
    set internalValue(value: DataMongodbatlasAdvancedClusterReplicationSpecsRegionConfigsReadOnlySpecs | undefined);
    get diskIops(): number;
    get ebsVolumeType(): string;
    get instanceSize(): string;
    get nodeCount(): number;
}
export declare class DataMongodbatlasAdvancedClusterReplicationSpecsRegionConfigsReadOnlySpecsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasAdvancedClusterReplicationSpecsRegionConfigsReadOnlySpecsOutputReference;
}
export interface DataMongodbatlasAdvancedClusterReplicationSpecsRegionConfigs {
}
export declare function dataMongodbatlasAdvancedClusterReplicationSpecsRegionConfigsToTerraform(struct?: DataMongodbatlasAdvancedClusterReplicationSpecsRegionConfigs): any;
export declare class DataMongodbatlasAdvancedClusterReplicationSpecsRegionConfigsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasAdvancedClusterReplicationSpecsRegionConfigs | undefined;
    set internalValue(value: DataMongodbatlasAdvancedClusterReplicationSpecsRegionConfigs | undefined);
    private _analyticsAutoScaling;
    get analyticsAutoScaling(): DataMongodbatlasAdvancedClusterReplicationSpecsRegionConfigsAnalyticsAutoScalingList;
    private _analyticsSpecs;
    get analyticsSpecs(): DataMongodbatlasAdvancedClusterReplicationSpecsRegionConfigsAnalyticsSpecsList;
    private _autoScaling;
    get autoScaling(): DataMongodbatlasAdvancedClusterReplicationSpecsRegionConfigsAutoScalingList;
    get backingProviderName(): string;
    private _electableSpecs;
    get electableSpecs(): DataMongodbatlasAdvancedClusterReplicationSpecsRegionConfigsElectableSpecsList;
    get priority(): number;
    get providerName(): string;
    private _readOnlySpecs;
    get readOnlySpecs(): DataMongodbatlasAdvancedClusterReplicationSpecsRegionConfigsReadOnlySpecsList;
    get regionName(): string;
}
export declare class DataMongodbatlasAdvancedClusterReplicationSpecsRegionConfigsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasAdvancedClusterReplicationSpecsRegionConfigsOutputReference;
}
export interface DataMongodbatlasAdvancedClusterReplicationSpecs {
}
export declare function dataMongodbatlasAdvancedClusterReplicationSpecsToTerraform(struct?: DataMongodbatlasAdvancedClusterReplicationSpecs): any;
export declare class DataMongodbatlasAdvancedClusterReplicationSpecsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasAdvancedClusterReplicationSpecs | undefined;
    set internalValue(value: DataMongodbatlasAdvancedClusterReplicationSpecs | undefined);
    private _containerId;
    get containerId(): cdktf.StringMap;
    get id(): string;
    get numShards(): number;
    private _regionConfigs;
    get regionConfigs(): DataMongodbatlasAdvancedClusterReplicationSpecsRegionConfigsList;
    get zoneName(): string;
}
export declare class DataMongodbatlasAdvancedClusterReplicationSpecsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasAdvancedClusterReplicationSpecsOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/mongodbatlas/d/advanced_cluster mongodbatlas_advanced_cluster}
*/
export declare class DataMongodbatlasAdvancedCluster extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "mongodbatlas_advanced_cluster";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/mongodbatlas/d/advanced_cluster mongodbatlas_advanced_cluster} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataMongodbatlasAdvancedClusterConfig
    */
    constructor(scope: Construct, id: string, config: DataMongodbatlasAdvancedClusterConfig);
    private _advancedConfiguration;
    get advancedConfiguration(): DataMongodbatlasAdvancedClusterAdvancedConfigurationList;
    get backupEnabled(): cdktf.IResolvable;
    private _biConnectorConfig;
    get biConnectorConfig(): DataMongodbatlasAdvancedClusterBiConnectorConfigList;
    get clusterType(): string;
    private _connectionStrings;
    get connectionStrings(): DataMongodbatlasAdvancedClusterConnectionStringsList;
    get createDate(): string;
    get diskSizeGb(): number;
    get encryptionAtRestProvider(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels;
    get labels(): DataMongodbatlasAdvancedClusterLabelsList;
    get mongoDbMajorVersion(): string;
    get mongoDbVersion(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get paused(): cdktf.IResolvable;
    private _pitEnabled?;
    get pitEnabled(): boolean | cdktf.IResolvable;
    set pitEnabled(value: boolean | cdktf.IResolvable);
    resetPitEnabled(): void;
    get pitEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
    private _replicationSpecs;
    get replicationSpecs(): DataMongodbatlasAdvancedClusterReplicationSpecsList;
    get rootCertType(): string;
    get stateName(): string;
    get terminationProtectionEnabled(): cdktf.IResolvable;
    get versionReleaseSystem(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
