import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataMongodbatlasAlertConfigurationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/alert_configuration#alert_configuration_id DataMongodbatlasAlertConfiguration#alert_configuration_id}
    */
    readonly alertConfigurationId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/alert_configuration#id DataMongodbatlasAlertConfiguration#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/alert_configuration#project_id DataMongodbatlasAlertConfiguration#project_id}
    */
    readonly projectId: string;
    /**
    * output block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/alert_configuration#output DataMongodbatlasAlertConfiguration#output}
    */
    readonly output?: DataMongodbatlasAlertConfigurationOutput[] | cdktf.IResolvable;
}
export interface DataMongodbatlasAlertConfigurationMatcher {
}
export declare function dataMongodbatlasAlertConfigurationMatcherToTerraform(struct?: DataMongodbatlasAlertConfigurationMatcher): any;
export declare class DataMongodbatlasAlertConfigurationMatcherOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasAlertConfigurationMatcher | undefined;
    set internalValue(value: DataMongodbatlasAlertConfigurationMatcher | undefined);
    get fieldName(): string;
    get operator(): string;
    get value(): string;
}
export declare class DataMongodbatlasAlertConfigurationMatcherList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasAlertConfigurationMatcherOutputReference;
}
export interface DataMongodbatlasAlertConfigurationMetricThresholdConfig {
}
export declare function dataMongodbatlasAlertConfigurationMetricThresholdConfigToTerraform(struct?: DataMongodbatlasAlertConfigurationMetricThresholdConfig): any;
export declare class DataMongodbatlasAlertConfigurationMetricThresholdConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasAlertConfigurationMetricThresholdConfig | undefined;
    set internalValue(value: DataMongodbatlasAlertConfigurationMetricThresholdConfig | undefined);
    get metricName(): string;
    get mode(): string;
    get operator(): string;
    get threshold(): number;
    get units(): string;
}
export declare class DataMongodbatlasAlertConfigurationMetricThresholdConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasAlertConfigurationMetricThresholdConfigOutputReference;
}
export interface DataMongodbatlasAlertConfigurationNotification {
}
export declare function dataMongodbatlasAlertConfigurationNotificationToTerraform(struct?: DataMongodbatlasAlertConfigurationNotification): any;
export declare class DataMongodbatlasAlertConfigurationNotificationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasAlertConfigurationNotification | undefined;
    set internalValue(value: DataMongodbatlasAlertConfigurationNotification | undefined);
    get apiToken(): string;
    get channelName(): string;
    get datadogApiKey(): string;
    get datadogRegion(): string;
    get delayMin(): number;
    get emailAddress(): string;
    get emailEnabled(): cdktf.IResolvable;
    get flowName(): string;
    get flowdockApiToken(): string;
    get intervalMin(): number;
    get microsoftTeamsWebhookUrl(): string;
    get mobileNumber(): string;
    get opsGenieApiKey(): string;
    get opsGenieRegion(): string;
    get orgName(): string;
    get roles(): string[];
    get serviceKey(): string;
    get smsEnabled(): cdktf.IResolvable;
    get teamId(): string;
    get teamName(): string;
    get typeName(): string;
    get username(): string;
    get victorOpsApiKey(): string;
    get victorOpsRoutingKey(): string;
    get webhookSecret(): string;
    get webhookUrl(): string;
}
export declare class DataMongodbatlasAlertConfigurationNotificationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasAlertConfigurationNotificationOutputReference;
}
export interface DataMongodbatlasAlertConfigurationThresholdConfig {
}
export declare function dataMongodbatlasAlertConfigurationThresholdConfigToTerraform(struct?: DataMongodbatlasAlertConfigurationThresholdConfig): any;
export declare class DataMongodbatlasAlertConfigurationThresholdConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasAlertConfigurationThresholdConfig | undefined;
    set internalValue(value: DataMongodbatlasAlertConfigurationThresholdConfig | undefined);
    get operator(): string;
    get threshold(): number;
    get units(): string;
}
export declare class DataMongodbatlasAlertConfigurationThresholdConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasAlertConfigurationThresholdConfigOutputReference;
}
export interface DataMongodbatlasAlertConfigurationOutput {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/alert_configuration#label DataMongodbatlasAlertConfiguration#label}
    */
    readonly label?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/alert_configuration#type DataMongodbatlasAlertConfiguration#type}
    */
    readonly type: string;
}
export declare function dataMongodbatlasAlertConfigurationOutputToTerraform(struct?: DataMongodbatlasAlertConfigurationOutput | cdktf.IResolvable): any;
export declare class DataMongodbatlasAlertConfigurationOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasAlertConfigurationOutput | cdktf.IResolvable | undefined;
    set internalValue(value: DataMongodbatlasAlertConfigurationOutput | cdktf.IResolvable | undefined);
    private _label?;
    get label(): string;
    set label(value: string);
    resetLabel(): void;
    get labelInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    get value(): string;
}
export declare class DataMongodbatlasAlertConfigurationOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataMongodbatlasAlertConfigurationOutput[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasAlertConfigurationOutputOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/mongodbatlas/d/alert_configuration mongodbatlas_alert_configuration}
*/
export declare class DataMongodbatlasAlertConfiguration extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "mongodbatlas_alert_configuration";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/mongodbatlas/d/alert_configuration mongodbatlas_alert_configuration} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataMongodbatlasAlertConfigurationConfig
    */
    constructor(scope: Construct, id: string, config: DataMongodbatlasAlertConfigurationConfig);
    private _alertConfigurationId?;
    get alertConfigurationId(): string;
    set alertConfigurationId(value: string);
    get alertConfigurationIdInput(): string | undefined;
    get created(): string;
    get enabled(): cdktf.IResolvable;
    get eventType(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _matcher;
    get matcher(): DataMongodbatlasAlertConfigurationMatcherList;
    private _metricThreshold;
    get metricThreshold(): cdktf.StringMap;
    private _metricThresholdConfig;
    get metricThresholdConfig(): DataMongodbatlasAlertConfigurationMetricThresholdConfigList;
    private _notification;
    get notification(): DataMongodbatlasAlertConfigurationNotificationList;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
    private _threshold;
    get threshold(): cdktf.StringMap;
    private _thresholdConfig;
    get thresholdConfig(): DataMongodbatlasAlertConfigurationThresholdConfigList;
    get updated(): string;
    private _output;
    get output(): DataMongodbatlasAlertConfigurationOutputList;
    putOutput(value: DataMongodbatlasAlertConfigurationOutput[] | cdktf.IResolvable): void;
    resetOutput(): void;
    get outputInput(): cdktf.IResolvable | DataMongodbatlasAlertConfigurationOutput[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
