import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataMongodbatlasAlertConfigurationsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/alert_configurations#id DataMongodbatlasAlertConfigurations#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/alert_configurations#output_type DataMongodbatlasAlertConfigurations#output_type}
    */
    readonly outputType?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/alert_configurations#project_id DataMongodbatlasAlertConfigurations#project_id}
    */
    readonly projectId: string;
    /**
    * list_options block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/alert_configurations#list_options DataMongodbatlasAlertConfigurations#list_options}
    */
    readonly listOptions?: DataMongodbatlasAlertConfigurationsListOptions[] | cdktf.IResolvable;
}
export interface DataMongodbatlasAlertConfigurationsResultsMatcher {
}
export declare function dataMongodbatlasAlertConfigurationsResultsMatcherToTerraform(struct?: DataMongodbatlasAlertConfigurationsResultsMatcher): any;
export declare class DataMongodbatlasAlertConfigurationsResultsMatcherOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasAlertConfigurationsResultsMatcher | undefined;
    set internalValue(value: DataMongodbatlasAlertConfigurationsResultsMatcher | undefined);
    get fieldName(): string;
    get operator(): string;
    get value(): string;
}
export declare class DataMongodbatlasAlertConfigurationsResultsMatcherList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasAlertConfigurationsResultsMatcherOutputReference;
}
export interface DataMongodbatlasAlertConfigurationsResultsMetricThresholdConfig {
}
export declare function dataMongodbatlasAlertConfigurationsResultsMetricThresholdConfigToTerraform(struct?: DataMongodbatlasAlertConfigurationsResultsMetricThresholdConfig): any;
export declare class DataMongodbatlasAlertConfigurationsResultsMetricThresholdConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasAlertConfigurationsResultsMetricThresholdConfig | undefined;
    set internalValue(value: DataMongodbatlasAlertConfigurationsResultsMetricThresholdConfig | undefined);
    get metricName(): string;
    get mode(): string;
    get operator(): string;
    get threshold(): number;
    get units(): string;
}
export declare class DataMongodbatlasAlertConfigurationsResultsMetricThresholdConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasAlertConfigurationsResultsMetricThresholdConfigOutputReference;
}
export interface DataMongodbatlasAlertConfigurationsResultsNotification {
}
export declare function dataMongodbatlasAlertConfigurationsResultsNotificationToTerraform(struct?: DataMongodbatlasAlertConfigurationsResultsNotification): any;
export declare class DataMongodbatlasAlertConfigurationsResultsNotificationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasAlertConfigurationsResultsNotification | undefined;
    set internalValue(value: DataMongodbatlasAlertConfigurationsResultsNotification | undefined);
    get apiToken(): string;
    get channelName(): string;
    get datadogApiKey(): string;
    get datadogRegion(): string;
    get delayMin(): number;
    get emailAddress(): string;
    get emailEnabled(): cdktf.IResolvable;
    get flowName(): string;
    get flowdockApiToken(): string;
    get intervalMin(): number;
    get microsoftTeamsWebhookUrl(): string;
    get mobileNumber(): string;
    get opsGenieApiKey(): string;
    get opsGenieRegion(): string;
    get orgName(): string;
    get roles(): string[];
    get serviceKey(): string;
    get smsEnabled(): cdktf.IResolvable;
    get teamId(): string;
    get teamName(): string;
    get typeName(): string;
    get username(): string;
    get victorOpsApiKey(): string;
    get victorOpsRoutingKey(): string;
    get webhookSecret(): string;
    get webhookUrl(): string;
}
export declare class DataMongodbatlasAlertConfigurationsResultsNotificationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasAlertConfigurationsResultsNotificationOutputReference;
}
export interface DataMongodbatlasAlertConfigurationsResultsOutput {
}
export declare function dataMongodbatlasAlertConfigurationsResultsOutputToTerraform(struct?: DataMongodbatlasAlertConfigurationsResultsOutput): any;
export declare class DataMongodbatlasAlertConfigurationsResultsOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasAlertConfigurationsResultsOutput | undefined;
    set internalValue(value: DataMongodbatlasAlertConfigurationsResultsOutput | undefined);
    get label(): string;
    get type(): string;
    get value(): string;
}
export declare class DataMongodbatlasAlertConfigurationsResultsOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasAlertConfigurationsResultsOutputOutputReference;
}
export interface DataMongodbatlasAlertConfigurationsResultsThresholdConfig {
}
export declare function dataMongodbatlasAlertConfigurationsResultsThresholdConfigToTerraform(struct?: DataMongodbatlasAlertConfigurationsResultsThresholdConfig): any;
export declare class DataMongodbatlasAlertConfigurationsResultsThresholdConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasAlertConfigurationsResultsThresholdConfig | undefined;
    set internalValue(value: DataMongodbatlasAlertConfigurationsResultsThresholdConfig | undefined);
    get operator(): string;
    get threshold(): number;
    get units(): string;
}
export declare class DataMongodbatlasAlertConfigurationsResultsThresholdConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasAlertConfigurationsResultsThresholdConfigOutputReference;
}
export interface DataMongodbatlasAlertConfigurationsResults {
}
export declare function dataMongodbatlasAlertConfigurationsResultsToTerraform(struct?: DataMongodbatlasAlertConfigurationsResults): any;
export declare class DataMongodbatlasAlertConfigurationsResultsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasAlertConfigurationsResults | undefined;
    set internalValue(value: DataMongodbatlasAlertConfigurationsResults | undefined);
    get alertConfigurationId(): string;
    get created(): string;
    get enabled(): cdktf.IResolvable;
    get eventType(): string;
    private _matcher;
    get matcher(): DataMongodbatlasAlertConfigurationsResultsMatcherList;
    private _metricThreshold;
    get metricThreshold(): cdktf.StringMap;
    private _metricThresholdConfig;
    get metricThresholdConfig(): DataMongodbatlasAlertConfigurationsResultsMetricThresholdConfigList;
    private _notification;
    get notification(): DataMongodbatlasAlertConfigurationsResultsNotificationList;
    private _output;
    get output(): DataMongodbatlasAlertConfigurationsResultsOutputList;
    get projectId(): string;
    private _threshold;
    get threshold(): cdktf.StringMap;
    private _thresholdConfig;
    get thresholdConfig(): DataMongodbatlasAlertConfigurationsResultsThresholdConfigList;
    get updated(): string;
}
export declare class DataMongodbatlasAlertConfigurationsResultsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasAlertConfigurationsResultsOutputReference;
}
export interface DataMongodbatlasAlertConfigurationsListOptions {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/alert_configurations#include_count DataMongodbatlasAlertConfigurations#include_count}
    */
    readonly includeCount?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/alert_configurations#items_per_page DataMongodbatlasAlertConfigurations#items_per_page}
    */
    readonly itemsPerPage?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/d/alert_configurations#page_num DataMongodbatlasAlertConfigurations#page_num}
    */
    readonly pageNum?: number;
}
export declare function dataMongodbatlasAlertConfigurationsListOptionsToTerraform(struct?: DataMongodbatlasAlertConfigurationsListOptions | cdktf.IResolvable): any;
export declare class DataMongodbatlasAlertConfigurationsListOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataMongodbatlasAlertConfigurationsListOptions | cdktf.IResolvable | undefined;
    set internalValue(value: DataMongodbatlasAlertConfigurationsListOptions | cdktf.IResolvable | undefined);
    private _includeCount?;
    get includeCount(): boolean | cdktf.IResolvable;
    set includeCount(value: boolean | cdktf.IResolvable);
    resetIncludeCount(): void;
    get includeCountInput(): boolean | cdktf.IResolvable | undefined;
    private _itemsPerPage?;
    get itemsPerPage(): number;
    set itemsPerPage(value: number);
    resetItemsPerPage(): void;
    get itemsPerPageInput(): number | undefined;
    private _pageNum?;
    get pageNum(): number;
    set pageNum(value: number);
    resetPageNum(): void;
    get pageNumInput(): number | undefined;
}
export declare class DataMongodbatlasAlertConfigurationsListOptionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataMongodbatlasAlertConfigurationsListOptions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataMongodbatlasAlertConfigurationsListOptionsOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/mongodbatlas/d/alert_configurations mongodbatlas_alert_configurations}
*/
export declare class DataMongodbatlasAlertConfigurations extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "mongodbatlas_alert_configurations";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/mongodbatlas/d/alert_configurations mongodbatlas_alert_configurations} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataMongodbatlasAlertConfigurationsConfig
    */
    constructor(scope: Construct, id: string, config: DataMongodbatlasAlertConfigurationsConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _outputType?;
    get outputType(): string[];
    set outputType(value: string[]);
    resetOutputType(): void;
    get outputTypeInput(): string[] | undefined;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
    private _results;
    get results(): DataMongodbatlasAlertConfigurationsResultsList;
    get totalCount(): number;
    private _listOptions;
    get listOptions(): DataMongodbatlasAlertConfigurationsListOptionsList;
    putListOptions(value: DataMongodbatlasAlertConfigurationsListOptions[] | cdktf.IResolvable): void;
    resetListOptions(): void;
    get listOptionsInput(): cdktf.IResolvable | DataMongodbatlasAlertConfigurationsListOptions[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
